/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netcfglinks;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ONOSLLDP;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.ProbedLinkProvider;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.lldpcommon.LinkDiscovery;
import org.onosproject.provider.lldpcommon.LinkDiscoveryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetworkConfigLinksProvider
extends AbstractProvider
implements ProbedLinkProvider {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService masterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService metadataService;
    private static final String PROP_PROBE_RATE = "probeRate";
    private static final int DEFAULT_PROBE_RATE = 3000;
    @Property(name="probeRate", intValue={3000}, label="LLDP and BDDP probe rate specified in millis")
    private int probeRate = 3000;
    protected final Map<DeviceId, LinkDiscovery> discoverers = new ConcurrentHashMap<DeviceId, LinkDiscovery>();
    private final LinkDiscoveryContext context = new InternalDiscoveryContext();
    private LinkProviderService providerService;
    private static final String PROVIDER_NAME = "org.onosproject.provider.netcfglinks";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ApplicationId appId;
    private final InternalPacketProcessor packetProcessor = new InternalPacketProcessor();
    private final InternalDeviceListener deviceListener = new InternalDeviceListener();
    private final InternalConfigListener cfgListener = new InternalConfigListener();
    protected Set<LinkKey> configuredLinks = new HashSet<LinkKey>();

    public NetworkConfigLinksProvider() {
        super(new ProviderId("lldp", PROVIDER_NAME));
    }

    private String buildSrcMac() {
        String defMac;
        String srcMac = ProbedLinkProvider.fingerprintMac((ClusterMetadata)this.metadataService.getClusterMetadata());
        if (srcMac.equals(defMac = ProbedLinkProvider.defaultMac())) {
            this.log.warn("Couldn't generate fingerprint. Using default value {}", (Object)defMac);
            return defMac;
        }
        this.log.trace("Generated MAC address {}", (Object)srcMac);
        return srcMac;
    }

    private void createLinks() {
        this.netCfgService.getSubjects(LinkKey.class).forEach(linkKey -> this.configuredLinks.add((LinkKey)linkKey));
    }

    @Activate
    protected void activate() {
        this.log.info("Activated");
        this.appId = this.coreService.registerApplication(PROVIDER_NAME);
        this.packetService.addProcessor((PacketProcessor)this.packetProcessor, PacketProcessor.advisor((int)0));
        this.providerService = (LinkProviderService)this.providerRegistry.register((Provider)this);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.netCfgService.addListener((EventListener)this.cfgListener);
        this.requestIntercepts();
        this.loadDevices();
        this.createLinks();
    }

    @Deactivate
    protected void deactivate() {
        this.withdrawIntercepts();
        this.providerRegistry.unregister((Provider)this);
        this.disable();
        this.log.info("Deactivated");
    }

    private void loadDevices() {
        this.deviceService.getAvailableDevices().forEach(d -> this.updateDevice((Device)d).ifPresent(ld -> this.updatePorts((LinkDiscovery)ld, d.id())));
    }

    private Optional<LinkDiscovery> updateDevice(Device device) {
        if (device == null) {
            return Optional.empty();
        }
        LinkDiscovery ld = this.discoverers.computeIfAbsent(device.id(), did -> new LinkDiscovery(device, this.context));
        if (ld.isStopped()) {
            ld.start();
        }
        return Optional.of(ld);
    }

    private void updatePorts(LinkDiscovery discoverer, DeviceId deviceId) {
        this.deviceService.getPorts(deviceId).forEach(p -> this.updatePort(discoverer, (Port)p));
    }

    private void updatePort(LinkDiscovery discoverer, Port port) {
        if (port == null) {
            return;
        }
        if (port.number().isLogical()) {
            return;
        }
        discoverer.addPort(port);
    }

    private void disable() {
        this.providerRegistry.unregister((Provider)this);
        this.discoverers.values().forEach(LinkDiscovery::stop);
        this.discoverers.clear();
        this.providerService = null;
    }

    LinkKey extractLinkKey(PacketContext packetContext) {
        Ethernet eth = packetContext.inPacket().parsed();
        if (eth == null) {
            return null;
        }
        ONOSLLDP onoslldp = ONOSLLDP.parseONOSLLDP((Ethernet)eth);
        if (onoslldp != null) {
            PortNumber srcPort = PortNumber.portNumber((long)onoslldp.getPort().intValue());
            PortNumber dstPort = packetContext.inPacket().receivedFrom().port();
            DeviceId srcDeviceId = DeviceId.deviceId((String)onoslldp.getDeviceString());
            DeviceId dstDeviceId = packetContext.inPacket().receivedFrom().deviceId();
            ConnectPoint src = new ConnectPoint((ElementId)srcDeviceId, srcPort);
            ConnectPoint dst = new ConnectPoint((ElementId)dstDeviceId, dstPort);
            return LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        }
        return null;
    }

    private void removeDevice(DeviceId deviceId) {
        this.discoverers.computeIfPresent(deviceId, (did, ld) -> {
            ld.stop();
            return null;
        });
    }

    private void removePort(Port port) {
        if (port.element() instanceof Device) {
            Device d = (Device)port.element();
            LinkDiscovery ld = this.discoverers.get(d.id());
            if (ld != null) {
                ld.removePort(port.number());
            }
        } else {
            this.log.warn("Attempted to remove non-Device port", (Object)port);
        }
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_LLDP);
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId, Optional.empty());
        selector.matchEthType(Ethernet.TYPE_BSN);
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, this.appId, Optional.empty());
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_LLDP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId, Optional.empty());
        selector.matchEthType(Ethernet.TYPE_BSN);
        this.packetService.cancelPackets(selector.build(), PacketPriority.CONTROL, this.appId, Optional.empty());
    }

    protected void bindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.providerRegistry = linkProviderRegistry;
    }

    protected void unbindProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.providerRegistry == linkProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindMasterService(MastershipService mastershipService) {
        this.masterService = mastershipService;
    }

    protected void unbindMasterService(MastershipService mastershipService) {
        if (this.masterService == mastershipService) {
            this.masterService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.netCfgService = networkConfigRegistry;
    }

    protected void unbindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netCfgService == networkConfigRegistry) {
            this.netCfgService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMetadataService(ClusterMetadataService clusterMetadataService) {
        this.metadataService = clusterMetadataService;
    }

    protected void unbindMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.metadataService == clusterMetadataService) {
            this.metadataService = null;
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        private void addLink(LinkKey linkKey) {
            NetworkConfigLinksProvider.this.configuredLinks.add(linkKey);
        }

        private void removeLink(LinkKey linkKey) {
            DefaultLinkDescription linkDescription = new DefaultLinkDescription(linkKey.src(), linkKey.dst(), Link.Type.DIRECT, new SparseAnnotations[0]);
            NetworkConfigLinksProvider.this.configuredLinks.remove(linkKey);
            NetworkConfigLinksProvider.this.providerService.linkVanished((LinkDescription)linkDescription);
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass().equals(BasicLinkConfig.class)) {
                NetworkConfigLinksProvider.this.log.info("net config event of type {} for basic link {}", (Object)event.type(), event.subject());
                LinkKey linkKey = (LinkKey)event.subject();
                if (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED) {
                    this.addLink(linkKey);
                } else if (event.type() == NetworkConfigEvent.Type.CONFIG_REMOVED) {
                    this.removeLink(linkKey);
                }
                NetworkConfigLinksProvider.this.log.info("Link reconfigured");
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            if (event.type() == DeviceEvent.Type.PORT_STATS_UPDATED) {
                return;
            }
            Device device = (Device)event.subject();
            Port port = event.port();
            if (device == null) {
                NetworkConfigLinksProvider.this.log.error("Device is null.");
                return;
            }
            NetworkConfigLinksProvider.this.log.trace("{} {} {}", new Object[]{event.type(), event.subject(), event});
            DeviceId deviceId = device.id();
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: 
                case DEVICE_UPDATED: {
                    NetworkConfigLinksProvider.this.updateDevice(device).ifPresent(ld -> NetworkConfigLinksProvider.this.updatePorts(ld, deviceId));
                    break;
                }
                case PORT_ADDED: 
                case PORT_UPDATED: {
                    if (port.isEnabled()) {
                        NetworkConfigLinksProvider.this.updateDevice(device).ifPresent(ld -> NetworkConfigLinksProvider.this.updatePort(ld, port));
                        break;
                    }
                    NetworkConfigLinksProvider.this.log.debug("Port down {}", (Object)port);
                    NetworkConfigLinksProvider.this.removePort(port);
                    NetworkConfigLinksProvider.this.providerService.linksVanished(new ConnectPoint(port.element().id(), port.number()));
                    break;
                }
                case PORT_REMOVED: {
                    NetworkConfigLinksProvider.this.log.debug("Port removed {}", (Object)port);
                    NetworkConfigLinksProvider.this.removePort(port);
                    NetworkConfigLinksProvider.this.providerService.linksVanished(new ConnectPoint(port.element().id(), port.number()));
                    break;
                }
                case DEVICE_REMOVED: 
                case DEVICE_SUSPENDED: {
                    NetworkConfigLinksProvider.this.log.debug("Device removed {}", (Object)deviceId);
                    NetworkConfigLinksProvider.this.removeDevice(deviceId);
                    NetworkConfigLinksProvider.this.providerService.linksVanished(deviceId);
                    break;
                }
                case DEVICE_AVAILABILITY_CHANGED: {
                    if (NetworkConfigLinksProvider.this.deviceService.isAvailable(deviceId)) {
                        NetworkConfigLinksProvider.this.log.debug("Device up {}", (Object)deviceId);
                        NetworkConfigLinksProvider.this.updateDevice(device).ifPresent(ld -> NetworkConfigLinksProvider.this.updatePorts(ld, deviceId));
                        break;
                    }
                    NetworkConfigLinksProvider.this.log.debug("Device down {}", (Object)deviceId);
                    NetworkConfigLinksProvider.this.removeDevice(deviceId);
                    NetworkConfigLinksProvider.this.providerService.linksVanished(deviceId);
                    break;
                }
                case PORT_STATS_UPDATED: {
                    break;
                }
                default: {
                    NetworkConfigLinksProvider.this.log.debug("Unknown event {}", (Object)event);
                }
            }
        }
    }

    private class InternalPacketProcessor
    implements PacketProcessor {
        private InternalPacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context == null || context.isHandled()) {
                return;
            }
            Ethernet eth = context.inPacket().parsed();
            if (eth == null || eth.getEtherType() != Ethernet.TYPE_LLDP && eth.getEtherType() != Ethernet.TYPE_BSN) {
                return;
            }
            InboundPacket inPacket = context.inPacket();
            LinkKey linkKey = NetworkConfigLinksProvider.this.extractLinkKey(context);
            if (linkKey != null) {
                if (NetworkConfigLinksProvider.this.configuredLinks.contains(linkKey)) {
                    NetworkConfigLinksProvider.this.log.debug("Found configured link {}", (Object)linkKey);
                    LinkDiscovery ld = NetworkConfigLinksProvider.this.discoverers.get(inPacket.receivedFrom().deviceId());
                    if (ld == null) {
                        return;
                    }
                    if (ld.handleLldp(context)) {
                        context.block();
                    }
                } else {
                    NetworkConfigLinksProvider.this.log.debug("Found link that was not in the configuration {}", (Object)linkKey);
                    NetworkConfigLinksProvider.this.providerService.linkDetected((LinkDescription)new DefaultLinkDescription(linkKey.src(), linkKey.dst(), Link.Type.DIRECT, false, new SparseAnnotations[]{DefaultAnnotations.EMPTY}));
                }
            }
        }
    }

    private class InternalDiscoveryContext
    implements LinkDiscoveryContext {
        private InternalDiscoveryContext() {
        }

        public MastershipService mastershipService() {
            return NetworkConfigLinksProvider.this.masterService;
        }

        public LinkProviderService providerService() {
            return NetworkConfigLinksProvider.this.providerService;
        }

        public PacketService packetService() {
            return NetworkConfigLinksProvider.this.packetService;
        }

        public long probeRate() {
            return NetworkConfigLinksProvider.this.probeRate;
        }

        public boolean useBddp() {
            return true;
        }

        public void touchLink(LinkKey key) {
        }

        public String fingerprint() {
            return NetworkConfigLinksProvider.this.buildSrcMac();
        }

        public DeviceService deviceService() {
            return NetworkConfigLinksProvider.this.deviceService;
        }
    }
}

