/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.netconf.alarm;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProvider;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderRegistry;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmProviderService;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmTranslator;
import org.onosproject.net.DeviceId;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfDeviceInfo;
import org.onosproject.netconf.NetconfDeviceListener;
import org.onosproject.netconf.NetconfDeviceOutputEvent;
import org.onosproject.netconf.NetconfDeviceOutputEventListener;
import org.onosproject.netconf.NetconfSession;
import org.onosproject.netconf.ctl.NetconfDeviceOutputEventListenerImpl;
import org.onosproject.provider.netconf.alarm.NetconfAlarmTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class NetconfAlarmProvider
extends AbstractProvider
implements AlarmProvider {
    public static final String ACTIVE = "active";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AlarmTranslator translator = new NetconfAlarmTranslator();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected AlarmProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetconfController controller;
    protected AlarmProviderService providerService;
    private Map<DeviceId, InternalNotificationListener> idNotificationListenerMap = Maps.newHashMap();
    private NetconfDeviceListener deviceListener = new InnerDeviceListener();

    public NetconfAlarmProvider() {
        super(new ProviderId("netconf", "org.onosproject.netconf"));
    }

    @Activate
    public void activate() {
        this.providerService = (AlarmProviderService)this.providerRegistry.register((Provider)this);
        this.controller.getNetconfDevices().forEach(id -> {
            NetconfDevice device = this.controller.getNetconfDevice(id);
            NetconfSession session = device.getSession();
            InternalNotificationListener listener = new InternalNotificationListener(device.getDeviceInfo());
            session.addDeviceOutputListener((NetconfDeviceOutputEventListener)listener);
            this.idNotificationListenerMap.put((DeviceId)id, listener);
        });
        this.controller.addDeviceListener(this.deviceListener);
        this.log.info("NetconfAlarmProvider Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.idNotificationListenerMap.forEach((id, listener) -> this.controller.getNetconfDevice(id).getSession().removeDeviceOutputListener((NetconfDeviceOutputEventListener)listener));
        this.controller.removeDeviceListener(this.deviceListener);
        this.providerService = null;
        this.log.info("NetconfAlarmProvider Stopped");
    }

    public void triggerProbe(DeviceId deviceId) {
        this.log.debug("Alarm probe triggered with " + deviceId);
    }

    private void triggerProbe(DeviceId deviceId, Collection<Alarm> alarms) {
        this.providerService.updateAlarmList(deviceId, alarms);
        this.triggerProbe(deviceId);
    }

    protected void bindProviderRegistry(AlarmProviderRegistry alarmProviderRegistry) {
        this.providerRegistry = alarmProviderRegistry;
    }

    protected void unbindProviderRegistry(AlarmProviderRegistry alarmProviderRegistry) {
        if (this.providerRegistry == alarmProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(NetconfController netconfController) {
        this.controller = netconfController;
    }

    protected void unbindController(NetconfController netconfController) {
        if (this.controller == netconfController) {
            this.controller = null;
        }
    }

    private class InnerDeviceListener
    implements NetconfDeviceListener {
        private InnerDeviceListener() {
        }

        public void deviceAdded(DeviceId deviceId) {
            NetconfDevice device = NetconfAlarmProvider.this.controller.getNetconfDevice(deviceId);
            NetconfSession session = device.getSession();
            InternalNotificationListener listener = new InternalNotificationListener(device.getDeviceInfo());
            session.addDeviceOutputListener((NetconfDeviceOutputEventListener)listener);
            NetconfAlarmProvider.this.idNotificationListenerMap.put(deviceId, listener);
        }

        public void deviceRemoved(DeviceId deviceId) {
            NetconfAlarmProvider.this.idNotificationListenerMap.remove(deviceId);
        }
    }

    private class InternalNotificationListener
    extends NetconfDeviceOutputEventListenerImpl
    implements NetconfDeviceOutputEventListener {
        InternalNotificationListener(NetconfDeviceInfo deviceInfo) {
            super(deviceInfo);
        }

        public void event(NetconfDeviceOutputEvent event) {
            if (event.type() == NetconfDeviceOutputEvent.Type.DEVICE_NOTIFICATION) {
                DeviceId deviceId = event.getDeviceInfo().getDeviceId();
                String message = event.getMessagePayload();
                ByteArrayInputStream in = new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8));
                Collection newAlarms = NetconfAlarmProvider.this.translator.translateToAlarm(deviceId, (InputStream)in);
                NetconfAlarmProvider.this.triggerProbe(deviceId, newAlarms);
            }
        }
    }
}

