/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.provider.nil.CustomTopologySimulator;
import org.onosproject.provider.nil.NullProviders;
import org.onosproject.provider.nil.TopologySimulator;

@Command(scope="onos", name="null-create-device", description="Adds a simulated device to the custom topology simulation")
public class CreateNullDevice
extends AbstractShellCommand {
    @Argument(index=0, name="type", description="Device type, e.g. switch, roadm", required=true, multiValued=false)
    String type = null;
    @Argument(index=1, name="name", description="Device name", required=true, multiValued=false)
    String name = null;
    @Argument(index=2, name="portCount", description="Port count", required=true, multiValued=false)
    Integer portCount = null;
    @Argument(index=3, name="latitude", description="Geo latitude", required=true, multiValued=false)
    Double latitude = null;
    @Argument(index=4, name="longitude", description="Geo longitude", required=true, multiValued=false)
    Double longitude = null;

    protected void execute() {
        NullProviders service = (NullProviders)CreateNullDevice.get(NullProviders.class);
        NetworkConfigService cfgService = (NetworkConfigService)CreateNullDevice.get(NetworkConfigService.class);
        TopologySimulator simulator = service.currentSimulator();
        if (!(simulator instanceof CustomTopologySimulator)) {
            this.error("Custom topology simulator is not active.", new Object[0]);
            return;
        }
        CustomTopologySimulator sim = (CustomTopologySimulator)simulator;
        DeviceId deviceId = sim.nextDeviceId();
        BasicDeviceConfig cfg = (BasicDeviceConfig)cfgService.addConfig((Object)deviceId, BasicDeviceConfig.class);
        cfg.name(this.name);
        if (this.latitude != 0.0 && this.longitude != 0.0) {
            cfg.latitude(this.latitude);
            cfg.longitude(this.longitude);
        }
        cfg.apply();
        sim.createDevice(deviceId, this.name, Device.Type.valueOf((String)this.type.toUpperCase()), (int)this.portCount);
    }
}

