/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.nil.TopologySimulator;

public class FatTreeTopologySimulator
extends TopologySimulator {
    private static final int DEFAULT_NUMBER_OF_PORTS_PER_SWITCH = 4;
    protected int kPorts;
    protected int numberOfPods;
    protected int numberOfAggLayerSwitches;
    protected int numberOfCoreLayerSwitches;
    protected int numberOfEdgeLayerSwitches;

    @Override
    protected void processTopoShape(String shape) {
        int k;
        super.processTopoShape(shape);
        this.kPorts = k = this.topoShape.length == 1 ? 4 : Integer.parseInt(this.topoShape[1]);
        this.numberOfPods = k;
        this.numberOfCoreLayerSwitches = k / 2 * (k / 2);
        this.numberOfAggLayerSwitches = k * k / 2;
        this.numberOfEdgeLayerSwitches = k * k / 2;
        this.hostCount = this.kPorts / 2;
    }

    @Override
    public void setUpTopology() {
        Preconditions.checkArgument((this.kPorts > 1 ? 1 : 0) != 0, (Object)"Fat Tree switches must have at **least** 2 ports each!");
        this.deviceCount = this.numberOfAggLayerSwitches + this.numberOfCoreLayerSwitches + this.numberOfEdgeLayerSwitches;
        this.log.info("Booting a {} with {}-ports, {} switches in total {} pods", new Object[]{this.topoShape[0], this.kPorts, this.deviceCount, this.numberOfPods});
        this.prepareForDeviceEvents(this.deviceCount);
        this.createDevices();
        this.waitForDeviceEvents();
        this.createLinks();
        this.createHosts();
    }

    @Override
    protected void createLinks() {
        int j;
        int i;
        int x;
        int[] portList = new int[this.deviceCount];
        Arrays.fill(portList, 0);
        int end = this.numberOfPods / 2;
        int startOfCore = 0;
        int startOfAgg = this.numberOfPods / 2 * (this.numberOfPods / 2);
        int startOfEdge = startOfAgg + this.numberOfPods * this.numberOfPods / 2;
        this.log.debug("startOfCore = {}, startOfAgg = {}, startOfEdge = {}", new Object[]{startOfCore, startOfAgg, startOfEdge});
        for (x = 0; x < this.numberOfAggLayerSwitches; x += end) {
            for (i = 0; i < end; ++i) {
                for (j = 0; j < end; ++j) {
                    int coreSwitch = i * end + j;
                    int aggSwitch = startOfAgg + x + i;
                    int n = coreSwitch;
                    int n2 = portList[n];
                    portList[n] = n2 + 1;
                    int n3 = aggSwitch;
                    int n4 = portList[n3];
                    portList[n3] = n4 + 1;
                    this.createLink(coreSwitch, aggSwitch, n2, n4);
                }
            }
        }
        for (x = 0; x < this.numberOfAggLayerSwitches; x += end) {
            for (i = 0; i < end; ++i) {
                for (j = 0; j < end; ++j) {
                    int aggSwitch = startOfAgg + x + i;
                    int edgeSwitch = startOfEdge + x + j;
                    int n = aggSwitch;
                    int n5 = portList[n];
                    portList[n] = n5 + 1;
                    int n6 = edgeSwitch;
                    int n7 = portList[n6];
                    portList[n6] = n7 + 1;
                    this.createLink(aggSwitch, edgeSwitch, n5, n7);
                }
            }
        }
    }

    @Override
    protected void createHosts() {
        int firstEdgeSwitch;
        for (int edgeSwitch = firstEdgeSwitch = this.numberOfPods / 2 * (this.numberOfPods / 2) + this.numberOfPods * this.numberOfPods / 2; edgeSwitch < this.deviceCount; ++edgeSwitch) {
            this.createHosts((DeviceId)this.deviceIds.get(edgeSwitch), this.kPorts / 2);
        }
    }
}

