/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.IPacket;
import org.onlab.util.Timer;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.ElementId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProvider;
import org.onosproject.net.packet.PacketProviderService;
import org.onosproject.provider.nil.NullProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NullPacketProvider
extends NullProviders.AbstractNullProvider
implements PacketProvider {
    private static final int INITIAL_DELAY = 5;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int SRC_HOST = 2;
    private static final int DST_HOST = 5;
    private int delay;
    private HostService hostService;
    private PacketProviderService providerService;
    private List<Device> devices;
    private int currentDevice = 0;
    private HashedWheelTimer timer = Timer.getTimer();
    private Timeout timeout;

    NullPacketProvider() {
    }

    void start(int packetRate, HostService hostService, DeviceAdminService deviceService, PacketProviderService providerService) {
        this.hostService = hostService;
        this.providerService = providerService;
        this.devices = ImmutableList.copyOf((Iterable)deviceService.getDevices()).stream().filter(d -> deviceService.getRole(d.id()) == MastershipRole.MASTER).collect(Collectors.toList());
        this.adjustRate(packetRate);
        this.timeout = this.timer.newTimeout((TimerTask)new PacketDriverTask(), 5L, TimeUnit.SECONDS);
    }

    void adjustRate(int packetRate) {
        boolean needsRestart = this.delay == 0 && packetRate > 0;
        int n = this.delay = packetRate > 0 ? 1000 / packetRate : 0;
        if (needsRestart) {
            this.timeout = this.timer.newTimeout((TimerTask)new PacketDriverTask(), 1L, TimeUnit.MILLISECONDS);
        }
        this.log.info("Settings: packetRate={}, delay={}", (Object)packetRate, (Object)this.delay);
    }

    void stop() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    public void emit(OutboundPacket packet) {
    }

    private final class NullPacketContext
    extends DefaultPacketContext {
        private NullPacketContext(InboundPacket inPkt, OutboundPacket outPkt) {
            super(System.currentTimeMillis(), inPkt, outPkt, false);
        }

        public void send() {
        }
    }

    private class PacketDriverTask
    implements TimerTask {
        ICMP icmp = new ICMP();
        Ethernet eth;

        PacketDriverTask() {
            this.icmp.setIcmpType((byte)8).setIcmpCode((byte)0).setChecksum((short)0);
            this.eth = new Ethernet();
            this.eth.setEtherType(Ethernet.TYPE_IPV4);
            this.eth.setPayload((IPacket)this.icmp);
        }

        public void run(Timeout to) {
            if (!NullPacketProvider.this.devices.isEmpty() && !to.isCancelled() && NullPacketProvider.this.delay > 0) {
                this.sendEvent((Device)NullPacketProvider.this.devices.get(Math.min(NullPacketProvider.this.currentDevice, NullPacketProvider.this.devices.size() - 1)));
                NullPacketProvider.this.currentDevice = (NullPacketProvider.this.currentDevice + 1) % NullPacketProvider.this.devices.size();
                NullPacketProvider.this.timeout = NullPacketProvider.this.timer.newTimeout(to.getTask(), (long)NullPacketProvider.this.delay, TimeUnit.MILLISECONDS);
            }
        }

        private void sendEvent(Device device) {
            this.eth.setSourceMACAddress("00:00:00:10:00:02").setDestinationMACAddress("00:00:00:10:00:05");
            DefaultInboundPacket inPkt = new DefaultInboundPacket(new ConnectPoint((ElementId)device.id(), PortNumber.portNumber((long)2L)), this.eth, ByteBuffer.wrap(this.eth.serialize()));
            NullPacketProvider.this.providerService.processPacket((PacketContext)new NullPacketContext((InboundPacket)inPkt, null));
        }
    }
}

