/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Objects;
import java.util.Properties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleProviderRegistry;
import org.onosproject.net.flow.FlowRuleProviderService;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderRegistry;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderRegistry;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.PacketProviderRegistry;
import org.onosproject.net.packet.PacketProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.nil.AggLinkTopologySimulator;
import org.onosproject.provider.nil.CentipedeTopologySimulator;
import org.onosproject.provider.nil.ConfiguredTopologySimulator;
import org.onosproject.provider.nil.CustomTopologySimulator;
import org.onosproject.provider.nil.FatTreeTopologySimulator;
import org.onosproject.provider.nil.GridTopologySimulator;
import org.onosproject.provider.nil.LinearTopologySimulator;
import org.onosproject.provider.nil.MeshTopologySimulator;
import org.onosproject.provider.nil.NullFlowRuleProvider;
import org.onosproject.provider.nil.NullPacketProvider;
import org.onosproject.provider.nil.RerouteTopologySimulator;
import org.onosproject.provider.nil.SpineLeafTopologySimulator;
import org.onosproject.provider.nil.TopologyMutationDriver;
import org.onosproject.provider.nil.TopologySimulator;
import org.onosproject.provider.nil.TreeTopologySimulator;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={NullProviders.class})
public class NullProviders {
    private static final Logger log = LoggerFactory.getLogger(NullProviders.class);
    static final String SCHEME = "null";
    static final String PROVIDER_ID = "org.onosproject.provider.nil";
    private static final String FORMAT = "Settings: enabled={}, topoShape={}, deviceCount={}, hostCount={}, packetRate={}, mutationRate={}";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipAdminService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceAdminService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry deviceProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostProviderRegistry hostProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkProviderRegistry linkProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleProviderRegistry flowRuleProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketProviderRegistry packetProviderRegistry;
    private final NullDeviceProvider deviceProvider = new NullDeviceProvider();
    private final NullLinkProvider linkProvider = new NullLinkProvider();
    private final NullHostProvider hostProvider = new NullHostProvider();
    private final NullFlowRuleProvider flowRuleProvider = new NullFlowRuleProvider();
    private final NullPacketProvider packetProvider = new NullPacketProvider();
    private final TopologyMutationDriver topologyMutationDriver = new TopologyMutationDriver();
    private DeviceProviderService deviceProviderService;
    private HostProviderService hostProviderService;
    private LinkProviderService linkProviderService;
    private FlowRuleProviderService flowRuleProviderService;
    private PacketProviderService packetProviderService;
    private TopologySimulator simulator;
    @Property(name="enabled", boolValue={false}, label="Enables or disables the provider")
    private boolean enabled = false;
    private static final String DEFAULT_TOPO_SHAPE = "configured";
    @Property(name="topoShape", value={"configured"}, label="Topology shape: configured, linear, reroute, tree, spineleaf, mesh, grid")
    private String topoShape = "configured";
    private static final int DEFAULT_DEVICE_COUNT = 10;
    @Property(name="deviceCount", intValue={10}, label="Number of devices to generate")
    private int deviceCount = 10;
    private static final int DEFAULT_HOST_COUNT = 5;
    @Property(name="hostCount", intValue={5}, label="Number of host to generate per device")
    private int hostCount = 5;
    private static final int DEFAULT_PACKET_RATE = 0;
    @Property(name="packetRate", intValue={0}, label="Packet-in/s rate; 0 for no packets")
    private int packetRate = 0;
    private static final double DEFAULT_MUTATION_RATE = 0.0;
    @Property(name="mutationRate", doubleValue={0.0}, label="Link event/s topology mutation rate; 0 for no mutations")
    private double mutationRate = 0.0;
    private static final String DEFAULT_MASTERSHIP = "random";
    @Property(name="mastership", value={"random"}, label="Mastership given as 'random' or 'node1=dpid,dpid/node2=dpid,...'")
    private String mastership = "random";

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.deviceProviderService = (DeviceProviderService)this.deviceProviderRegistry.register((Provider)this.deviceProvider);
        this.hostProviderService = (HostProviderService)this.hostProviderRegistry.register((Provider)this.hostProvider);
        this.linkProviderService = (LinkProviderService)this.linkProviderRegistry.register((Provider)this.linkProvider);
        this.flowRuleProviderService = (FlowRuleProviderService)this.flowRuleProviderRegistry.register((Provider)this.flowRuleProvider);
        this.packetProviderService = (PacketProviderService)this.packetProviderRegistry.register((Provider)this.packetProvider);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.tearDown();
        this.deviceProviderRegistry.unregister((Provider)this.deviceProvider);
        this.hostProviderRegistry.unregister((Provider)this.hostProvider);
        this.linkProviderRegistry.unregister((Provider)this.linkProvider);
        this.flowRuleProviderRegistry.unregister((Provider)this.flowRuleProvider);
        this.packetProviderRegistry.unregister((Provider)this.packetProvider);
        this.deviceProviderService = null;
        this.hostProviderService = null;
        this.linkProviderService = null;
        this.flowRuleProviderService = null;
        this.packetProviderService = null;
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        double newMutationRate;
        int newPacketRate;
        int newHostCount;
        int newDeviceCount;
        String newMastership;
        String newTopoShape;
        boolean newEnabled;
        Dictionary properties = context != null ? context.getProperties() : new Properties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"enabled");
            newEnabled = Strings.isNullOrEmpty((String)s) ? this.enabled : Boolean.parseBoolean(s.trim());
            newTopoShape = Tools.get((Dictionary)properties, (String)"topoShape");
            newMastership = Tools.get((Dictionary)properties, (String)"mastership");
            s = Tools.get((Dictionary)properties, (String)"deviceCount");
            newDeviceCount = Strings.isNullOrEmpty((String)s) ? this.deviceCount : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"hostCount");
            newHostCount = Strings.isNullOrEmpty((String)s) ? this.hostCount : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"packetRate");
            newPacketRate = Strings.isNullOrEmpty((String)s) ? this.packetRate : Integer.parseInt(s.trim());
            s = Tools.get((Dictionary)properties, (String)"mutationRate");
            newMutationRate = Strings.isNullOrEmpty((String)s) ? this.mutationRate : Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            log.warn(e.getMessage());
            newEnabled = this.enabled;
            newTopoShape = this.topoShape;
            newDeviceCount = this.deviceCount;
            newHostCount = this.hostCount;
            newPacketRate = this.packetRate;
            newMutationRate = this.mutationRate;
            newMastership = this.mastership;
        }
        if (newEnabled != this.enabled || !Objects.equals(newTopoShape, this.topoShape) || newDeviceCount != this.deviceCount || newHostCount != this.hostCount) {
            this.enabled = newEnabled;
            this.topoShape = newTopoShape;
            this.deviceCount = newDeviceCount;
            this.hostCount = newHostCount;
            this.packetRate = newPacketRate;
            this.mutationRate = newMutationRate;
            this.restartSimulation();
        }
        if (newPacketRate != this.packetRate || newMutationRate != this.mutationRate) {
            this.packetRate = newPacketRate;
            this.mutationRate = newMutationRate;
            this.adjustRates();
        }
        if (!Objects.equals(newMastership, this.mastership)) {
            this.mastership = newMastership;
            this.reassignMastership();
        }
        log.info(FORMAT, new Object[]{this.enabled, this.topoShape, this.deviceCount, this.hostCount, this.packetRate, this.mutationRate});
    }

    public TopologySimulator currentSimulator() {
        return this.simulator;
    }

    public void severLink(ConnectPoint one, ConnectPoint two) {
        if (this.enabled) {
            this.topologyMutationDriver.severLink(one, two);
        }
    }

    public void repairLink(ConnectPoint one, ConnectPoint two) {
        if (this.enabled) {
            this.topologyMutationDriver.repairLink(one, two);
        }
    }

    public void failDevice(DeviceId deviceId) {
        if (this.enabled) {
            this.topologyMutationDriver.failDevice(deviceId);
        }
    }

    public void repairDevice(DeviceId deviceId) {
        if (this.enabled) {
            this.topologyMutationDriver.repairDevice(deviceId);
        }
    }

    private void restartSimulation() {
        this.tearDown();
        if (this.enabled) {
            this.setUp();
        }
    }

    private void setUp() {
        this.simulator = this.selectSimulator(this.topoShape);
        this.simulator.init(this.topoShape, this.deviceCount, this.hostCount, (ServiceDirectory)new DefaultServiceDirectory(), this.deviceProviderService, this.hostProviderService, this.linkProviderService);
        this.flowRuleProvider.start(this.flowRuleProviderService);
        this.packetProvider.start(this.packetRate, this.hostService, this.deviceService, this.packetProviderService);
        this.simulator.setUpTopology();
        this.topologyMutationDriver.start(this.mutationRate, this.linkService, (DeviceService)this.deviceService, this.linkProviderService, this.deviceProviderService, this.simulator);
    }

    private TopologySimulator selectSimulator(String topoShape) {
        if (topoShape.matches("linear([,].*|$)")) {
            return new LinearTopologySimulator();
        }
        if (topoShape.matches("centipede([,].*|$)")) {
            return new CentipedeTopologySimulator();
        }
        if (topoShape.matches("reroute([,].*|$)")) {
            return new RerouteTopologySimulator();
        }
        if (topoShape.matches("tree([,].*|$)")) {
            return new TreeTopologySimulator();
        }
        if (topoShape.matches("agglink([,].*|$)")) {
            return new AggLinkTopologySimulator();
        }
        if (topoShape.matches("spineleaf([,].*|$)")) {
            return new SpineLeafTopologySimulator();
        }
        if (topoShape.matches("mesh([,].*|$)")) {
            return new MeshTopologySimulator();
        }
        if (topoShape.matches("grid([,].*|$)")) {
            return new GridTopologySimulator();
        }
        if (topoShape.matches("fattree([,].*|$)")) {
            return new FatTreeTopologySimulator();
        }
        if (topoShape.matches("custom([,].*|$)")) {
            return new CustomTopologySimulator();
        }
        return new ConfiguredTopologySimulator();
    }

    private void tearDown() {
        if (this.simulator != null) {
            this.topologyMutationDriver.stop();
            this.packetProvider.stop();
            this.flowRuleProvider.stop();
            Tools.delay((int)500);
            this.simulator.tearDownTopology();
            this.simulator = null;
        }
    }

    private void adjustRates() {
        this.packetProvider.adjustRate(this.packetRate);
        this.topologyMutationDriver.adjustRate(this.mutationRate);
    }

    private void reassignMastership() {
        if (this.mastership.equals(DEFAULT_MASTERSHIP)) {
            this.mastershipService.balanceRoles();
        } else {
            NodeId localNode = this.clusterService.getLocalNode().id();
            this.rejectMastership();
            String[] nodeSpecs = this.mastership.split("/");
            for (int i = 0; i < nodeSpecs.length; ++i) {
                String[] ids;
                String[] specs = nodeSpecs[i].split("=");
                if (!specs[0].equals(localNode.toString())) continue;
                for (String id : ids = specs[1].split(",")) {
                    this.mastershipService.setRole(localNode, DeviceId.deviceId((String)id), MastershipRole.MASTER);
                }
                break;
            }
        }
    }

    private void rejectMastership() {
        NodeId localNode = this.clusterService.getLocalNode().id();
        this.deviceService.getDevices().forEach(device -> this.mastershipService.setRole(localNode, device.id(), MastershipRole.NONE));
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindMastershipService(MastershipAdminService mastershipAdminService) {
        this.mastershipService = mastershipAdminService;
    }

    protected void unbindMastershipService(MastershipAdminService mastershipAdminService) {
        if (this.mastershipService == mastershipAdminService) {
            this.mastershipService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindDeviceService(DeviceAdminService deviceAdminService) {
        this.deviceService = deviceAdminService;
    }

    protected void unbindDeviceService(DeviceAdminService deviceAdminService) {
        if (this.deviceService == deviceAdminService) {
            this.deviceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.deviceProviderRegistry = deviceProviderRegistry;
    }

    protected void unbindDeviceProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.deviceProviderRegistry == deviceProviderRegistry) {
            this.deviceProviderRegistry = null;
        }
    }

    protected void bindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        this.hostProviderRegistry = hostProviderRegistry;
    }

    protected void unbindHostProviderRegistry(HostProviderRegistry hostProviderRegistry) {
        if (this.hostProviderRegistry == hostProviderRegistry) {
            this.hostProviderRegistry = null;
        }
    }

    protected void bindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        this.linkProviderRegistry = linkProviderRegistry;
    }

    protected void unbindLinkProviderRegistry(LinkProviderRegistry linkProviderRegistry) {
        if (this.linkProviderRegistry == linkProviderRegistry) {
            this.linkProviderRegistry = null;
        }
    }

    protected void bindFlowRuleProviderRegistry(FlowRuleProviderRegistry flowRuleProviderRegistry) {
        this.flowRuleProviderRegistry = flowRuleProviderRegistry;
    }

    protected void unbindFlowRuleProviderRegistry(FlowRuleProviderRegistry flowRuleProviderRegistry) {
        if (this.flowRuleProviderRegistry == flowRuleProviderRegistry) {
            this.flowRuleProviderRegistry = null;
        }
    }

    protected void bindPacketProviderRegistry(PacketProviderRegistry packetProviderRegistry) {
        this.packetProviderRegistry = packetProviderRegistry;
    }

    protected void unbindPacketProviderRegistry(PacketProviderRegistry packetProviderRegistry) {
        if (this.packetProviderRegistry == packetProviderRegistry) {
            this.packetProviderRegistry = null;
        }
    }

    private class NullLinkProvider
    extends AbstractNullProvider
    implements LinkProvider {
        private NullLinkProvider() {
        }
    }

    private class NullHostProvider
    extends AbstractNullProvider
    implements HostProvider {
        private NullHostProvider() {
        }

        public void triggerProbe(Host host) {
        }
    }

    private class NullDeviceProvider
    extends AbstractNullProvider
    implements DeviceProvider {
        private NullDeviceProvider() {
        }

        public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
            NullProviders.this.deviceProviderService.receivedRoleReply(deviceId, newRole, newRole);
        }

        public boolean isReachable(DeviceId deviceId) {
            return NullProviders.this.topoShape.equals("custom") || NullProviders.this.simulator != null && NullProviders.this.simulator.contains(deviceId) && NullProviders.this.topologyMutationDriver.isReachable(deviceId);
        }

        public void triggerProbe(DeviceId deviceId) {
        }

        public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        }
    }

    static abstract class AbstractNullProvider
    extends AbstractProvider {
        protected AbstractNullProvider() {
            super(new ProviderId(NullProviders.SCHEME, NullProviders.PROVIDER_ID));
        }
    }
}

