/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.link.LinkService;
import org.onosproject.provider.nil.TopologySimulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopologyMutationDriver
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int WAIT_DELAY = 2000;
    private static final int MAX_DOWN_LINKS = 5;
    private final Random random = new Random();
    private volatile boolean stopped = true;
    private double mutationRate;
    private int millis;
    private int nanos;
    private LinkService linkService;
    private DeviceService deviceService;
    private LinkProviderService linkProviderService;
    private DeviceProviderService deviceProviderService;
    private TopologySimulator simulator;
    private List<LinkDescription> activeLinks;
    private List<LinkDescription> inactiveLinks;
    private final ExecutorService executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/null", (String)"topo-mutator", (Logger)this.log));
    private Map<DeviceId, Set<Link>> savedLinks = Maps.newConcurrentMap();

    TopologyMutationDriver() {
    }

    void start(double mutationRate, LinkService linkService, DeviceService deviceService, LinkProviderService linkProviderService, DeviceProviderService deviceProviderService, TopologySimulator simulator) {
        this.savedLinks.clear();
        this.stopped = false;
        this.linkService = linkService;
        this.deviceService = deviceService;
        this.linkProviderService = linkProviderService;
        this.deviceProviderService = deviceProviderService;
        this.simulator = simulator;
        this.activeLinks = this.reduceLinks();
        this.inactiveLinks = Lists.newArrayList();
        this.adjustRate(mutationRate);
        this.executor.execute(this);
    }

    void adjustRate(double mutationRate) {
        this.mutationRate = mutationRate;
        if (mutationRate > 0.0) {
            this.millis = (int)(1000.0 / mutationRate / 2.0);
            this.nanos = (int)(1000000.0 / mutationRate / 2.0) % 1000000;
        } else {
            this.millis = 0;
            this.nanos = 0;
        }
        this.log.info("Settings: millis={}, nanos={}", (Object)this.millis, (Object)this.nanos);
    }

    void stop() {
        this.stopped = true;
    }

    void severLink(ConnectPoint one, ConnectPoint two) {
        DefaultLinkDescription link = new DefaultLinkDescription(one, two, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.linkProviderService.linkVanished((LinkDescription)link);
        this.linkProviderService.linkVanished(this.reverse((LinkDescription)link));
    }

    void repairLink(ConnectPoint one, ConnectPoint two) {
        DefaultLinkDescription link = new DefaultLinkDescription(one, two, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.linkProviderService.linkDetected((LinkDescription)link);
        this.linkProviderService.linkDetected(this.reverse((LinkDescription)link));
    }

    void failDevice(DeviceId deviceId) {
        this.savedLinks.put(deviceId, this.linkService.getDeviceLinks(deviceId));
        this.deviceProviderService.deviceDisconnected(deviceId);
    }

    void repairDevice(DeviceId deviceId) {
        int chassisId = Integer.parseInt(deviceId.uri().getSchemeSpecificPart());
        this.simulator.createDevice(deviceId, chassisId);
        Set<Link> links = this.savedLinks.remove(deviceId);
        if (links != null) {
            links.forEach(l -> this.linkProviderService.linkDetected((LinkDescription)new DefaultLinkDescription(l.src(), l.dst(), Link.Type.DIRECT, new SparseAnnotations[0])));
        }
    }

    boolean isReachable(DeviceId deviceId) {
        return !this.savedLinks.containsKey(deviceId);
    }

    @Override
    public void run() {
        Tools.delay((int)2000);
        while (!this.stopped) {
            if (this.mutationRate > 0.0 && this.inactiveLinks.isEmpty()) {
                this.primeInactiveLinks();
                continue;
            }
            if (this.mutationRate <= 0.0 && !this.inactiveLinks.isEmpty()) {
                this.repairInactiveLinks();
                continue;
            }
            if (this.inactiveLinks.isEmpty()) {
                Tools.delay((int)2000);
                continue;
            }
            this.activeLinks.add(this.repairLink());
            this.pause();
            this.inactiveLinks.add(this.severLink());
            this.pause();
        }
    }

    private void primeInactiveLinks() {
        int n = Math.min(5, this.activeLinks.size());
        for (int i = 0; i < n; ++i) {
            this.inactiveLinks.add(this.severLink());
        }
    }

    private void repairInactiveLinks() {
        while (!this.inactiveLinks.isEmpty()) {
            this.repairLink();
        }
    }

    private LinkDescription severLink() {
        LinkDescription link = this.getRandomLink(this.activeLinks);
        this.linkProviderService.linkVanished(link);
        this.linkProviderService.linkVanished(this.reverse(link));
        return link;
    }

    private LinkDescription repairLink() {
        LinkDescription link = this.getRandomLink(this.inactiveLinks);
        this.linkProviderService.linkDetected(link);
        this.linkProviderService.linkDetected(this.reverse(link));
        return link;
    }

    private LinkDescription reverse(LinkDescription link) {
        return new DefaultLinkDescription(link.dst(), link.src(), link.type(), new SparseAnnotations[0]);
    }

    private LinkDescription getRandomLink(List<LinkDescription> links) {
        return links.remove(this.random.nextInt(links.size()));
    }

    private List<LinkDescription> reduceLinks() {
        ArrayList links = Lists.newArrayList();
        this.linkService.getLinks().forEach(link -> links.add(TopologySimulator.description(link)));
        return links.stream().filter(this::isOurLink).filter(this::isRightDirection).collect(Collectors.toList());
    }

    private boolean isOurLink(LinkDescription linkDescription) {
        return this.deviceService.getRole(linkDescription.src().deviceId()) == MastershipRole.MASTER;
    }

    private boolean isRightDirection(LinkDescription link) {
        return link.src().deviceId().toString().compareTo(link.dst().deviceId().toString()) > 0;
    }

    private void pause() {
        Tools.delay((int)this.millis, (int)this.nanos);
    }
}

