/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.nil.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicHostConfig;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.host.HostService;
import org.onosproject.provider.nil.CustomTopologySimulator;
import org.onosproject.provider.nil.NullProviders;
import org.onosproject.provider.nil.TopologySimulator;

@Command(scope="onos", name="null-create-host", description="Adds a simulated end-station host to the custom topology simulation")
public class CreateNullHost
extends AbstractShellCommand {
    @Argument(index=0, name="deviceName", description="Name of device where host is attached", required=true, multiValued=false)
    String deviceName = null;
    @Argument(index=1, name="hostIp", description="Host IP address", required=true, multiValued=false)
    String hostIp = null;
    @Argument(index=2, name="latitude", description="Geo latitude", required=true, multiValued=false)
    Double latitude = null;
    @Argument(index=3, name="longitude", description="Geo longitude", required=true, multiValued=false)
    Double longitude = null;

    protected void execute() {
        NullProviders service = (NullProviders)CreateNullHost.get(NullProviders.class);
        NetworkConfigService cfgService = (NetworkConfigService)CreateNullHost.get(NetworkConfigService.class);
        TopologySimulator simulator = service.currentSimulator();
        if (!(simulator instanceof CustomTopologySimulator)) {
            this.error("Custom topology simulator is not active.", new Object[0]);
            return;
        }
        CustomTopologySimulator sim = (CustomTopologySimulator)simulator;
        DeviceId deviceId = sim.deviceId(this.deviceName);
        HostId id = sim.nextHostId();
        HostLocation location = this.findAvailablePort(deviceId);
        BasicHostConfig cfg = (BasicHostConfig)cfgService.addConfig((Object)id, BasicHostConfig.class);
        cfg.latitude(this.latitude);
        cfg.longitude(this.longitude);
        cfg.apply();
        sim.createHost(id, location, IpAddress.valueOf((String)this.hostIp));
    }

    private HostLocation findAvailablePort(DeviceId deviceId) {
        EdgePortService eps = (EdgePortService)CreateNullHost.get(EdgePortService.class);
        HostService hs = (HostService)CreateNullHost.get(HostService.class);
        for (ConnectPoint point : eps.getEdgePoints(deviceId)) {
            if (!hs.getConnectedHosts(point).isEmpty()) continue;
            return new HostLocation(point, System.currentTimeMillis());
        }
        return null;
    }
}

