/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Frequency;
import org.onlab.util.Spectrum;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.LambdaQuery;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DefaultPortStatistics;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.optical.device.OchPortHelper;
import org.onosproject.net.optical.device.OduCltPortHelper;
import org.onosproject.net.optical.device.OmsPortHelper;
import org.onosproject.net.optical.device.OtuPortHelper;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowOpticalSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PortDescPropertyType;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.device.impl.OpenFlowDeviceValueMapper;
import org.onosproject.provider.of.device.impl.PortStatsCollector;
import org.osgi.service.component.ComponentContext;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescPropOptical;
import org.projectfloodlight.openflow.protocol.OFCalientPortDescStatsEntry;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFExpPort;
import org.projectfloodlight.openflow.protocol.OFExpPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerEntry;
import org.projectfloodlight.openflow.protocol.OFExpPortOpticalTransportLayerStack;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFObject;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescPropOpticalTransport;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortMod;
import org.projectfloodlight.openflow.protocol.OFPortOptical;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerClass;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportSignalType;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFPortStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.OFStatsReply;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.PortSpeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFlowDeviceProvider.class);
    private static final long KBPS = 1000L;
    private static final long MBPS = 1000000L;
    private static final Frequency FREQ50 = Frequency.ofGHz((long)50L);
    private static final Frequency FREQ191_7 = Frequency.ofGHz((long)191700L);
    private static final Frequency FREQ4_4 = Frequency.ofGHz((long)4400L);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private DeviceProviderService providerService;
    private final InternalDeviceProvider listener = new InternalDeviceProvider();
    private static final String POLL_PROP_NAME = "portStatsPollFrequency";
    private static final int POLL_INTERVAL = 5;
    @Property(name="portStatsPollFrequency", intValue={5}, label="Frequency (in seconds) for polling switch Port statistics")
    private int portStatsPollFrequency = 5;
    private final Timer timer = new Timer("onos-openflow-collector");
    private HashMap<Dpid, PortStatsCollector> collectors = Maps.newHashMap();

    public OpenFlowDeviceProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addListener((OpenFlowSwitchListener)this.listener);
        this.controller.addEventListener((OpenFlowEventListener)this.listener);
        this.connectInitialDevices();
        LOG.info("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.listener.disable();
        this.controller.removeListener((OpenFlowSwitchListener)this.listener);
        this.providerRegistry.unregister((Provider)this);
        this.collectors.values().forEach(PortStatsCollector::stop);
        this.collectors.clear();
        this.providerService = null;
        LOG.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newPortStatsPollFrequency;
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)POLL_PROP_NAME);
            newPortStatsPollFrequency = Strings.isNullOrEmpty((String)s) ? this.portStatsPollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newPortStatsPollFrequency = this.portStatsPollFrequency;
        }
        if (newPortStatsPollFrequency != this.portStatsPollFrequency) {
            this.portStatsPollFrequency = newPortStatsPollFrequency;
            this.collectors.values().forEach(psc -> psc.adjustPollInterval(this.portStatsPollFrequency));
        }
        LOG.info("Settings: portStatsPollFrequency={}", (Object)this.portStatsPollFrequency);
    }

    private void connectInitialDevices() {
        for (OpenFlowSwitch sw : this.controller.getSwitches()) {
            try {
                this.listener.switchAdded(new Dpid(sw.getId()));
            }
            catch (Exception e) {
                LOG.warn("Failed initially adding {} : {}", (Object)sw.getStringId(), (Object)e.getMessage());
                LOG.debug("Error details:", (Throwable)e);
                sw.disconnectSwitch();
            }
            PortStatsCollector psc = new PortStatsCollector(this.timer, sw, this.portStatsPollFrequency);
            psc.start();
            this.collectors.put(new Dpid(sw.getId()), psc);
        }
    }

    public boolean isReachable(DeviceId deviceId) {
        OpenFlowSwitch sw = this.controller.getSwitch(Dpid.dpid((URI)deviceId.uri()));
        return sw != null && sw.isConnected();
    }

    public void triggerProbe(DeviceId deviceId) {
        LOG.debug("Triggering probe on device {}", (Object)deviceId);
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null || !sw.isConnected()) {
            LOG.error("Failed to probe device {} on sw={}", (Object)deviceId, (Object)sw);
            this.providerService.deviceDisconnected(deviceId);
            return;
        }
        LOG.trace("Confirmed device {} connection", (Object)deviceId);
        OFFactory fact = sw.factory();
        switch (fact.getVersion()) {
            case OF_10: {
                sw.sendMsg((OFMessage)fact.buildFeaturesRequest().setXid(0L).build());
                break;
            }
            case OF_13: {
                sw.sendMsg((OFMessage)fact.buildPortDescStatsRequest().setXid(0L).build());
                break;
            }
            default: {
                LOG.warn("Unhandled protocol version");
            }
        }
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
        switch (newRole) {
            case MASTER: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.MASTER);
                break;
            }
            case STANDBY: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.EQUAL);
                break;
            }
            case NONE: {
                this.controller.setRole(Dpid.dpid((URI)deviceId.uri()), RoleState.SLAVE);
                break;
            }
            default: {
                LOG.error("Unknown Mastership state : {}", (Object)newRole);
            }
        }
        LOG.debug("Accepting mastership role change to {} for device {}", (Object)newRole, (Object)deviceId);
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
        Dpid dpid = Dpid.dpid((URI)deviceId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null || !sw.isConnected()) {
            LOG.error("Failed to change portState on device {}", (Object)deviceId);
            return;
        }
        OFPortMod.Builder pmb = sw.factory().buildPortMod();
        OFPort port = OFPort.of((int)((int)portNumber.toLong()));
        pmb.setPortNo(port);
        if (enable) {
            pmb.setConfig(0L);
        } else {
            pmb.setConfig(1L);
        }
        pmb.setMask(1L);
        pmb.setAdvertise(0L);
        for (OFPortDesc pd : sw.getPorts()) {
            if (!pd.getPortNo().equals((Object)port)) continue;
            pmb.setHwAddr(pd.getHwAddr());
            break;
        }
        sw.sendMsg(Collections.singletonList(pmb.build()));
    }

    private void pushPortMetrics(Dpid dpid, List<OFPortStatsEntry> portStatsEntries) {
        DeviceId deviceId = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
        Collection<PortStatistics> stats = this.buildPortStatistics(deviceId, (List<OFPortStatsEntry>)ImmutableList.copyOf(portStatsEntries));
        this.providerService.updatePortStatistics(deviceId, stats);
    }

    private Collection<PortStatistics> buildPortStatistics(DeviceId deviceId, List<OFPortStatsEntry> entries) {
        HashSet stats = Sets.newHashSet();
        for (OFPortStatsEntry entry : entries) {
            try {
                if (entry == null || entry.getPortNo() == null || entry.getPortNo().getPortNumber() < 0) continue;
                DefaultPortStatistics.Builder builder = DefaultPortStatistics.builder();
                DefaultPortStatistics stat = builder.setDeviceId(deviceId).setPort(entry.getPortNo().getPortNumber()).setPacketsReceived(entry.getRxPackets().getValue()).setPacketsSent(entry.getTxPackets().getValue()).setBytesReceived(entry.getRxBytes().getValue()).setBytesSent(entry.getTxBytes().getValue()).setPacketsRxDropped(entry.getRxDropped().getValue()).setPacketsTxDropped(entry.getTxDropped().getValue()).setPacketsRxErrors(entry.getRxErrors().getValue()).setPacketsTxErrors(entry.getTxErrors().getValue()).setDurationSec(entry.getVersion() == OFVersion.OF_10 ? 0L : entry.getDurationSec()).setDurationNano(entry.getVersion() == OFVersion.OF_10 ? 0L : entry.getDurationNsec()).build();
                stats.add(stat);
            }
            catch (Exception e) {
                LOG.warn("Unable to process port stats", (Throwable)e);
            }
        }
        return Collections.unmodifiableSet(stats);
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class InternalDeviceProvider
    implements OpenFlowSwitchListener,
    OpenFlowEventListener {
        private HashMap<Dpid, List<OFPortStatsEntry>> portStatsReplies = new HashMap();
        private boolean isDisabled = false;

        private InternalDeviceProvider() {
        }

        public void switchAdded(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            if (sw == null) {
                LOG.error("Switch {} is not found", (Object)dpid);
                return;
            }
            ChassisId cId = new ChassisId(dpid.value());
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("protocol", sw.factory().getVersion().toString()).set("channelId", sw.channelId()).set("managementAddress", sw.channelId().split(":")[0]).build();
            DefaultDeviceDescription description = new DefaultDeviceDescription(did.uri(), sw.deviceType(), sw.manufacturerDescription(), sw.hardwareDescription(), sw.softwareDescription(), sw.serialNumber(), cId, new SparseAnnotations[]{annotations});
            OpenFlowDeviceProvider.this.providerService.deviceConnected(did, (DeviceDescription)description);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, this.buildPortDescriptions(sw));
            PortStatsCollector psc = new PortStatsCollector(OpenFlowDeviceProvider.this.timer, sw, OpenFlowDeviceProvider.this.portStatsPollFrequency);
            this.stopCollectorIfNeeded(OpenFlowDeviceProvider.this.collectors.put(dpid, psc));
            psc.start();
            if (OpenFlowDeviceProvider.this.controller.getSwitch(dpid) == null) {
                this.switchRemoved(dpid);
            }
        }

        private void stopCollectorIfNeeded(PortStatsCollector collector) {
            if (collector != null) {
                collector.stop();
            }
        }

        public void switchRemoved(Dpid dpid) {
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            OpenFlowDeviceProvider.this.providerService.deviceDisconnected(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)));
            this.stopCollectorIfNeeded((PortStatsCollector)OpenFlowDeviceProvider.this.collectors.remove(dpid));
        }

        public void switchChanged(Dpid dpid) {
            LOG.debug("switchChanged({})", (Object)dpid);
            if (OpenFlowDeviceProvider.this.providerService == null) {
                return;
            }
            DeviceId did = DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid));
            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
            if (sw == null) {
                LOG.error("Switch {} is not found", (Object)dpid);
                return;
            }
            List<PortDescription> ports = this.buildPortDescriptions(sw);
            LOG.debug("switchChanged({}) {}", (Object)did, ports);
            OpenFlowDeviceProvider.this.providerService.updatePorts(did, ports);
        }

        public void portChanged(Dpid dpid, OFPortStatus status) {
            LOG.debug("portChanged({},{})", (Object)dpid, (Object)status);
            PortDescription portDescription = this.buildPortDescription(status);
            OpenFlowDeviceProvider.this.providerService.portStatusChanged(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), portDescription);
        }

        public void receivedRoleReply(Dpid dpid, RoleState requested, RoleState response) {
            LOG.debug("receivedRoleReply({},{},{})", new Object[]{dpid, requested, response});
            MastershipRole request = this.roleOf(requested);
            MastershipRole reply = this.roleOf(response);
            OpenFlowDeviceProvider.this.providerService.receivedRoleReply(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), request, reply);
        }

        private MastershipRole roleOf(RoleState response) {
            switch (response) {
                case MASTER: {
                    return MastershipRole.MASTER;
                }
                case EQUAL: {
                    return MastershipRole.STANDBY;
                }
                case SLAVE: {
                    return MastershipRole.NONE;
                }
            }
            LOG.warn("unknown role {}", (Object)response);
            return null;
        }

        private List<PortDescription> buildPortDescriptions(OpenFlowSwitch sw) {
            ArrayList<PortDescription> portDescs = new ArrayList<PortDescription>(sw.getPorts().size());
            if (!Device.Type.ROADM.equals((Object)sw.deviceType()) && !Device.Type.OTN.equals((Object)sw.deviceType())) {
                sw.getPorts().forEach(port -> portDescs.add(this.buildPortDescription((OFPortDesc)port)));
            }
            switch (sw.deviceType()) {
                case ROADM: 
                case OTN: {
                    OpenFlowOpticalSwitch opsw = (OpenFlowOpticalSwitch)sw;
                    List ports = opsw.getPorts();
                    LOG.debug("SW ID {} , ETH- ODU CLT Ports {}", (Object)opsw.getId(), (Object)ports);
                    ports.forEach(port -> portDescs.add(this.buildOduCltPortDescription((OFPortDesc)port)));
                    opsw.getPortTypes().forEach(type -> {
                        List portsOf = opsw.getPortsOf(type);
                        LOG.debug("Ports Of{}", (Object)portsOf);
                        portsOf.forEach(op -> portDescs.add(this.buildPortDescription((PortDescPropertyType)type, (OFObject)op, opsw)));
                    });
                    break;
                }
                case FIBER_SWITCH: {
                    OpenFlowOpticalSwitch opsw = (OpenFlowOpticalSwitch)sw;
                    opsw.getPortTypes().forEach(type -> opsw.getPortsOf(type).forEach(op -> portDescs.add(this.buildPortDescription((OFCalientPortDescStatsEntry)op))));
                    break;
                }
            }
            return portDescs;
        }

        private PortDescription buildOduCltPortDescription(OFPortDesc port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            Long portSpeedInMbps = this.portSpeed(port);
            CltSignalType sigType = null;
            switch (portSpeedInMbps.toString()) {
                case "1000": {
                    sigType = CltSignalType.CLT_1GBE;
                    break;
                }
                case "10000": {
                    sigType = CltSignalType.CLT_10GBE;
                    break;
                }
                case "40000": {
                    sigType = CltSignalType.CLT_40GBE;
                    break;
                }
                case "100000": {
                    sigType = CltSignalType.CLT_100GBE;
                    break;
                }
                default: {
                    throw new RuntimeException("Un recognize OduClt speed: " + portSpeedInMbps.toString());
                }
            }
            SparseAnnotations annotations = this.buildOduCltAnnotation(port);
            return OduCltPortHelper.oduCltPortDescription((PortNumber)portNo, (boolean)enabled, (CltSignalType)sigType, (SparseAnnotations)annotations);
        }

        private SparseAnnotations buildOduCltAnnotation(OFPortDesc port) {
            DefaultAnnotations annotations = null;
            String portName = Strings.emptyToNull((String)port.getName());
            if (portName != null) {
                annotations = DefaultAnnotations.builder().set("portName", portName).set("staticPort", Boolean.TRUE.toString()).build();
            }
            return annotations;
        }

        private PortDescription buildPortDescription(PortDescPropertyType ptype, OFObject port, OpenFlowOpticalSwitch opsw) {
            if (port instanceof OFPortOptical) {
                return this.buildPortDescription(ptype, (OFPortOptical)port, opsw);
            }
            return this.buildPortDescription(ptype, (OFExpPort)port);
        }

        private boolean matchingOtuPortSignalTypes(OFPortOpticalTransportSignalType sigType, OduSignalType oduSignalType) {
            switch (sigType) {
                case OTU2: {
                    if (oduSignalType != OduSignalType.ODU2) break;
                    return true;
                }
                case OTU4: {
                    if (oduSignalType != OduSignalType.ODU4) break;
                    return true;
                }
            }
            return false;
        }

        private PortDescription buildPortDescription(PortDescPropertyType ptype, OFExpPort port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            SparseAnnotations annotations = this.makePortAnnotation(port.getName(), port.getHwAddr().toString());
            OFExpPortDescPropOpticalTransport firstProp = (OFExpPortDescPropOpticalTransport)port.getProperties().get(0);
            OFPortOpticalTransportSignalType sigType = firstProp.getPortSignalType();
            PortDescription portDes = null;
            switch (sigType) {
                case OMSN: {
                    portDes = OmsPortHelper.omsPortDescription((PortNumber)portNo, (boolean)enabled, (Frequency)FREQ191_7, (Frequency)FREQ191_7.add(FREQ4_4), (Frequency)FREQ50, (SparseAnnotations)annotations);
                    break;
                }
                case OCH: {
                    OFExpPortOpticalTransportLayerEntry entry = (OFExpPortOpticalTransportLayerEntry)((OFExpPortOpticalTransportLayerStack)firstProp.getFeatures().get(0)).getValue().get(0);
                    OFPortOpticalTransportLayerClass layerClass = entry.getLayerClass();
                    if (!OFPortOpticalTransportLayerClass.ODU.equals((Object)layerClass)) {
                        LOG.error("Unsupported layer Class {} ", (Object)layerClass);
                        return null;
                    }
                    OduSignalType oduSignalType = OpenFlowDeviceValueMapper.lookupOduSignalType((byte)entry.getSignalType());
                    OchSignal signalId = new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, 1, 1);
                    portDes = OchPortHelper.ochPortDescription((PortNumber)portNo, (boolean)enabled, (OduSignalType)oduSignalType, (boolean)true, (OchSignal)signalId, (SparseAnnotations)annotations);
                    break;
                }
                case OTU2: 
                case OTU4: {
                    OFExpPortOpticalTransportLayerEntry entry = (OFExpPortOpticalTransportLayerEntry)((OFExpPortOpticalTransportLayerStack)firstProp.getFeatures().get(0)).getValue().get(0);
                    OFPortOpticalTransportLayerClass layerClass = entry.getLayerClass();
                    if (!OFPortOpticalTransportLayerClass.ODU.equals((Object)layerClass)) {
                        LOG.error("Unsupported layer Class {} ", (Object)layerClass);
                        return null;
                    }
                    OduSignalType oduSignalTypeOtuPort = OpenFlowDeviceValueMapper.lookupOduSignalType((byte)entry.getSignalType());
                    if (!this.matchingOtuPortSignalTypes(sigType, oduSignalTypeOtuPort)) {
                        LOG.error("Wrong oduSignalType {} for OTU Port sigType {} ", (Object)oduSignalTypeOtuPort, (Object)sigType);
                        return null;
                    }
                    OtuSignalType otuSignalType = sigType == OFPortOpticalTransportSignalType.OTU2 ? OtuSignalType.OTU2 : OtuSignalType.OTU4;
                    portDes = OtuPortHelper.otuPortDescription((PortNumber)portNo, (boolean)enabled, (OtuSignalType)otuSignalType, (SparseAnnotations)annotations);
                    break;
                }
            }
            return portDes;
        }

        private SparseAnnotations makePortAnnotation(String portName, String portMac) {
            DefaultAnnotations annotations = null;
            String pName = Strings.emptyToNull((String)portName);
            String pMac = Strings.emptyToNull((String)portMac);
            if (portName != null) {
                annotations = DefaultAnnotations.builder().set("portName", pName).set("portMac", pMac).build();
            }
            return annotations;
        }

        private PortDescription buildPortDescription(OFPortDesc port) {
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortAnnotation(port.getName(), port.getHwAddr().toString());
            return new DefaultPortDescription(portNo, enabled, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private PortDescription buildPortDescription(PortDescPropertyType ptype, OFPortOptical port, OpenFlowOpticalSwitch opsw) {
            Preconditions.checkArgument((port.getDesc().size() >= 1 ? 1 : 0) != 0);
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            boolean enabled = !port.getState().contains(OFPortState.LINK_DOWN) && !port.getConfig().contains(OFPortConfig.PORT_DOWN);
            SparseAnnotations annotations = this.makePortAnnotation(port.getName(), port.getHwAddr().toString());
            if (port.getVersion() == OFVersion.OF_13 && ptype == PortDescPropertyType.OPTICAL_TRANSPORT) {
                LOG.debug("Optical transport port message {}", (Object)port.toString());
            } else {
                LOG.debug("Unsupported optical port properties");
            }
            OFPortDescPropOpticalTransport desc = (OFPortDescPropOpticalTransport)port.getDesc().get(0);
            switch (desc.getPortSignalType()) {
                case 2: {
                    Frequency channelSpacing;
                    Frequency maxFreq;
                    Frequency minFreq;
                    DriverHandler driverHandler;
                    Set signals = null;
                    if (opsw instanceof HandlerBehaviour && (driverHandler = ((HandlerBehaviour)opsw).handler()) != null && driverHandler.hasBehaviour(LambdaQuery.class)) {
                        try {
                            signals = ((LambdaQuery)driverHandler.behaviour(LambdaQuery.class)).queryLambdas(portNo);
                        }
                        catch (NullPointerException e) {
                            signals = null;
                        }
                    }
                    if (signals == null || signals.isEmpty()) {
                        minFreq = Spectrum.U_BAND_MIN;
                        maxFreq = Spectrum.O_BAND_MAX;
                        channelSpacing = Frequency.ofGHz((long)50L);
                    } else {
                        Comparator compare = (a, b) -> a.spacingMultiplier() - b.spacingMultiplier();
                        OchSignal minOch = (OchSignal)Collections.min(signals, compare);
                        OchSignal maxOch = (OchSignal)Collections.max(signals, compare);
                        minFreq = minOch.centralFrequency();
                        maxFreq = maxOch.centralFrequency();
                        channelSpacing = minOch.channelSpacing().frequency();
                    }
                    return OmsPortHelper.omsPortDescription((PortNumber)portNo, (boolean)enabled, (Frequency)minFreq, (Frequency)maxFreq, (Frequency)channelSpacing, (SparseAnnotations)annotations);
                }
                case 5: {
                    OchSignal signal = new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, 0, 4);
                    return OchPortHelper.ochPortDescription((PortNumber)portNo, (boolean)enabled, (OduSignalType)OduSignalType.ODU4, (boolean)true, (OchSignal)signal, (SparseAnnotations)annotations);
                }
            }
            return new DefaultPortDescription(portNo, enabled, Port.Type.FIBER, 0L, new SparseAnnotations[]{annotations});
        }

        private PortDescription buildPortDescription(OFCalientPortDescStatsEntry port) {
            OFCalientPortDescPropOptical propOptical;
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            String name = port.getName();
            List props = port.getProperties();
            if (props != null && props.size() > 0 && (propOptical = (OFCalientPortDescPropOptical)props.get(0)) != null) {
                name = propOptical.getInAlias();
            }
            boolean enabled = true;
            SparseAnnotations annotations = this.makePortAnnotation(name, port.getHwAddr().toString());
            return OmsPortHelper.omsPortDescription((PortNumber)portNo, (boolean)enabled, (Frequency)Spectrum.U_BAND_MIN, (Frequency)Spectrum.O_BAND_MAX, (Frequency)Frequency.ofGHz((long)100L), (SparseAnnotations)annotations);
        }

        private PortDescription buildPortDescription(OFPortStatus status) {
            OFPortDesc port = status.getDesc();
            if (status.getReason() != OFPortReason.DELETE) {
                return this.buildPortDescription(port);
            }
            PortNumber portNo = PortNumber.portNumber((long)port.getPortNo().getPortNumber());
            Port.Type type = port.getCurr().contains(OFPortFeatures.PF_FIBER) ? Port.Type.FIBER : Port.Type.COPPER;
            SparseAnnotations annotations = this.makePortAnnotation(port.getName(), port.getHwAddr().toString());
            return new DefaultPortDescription(portNo, false, type, this.portSpeed(port), new SparseAnnotations[]{annotations});
        }

        private long portSpeed(OFPortDesc port) {
            if (port.getVersion() == OFVersion.OF_13) {
                return port.getCurrSpeed() / 1000L;
            }
            PortSpeed portSpeed = PortSpeed.SPEED_NONE;
            for (OFPortFeatures feat : port.getCurr()) {
                portSpeed = PortSpeed.max((PortSpeed)portSpeed, (PortSpeed)feat.getPortSpeed());
            }
            return portSpeed.getSpeedBps() / 1000000L;
        }

        public void handleMessage(Dpid dpid, OFMessage msg) {
            if (this.isDisabled) {
                return;
            }
            try {
                switch (msg.getType()) {
                    case STATS_REPLY: {
                        if (((OFStatsReply)msg).getStatsType() == OFStatsType.PORT) {
                            List<OFPortStatsEntry> statsEntries;
                            OFPortStatsReply portStatsReply = (OFPortStatsReply)msg;
                            CopyOnWriteArrayList portStatsReplyList = this.portStatsReplies.get(dpid);
                            if (portStatsReplyList == null) {
                                portStatsReplyList = Lists.newCopyOnWriteArrayList();
                            }
                            portStatsReplyList.addAll(portStatsReply.getEntries());
                            this.portStatsReplies.put(dpid, portStatsReplyList);
                            if (!portStatsReply.getFlags().contains(OFStatsReplyFlags.REPLY_MORE) && (statsEntries = this.portStatsReplies.get(dpid)) != null) {
                                OpenFlowDeviceProvider.this.pushPortMetrics(dpid, statsEntries);
                                statsEntries.clear();
                            }
                        } else {
                            List portDescs;
                            if (((OFStatsReply)msg).getStatsType() != OFStatsType.EXPERIMENTER) break;
                            OpenFlowSwitch sw = OpenFlowDeviceProvider.this.controller.getSwitch(dpid);
                            if (sw == null) {
                                LOG.error("Switch {} is not found", (Object)dpid);
                                break;
                            }
                            if (sw instanceof OpenFlowOpticalSwitch && !(portDescs = ((OpenFlowOpticalSwitch)sw).processExpPortStats(msg)).isEmpty()) {
                                OpenFlowDeviceProvider.this.providerService.updatePorts(DeviceId.deviceId((URI)Dpid.uri((Dpid)dpid)), portDescs);
                            }
                        }
                        break;
                    }
                    case ERROR: {
                        if (((OFErrorMsg)msg).getErrType() != OFErrorType.PORT_MOD_FAILED) break;
                        LOG.error("port mod failed");
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        private void disable() {
            this.isDisabled = true;
        }
    }
}

