/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.onlab.util.SharedExecutors;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortStatsRequest;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortStatsCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int SECONDS = 1000;
    private OpenFlowSwitch sw;
    private Timer timer;
    private TimerTask task;
    private int refreshInterval;
    private final AtomicLong xidAtomic = new AtomicLong(1L);

    PortStatsCollector(Timer timer, OpenFlowSwitch sw, int interval) {
        this.timer = timer;
        this.sw = (OpenFlowSwitch)Preconditions.checkNotNull((Object)sw, (Object)"Null switch");
        this.refreshInterval = interval;
    }

    public synchronized void start() {
        this.log.info("Starting Port Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task = new InternalTimerTask();
        SharedExecutors.getTimer().scheduleAtFixedRate(this.task, 1000L, (long)(this.refreshInterval * 1000));
    }

    public synchronized void stop() {
        this.log.info("Stopping Port Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task.cancel();
        this.task = null;
    }

    public synchronized void adjustPollInterval(int pollInterval) {
        this.refreshInterval = pollInterval;
        this.task.cancel();
        this.task = new InternalTimerTask();
        this.timer.scheduleAtFixedRate(this.task, this.refreshInterval * 1000, (long)(this.refreshInterval * 1000));
    }

    private void sendPortStatistic() {
        if (this.sw.getRole() != RoleState.MASTER) {
            return;
        }
        Long statsXid = this.xidAtomic.getAndIncrement();
        OFPortStatsRequest statsRequest = this.sw.factory().buildPortStatsRequest().setPortNo(OFPort.ANY).setXid(statsXid.longValue()).build();
        this.sw.sendMsg((OFMessage)statsRequest);
    }

    private class InternalTimerTask
    extends TimerTask {
        private InternalTimerTask() {
        }

        @Override
        public void run() {
            PortStatsCollector.this.sendPortStatistic();
        }
    }
}

