/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.device.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import org.onosproject.net.OduSignalType;

final class OpenFlowDeviceValueMapper {
    private static final BiMap<OduSignalType, Byte> ODU_SIGNAL_TYPES = EnumHashBiMap.create(OduSignalType.class);

    private OpenFlowDeviceValueMapper() {
    }

    private static <I, O> O lookup(BiMap<I, O> map, I input, Class<O> cls) {
        if (!map.containsKey(input)) {
            throw new RuntimeException(String.format("No mapping found for %s when converting to %s", input, cls.getName()));
        }
        return (O)map.get(input);
    }

    static OduSignalType lookupOduSignalType(byte signalType) {
        return OpenFlowDeviceValueMapper.lookup(ODU_SIGNAL_TYPES.inverse(), signalType, OduSignalType.class);
    }

    static {
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU1, (Object)1);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU2, (Object)2);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU3, (Object)3);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU4, (Object)4);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU0, (Object)10);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU2e, (Object)11);
    }
}

