/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.onlab.util.Tools;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTypedFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.StoredFlowEntry;
import org.onosproject.net.flow.TypedStoredFlowEntry;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.flow.impl.FlowModBuilder;
import org.onosproject.provider.of.flow.impl.SwitchDataCollector;
import org.projectfloodlight.openflow.protocol.OFFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewAdaptiveFlowStatsCollector
implements SwitchDataCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String CHECK_AND_MOVE_LOG = "checkAndMoveLiveFlowInternal: flowId={}, state={}, afterLiveType={}, liveTime={}, life={}, bytes={}, packets={}, fromLastSeen={}, priority={}, selector={}, treatment={} dpid={}";
    private static final String CHECK_AND_MOVE_COUNT_LOG = "checkAndMoveLiveFlowAll: Total Flow_Count={}, add-remove_Count={}, IMMEDIATE_FLOW_Count={}, SHORT_FLOW_Count={}, MID_FLOW_Count={}, LONG_FLOW_Count={}, add_Count={}, addWithSetFlowLiveType_Count={}, remove_Count={}, dpid={}";
    private static final String ADD_INVALID_LOG = "addOrUpdateFlows: invalid flow update! The new life is SMALLER than the previous one, new flowId={}, old flowId={}, new bytes={}, old bytes={}, new life={}, old life={}, new lastSeen={}, old lastSeen={}";
    private final DriverService driverService;
    private final OpenFlowSwitch sw;
    private ScheduledExecutorService adaptiveFlowStatsScheduler = Executors.newScheduledThreadPool(4, Tools.groupedThreads((String)"onos/flow", (String)"device-stats-collector-%d", (Logger)this.log));
    private ScheduledFuture<?> calAndShortFlowsThread;
    private ScheduledFuture<?> midFlowsThread;
    private ScheduledFuture<?> longFlowsThread;
    private CalAndShortFlowsTask calAndShortFlowsTask;
    private MidFlowsTask midFlowsTask;
    private LongFlowsTask longFlowsTask;
    private static final int CAL_AND_POLL_TIMES = 1;
    private static final int MID_POLL_TIMES = 2;
    private static final int LONG_POLL_TIMES = 3;
    private static final int ENTIRE_POLL_TIMES = 6;
    private static final int DEFAULT_CAL_AND_POLL_FREQUENCY = 5;
    private static final int MIN_CAL_AND_POLL_FREQUENCY = 2;
    private static final int MAX_CAL_AND_POLL_FREQUENCY = 60;
    private int calAndPollInterval;
    private int midPollInterval;
    private int longPollInterval;
    private int entirePollInterval;
    private int callCountCalAndShortFlowsTask = 0;
    private int callCountMidFlowsTask = 0;
    private int callCountLongFlowsTask = 0;
    private InternalDeviceFlowTable deviceFlowTable = new InternalDeviceFlowTable();
    private boolean isFirstTimeStart = true;
    public static final long NO_FLOW_MISSING_XID = -1L;
    private long flowMissingXid = -1L;

    NewAdaptiveFlowStatsCollector(DriverService driverService, OpenFlowSwitch sw, int pollInterval) {
        this.driverService = driverService;
        this.sw = sw;
        this.initMemberVars(pollInterval);
    }

    private void initMemberVars(int pollInterval) {
        this.calAndPollInterval = pollInterval < 2 ? 2 : (pollInterval >= 60 ? 60 : pollInterval);
        this.calAndPollInterval = 1 * this.calAndPollInterval;
        this.midPollInterval = 2 * this.calAndPollInterval;
        this.longPollInterval = 3 * this.calAndPollInterval;
        this.entirePollInterval = 6 * this.calAndPollInterval;
        this.callCountCalAndShortFlowsTask = 0;
        this.callCountMidFlowsTask = 0;
        this.callCountLongFlowsTask = 0;
        this.flowMissingXid = -1L;
    }

    synchronized void adjustCalAndPollInterval(int pollInterval) {
        this.initMemberVars(pollInterval);
        if (this.calAndShortFlowsThread != null) {
            this.calAndShortFlowsThread.cancel(false);
        }
        if (this.midFlowsThread != null) {
            this.midFlowsThread.cancel(false);
        }
        if (this.longFlowsThread != null) {
            this.longFlowsThread.cancel(false);
        }
        this.calAndShortFlowsTask = new CalAndShortFlowsTask();
        this.calAndShortFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.calAndShortFlowsTask, 0L, this.calAndPollInterval, TimeUnit.SECONDS);
        this.midFlowsTask = new MidFlowsTask();
        this.midFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.midFlowsTask, 0L, this.midPollInterval, TimeUnit.SECONDS);
        this.longFlowsTask = new LongFlowsTask();
        this.longFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.longFlowsTask, 0L, this.longPollInterval, TimeUnit.SECONDS);
        this.log.debug("calAndPollInterval={} is adjusted", (Object)this.calAndPollInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ofFlowStatsRequestAllSend() {
        OFFlowStatsRequest request = this.sw.factory().buildFlowStatsRequest().setMatch(this.sw.factory().matchWildcardAll()).setTableId(TableId.ALL).setOutPort(OFPort.NO_MASK).build();
        NewAdaptiveFlowStatsCollector newAdaptiveFlowStatsCollector = this;
        synchronized (newAdaptiveFlowStatsCollector) {
            this.setFlowMissingXid(request.getXid());
            this.log.debug("ofFlowStatsRequestAllSend: request={}, dpid={}", (Object)request.toString(), (Object)this.sw.getStringId());
            this.sw.sendMsg((OFMessage)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ofFlowStatsRequestFlowSend(FlowEntry fe) {
        Match match = FlowModBuilder.builder((FlowRule)fe, this.sw.factory(), Optional.empty(), Optional.of(this.driverService)).buildMatch();
        TableId tableId = TableId.of((int)fe.tableId());
        Instruction ins = fe.treatment().allInstructions().stream().filter(i -> i.type() == Instruction.Type.OUTPUT).findFirst().orElse(null);
        OFPort ofPort = OFPort.NO_MASK;
        if (ins != null) {
            Instructions.OutputInstruction out = (Instructions.OutputInstruction)ins;
            ofPort = OFPort.of((int)((int)out.port().toLong()));
        }
        OFFlowStatsRequest request = this.sw.factory().buildFlowStatsRequest().setMatch(match).setTableId(tableId).setOutPort(ofPort).build();
        NewAdaptiveFlowStatsCollector newAdaptiveFlowStatsCollector = this;
        synchronized (newAdaptiveFlowStatsCollector) {
            if (this.getFlowMissingXid() != -1L) {
                this.log.debug("ofFlowStatsRequestFlowSend: previous FlowStatsRequestAll does not be processed yet, set no flow missing xid anyway, for {}", (Object)this.sw.getStringId());
                this.setFlowMissingXid(-1L);
            }
            this.sw.sendMsg((OFMessage)request);
        }
    }

    private void calAndShortFlowsTaskInternal() {
        this.deviceFlowTable.checkAndMoveLiveFlowAll();
        this.deviceFlowTable.getShortFlows().forEach(fe -> this.ofFlowStatsRequestFlowSend((FlowEntry)fe));
    }

    private void midFlowsTaskInternal() {
        this.deviceFlowTable.getMidFlows().forEach(fe -> this.ofFlowStatsRequestFlowSend((FlowEntry)fe));
    }

    private void longFlowsTaskInternal() {
        this.deviceFlowTable.getLongFlows().forEach(fe -> this.ofFlowStatsRequestFlowSend((FlowEntry)fe));
    }

    @Override
    public synchronized void start() {
        this.log.debug("Starting AdaptiveStats collection thread for {}", (Object)this.sw.getStringId());
        this.callCountCalAndShortFlowsTask = 0;
        this.callCountMidFlowsTask = 0;
        this.callCountLongFlowsTask = 0;
        this.isFirstTimeStart = true;
        this.calAndShortFlowsTask = new CalAndShortFlowsTask();
        this.calAndShortFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.calAndShortFlowsTask, 1L, this.calAndPollInterval, TimeUnit.SECONDS);
        this.midFlowsTask = new MidFlowsTask();
        this.midFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.midFlowsTask, 1L, this.midPollInterval, TimeUnit.SECONDS);
        this.longFlowsTask = new LongFlowsTask();
        this.longFlowsThread = this.adaptiveFlowStatsScheduler.scheduleWithFixedDelay(this.longFlowsTask, 1L, this.longPollInterval, TimeUnit.SECONDS);
        this.log.info("Started");
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping AdaptiveStats collection thread for {}", (Object)this.sw.getStringId());
        if (this.calAndShortFlowsThread != null) {
            this.calAndShortFlowsThread.cancel(true);
        }
        if (this.midFlowsThread != null) {
            this.midFlowsThread.cancel(true);
        }
        if (this.longFlowsThread != null) {
            this.longFlowsThread.cancel(true);
        }
        this.adaptiveFlowStatsScheduler.shutdownNow();
        this.isFirstTimeStart = false;
        this.log.info("Stopped");
    }

    public synchronized void addWithFlowRule(FlowRule ... flowRules) {
        for (FlowRule fr : flowRules) {
            this.deviceFlowTable.remove(fr);
            DefaultTypedFlowEntry newFlowEntry = new DefaultTypedFlowEntry(fr, TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW);
            this.deviceFlowTable.addWithCalAndSetFlowLiveType((TypedStoredFlowEntry)newFlowEntry);
        }
    }

    public synchronized void addOrUpdateFlows(FlowEntry ... flowEntries) {
        for (FlowEntry fe : flowEntries) {
            TypedStoredFlowEntry stored = this.deviceFlowTable.getFlowEntry((FlowRule)fe);
            if (stored != null) {
                if (fe.bytes() == stored.bytes() && fe.packets() == stored.packets() && fe.life() == stored.life()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("addOrUpdateFlows({}): flowId={},is DUPLICATED stats collection, just skip.", (Object)this.sw.getStringId(), (Object)fe.id());
                    }
                    stored.setLastSeen();
                    continue;
                }
                if (fe.life() < stored.life()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ADD_INVALID_LOG, new Object[]{fe.id(), stored.id(), fe.bytes(), stored.bytes(), fe.life(), stored.life(), fe.lastSeen(), stored.lastSeen()});
                    }
                    stored.setLastSeen();
                    continue;
                }
                stored.setLife(fe.life(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                stored.setPackets(fe.packets());
                stored.setBytes(fe.bytes());
                stored.setLastSeen();
                if (stored.state() != FlowEntry.FlowEntryState.PENDING_ADD) continue;
                stored.setState(FlowEntry.FlowEntryState.ADDED);
                continue;
            }
            DefaultTypedFlowEntry newFlowEntry = new DefaultTypedFlowEntry(fe, TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW);
            this.deviceFlowTable.addWithCalAndSetFlowLiveType((TypedStoredFlowEntry)newFlowEntry);
        }
    }

    public synchronized void removeFlows(FlowRule ... flowRules) {
        for (FlowRule rule : flowRules) {
            this.deviceFlowTable.remove(rule);
        }
    }

    public void flowRemoved(FlowRule ... flowRules) {
        this.removeFlows(flowRules);
    }

    public void pushFlowMetrics(List<FlowEntry> flowEntries) {
        flowEntries.forEach(xva$0 -> this.addOrUpdateFlows((FlowEntry)xva$0));
    }

    public long getFlowMissingXid() {
        return this.flowMissingXid;
    }

    public void setFlowMissingXid(long flowMissingXid) {
        this.flowMissingXid = flowMissingXid;
    }

    private class InternalDeviceFlowTable {
        private final Map<FlowId, Set<TypedStoredFlowEntry>> flowEntries = Maps.newConcurrentMap();
        private final Set<StoredFlowEntry> shortFlows = new HashSet<StoredFlowEntry>();
        private final Set<StoredFlowEntry> midFlows = new HashSet<StoredFlowEntry>();
        private final Set<StoredFlowEntry> longFlows = new HashSet<StoredFlowEntry>();
        private final long latencyFlowStatsRequestAndReplyMillis = 500L;
        private long addCount = 0L;
        private long addWithSetFlowLiveTypeCount = 0L;
        private long removeCount = 0L;

        private InternalDeviceFlowTable() {
        }

        public void resetAllCount() {
            this.addCount = 0L;
            this.addWithSetFlowLiveTypeCount = 0L;
            this.removeCount = 0L;
        }

        private Set<TypedStoredFlowEntry> getFlowEntriesInternal(FlowId flowId) {
            return this.flowEntries.computeIfAbsent(flowId, id -> Sets.newCopyOnWriteArraySet());
        }

        private TypedStoredFlowEntry getFlowEntryInternal(FlowRule rule) {
            Set<TypedStoredFlowEntry> flowEntries = this.getFlowEntriesInternal(rule.id());
            return flowEntries.stream().filter(entry -> Objects.equal((Object)entry, (Object)rule)).findAny().orElse(null);
        }

        private Set<TypedStoredFlowEntry> getFlowEntriesInternal() {
            HashSet result = Sets.newHashSet();
            this.flowEntries.values().forEach(result::addAll);
            return result;
        }

        public long getFlowCount() {
            return this.flowEntries.values().stream().mapToLong(Set::size).sum();
        }

        public TypedStoredFlowEntry getFlowEntry(FlowRule rule) {
            Preconditions.checkNotNull((Object)rule);
            return this.getFlowEntryInternal(rule);
        }

        public Set<TypedStoredFlowEntry> getFlowEntries() {
            return this.getFlowEntriesInternal();
        }

        public Set<StoredFlowEntry> getShortFlows() {
            return ImmutableSet.copyOf(this.shortFlows);
        }

        public Set<StoredFlowEntry> getMidFlows() {
            return ImmutableSet.copyOf(this.midFlows);
        }

        public Set<StoredFlowEntry> getLongFlows() {
            return ImmutableSet.copyOf(this.longFlows);
        }

        public synchronized void add(TypedStoredFlowEntry rule) {
            Preconditions.checkNotNull((Object)rule);
            boolean result = this.getFlowEntriesInternal(rule.id()).add(rule);
            if (result) {
                ++this.addCount;
            }
        }

        public void calAndSetFlowLiveType(TypedStoredFlowEntry rule) {
            Preconditions.checkNotNull((Object)rule);
            this.calAndSetFlowLiveTypeInternal(rule);
        }

        public synchronized void addWithCalAndSetFlowLiveType(TypedStoredFlowEntry rule) {
            Preconditions.checkNotNull((Object)rule);
            boolean result = this.getFlowEntriesInternal(rule.id()).add(rule);
            if (result) {
                this.calAndSetFlowLiveTypeInternal(rule);
                ++this.addWithSetFlowLiveTypeCount;
            } else if (NewAdaptiveFlowStatsCollector.this.log.isDebugEnabled()) {
                NewAdaptiveFlowStatsCollector.this.log.debug("FlowId {} ADD failed, it may already exist in table - {}", (Object)rule.id(), (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
            }
        }

        private void calAndSetFlowLiveTypeInternal(TypedStoredFlowEntry rule) {
            long life = rule.life();
            TypedStoredFlowEntry.FlowLiveType prevFlowLiveType = rule.flowLiveType();
            if (life >= (long)NewAdaptiveFlowStatsCollector.this.longPollInterval) {
                rule.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
                this.longFlows.add((StoredFlowEntry)rule);
            } else if (life >= (long)NewAdaptiveFlowStatsCollector.this.midPollInterval) {
                rule.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.MID_FLOW);
                this.midFlows.add((StoredFlowEntry)rule);
            } else if (life >= (long)NewAdaptiveFlowStatsCollector.this.calAndPollInterval) {
                rule.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.SHORT_FLOW);
                this.shortFlows.add((StoredFlowEntry)rule);
            } else if (life >= 0L) {
                rule.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.IMMEDIATE_FLOW);
            } else {
                rule.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.UNKNOWN_FLOW);
            }
            if (rule.flowLiveType() != prevFlowLiveType) {
                switch (prevFlowLiveType) {
                    case SHORT_FLOW: {
                        this.shortFlows.remove(rule);
                        break;
                    }
                    case MID_FLOW: {
                        this.midFlows.remove(rule);
                        break;
                    }
                    case LONG_FLOW: {
                        this.longFlows.remove(rule);
                        break;
                    }
                }
            }
        }

        private boolean checkAndMoveLiveFlowInternal(TypedStoredFlowEntry fe, long cTime) {
            long curTime = cTime > 0L ? cTime : System.currentTimeMillis();
            long fromLastSeen = (curTime - fe.lastSeen() + 500L) / 1000L;
            long liveTime = fe.life() + fromLastSeen;
            switch (fe.flowLiveType()) {
                case IMMEDIATE_FLOW: {
                    if (liveTime >= (long)NewAdaptiveFlowStatsCollector.this.longPollInterval) {
                        fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
                        this.longFlows.add((StoredFlowEntry)fe);
                        break;
                    }
                    if (liveTime >= (long)NewAdaptiveFlowStatsCollector.this.midPollInterval) {
                        fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.MID_FLOW);
                        this.midFlows.add((StoredFlowEntry)fe);
                        break;
                    }
                    if (liveTime < (long)NewAdaptiveFlowStatsCollector.this.calAndPollInterval) break;
                    fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.SHORT_FLOW);
                    this.shortFlows.add((StoredFlowEntry)fe);
                    break;
                }
                case SHORT_FLOW: {
                    if (liveTime >= (long)NewAdaptiveFlowStatsCollector.this.longPollInterval) {
                        fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
                        this.shortFlows.remove(fe);
                        this.longFlows.add((StoredFlowEntry)fe);
                        break;
                    }
                    if (liveTime < (long)NewAdaptiveFlowStatsCollector.this.midPollInterval) break;
                    fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.MID_FLOW);
                    this.shortFlows.remove(fe);
                    this.midFlows.add((StoredFlowEntry)fe);
                    break;
                }
                case MID_FLOW: {
                    if (liveTime < (long)NewAdaptiveFlowStatsCollector.this.longPollInterval) break;
                    fe.setFlowLiveType(TypedStoredFlowEntry.FlowLiveType.LONG_FLOW);
                    this.midFlows.remove(fe);
                    this.longFlows.add((StoredFlowEntry)fe);
                    break;
                }
                case LONG_FLOW: {
                    if (fromLastSeen <= (long)NewAdaptiveFlowStatsCollector.this.entirePollInterval) break;
                    NewAdaptiveFlowStatsCollector.this.log.trace("checkAndMoveLiveFlowInternal: flow is already removed at switch.");
                    return false;
                }
                default: {
                    NewAdaptiveFlowStatsCollector.this.log.error("Unknown live type error for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                    return false;
                }
            }
            if (NewAdaptiveFlowStatsCollector.this.log.isTraceEnabled()) {
                NewAdaptiveFlowStatsCollector.this.log.trace(NewAdaptiveFlowStatsCollector.CHECK_AND_MOVE_LOG, new Object[]{fe.id(), fe.state(), fe.flowLiveType(), liveTime, fe.life(), fe.bytes(), fe.packets(), fromLastSeen, fe.priority(), fe.selector().criteria(), fe.treatment(), NewAdaptiveFlowStatsCollector.this.sw.getStringId()});
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAndMoveLiveFlowAll() {
            Set<TypedStoredFlowEntry> typedFlowEntries = this.getFlowEntriesInternal();
            long calCurTime = System.currentTimeMillis();
            typedFlowEntries.forEach(fe -> {
                if (!this.checkAndMoveLiveFlowInternal((TypedStoredFlowEntry)fe, calCurTime)) {
                    this.remove((FlowRule)fe);
                }
            });
            if (NewAdaptiveFlowStatsCollector.this.log.isTraceEnabled()) {
                InternalDeviceFlowTable internalDeviceFlowTable = this;
                synchronized (internalDeviceFlowTable) {
                    long totalFlowCount = this.getFlowCount();
                    long shortFlowCount = this.shortFlows.size();
                    long midFlowCount = this.midFlows.size();
                    long longFlowCount = this.longFlows.size();
                    long immediateFlowCount = totalFlowCount - shortFlowCount - midFlowCount - longFlowCount;
                    long calTotalCount = this.addCount + this.addWithSetFlowLiveTypeCount - this.removeCount;
                    NewAdaptiveFlowStatsCollector.this.log.trace(NewAdaptiveFlowStatsCollector.CHECK_AND_MOVE_COUNT_LOG, new Object[]{totalFlowCount, calTotalCount, immediateFlowCount, shortFlowCount, midFlowCount, longFlowCount, this.addCount, this.addWithSetFlowLiveTypeCount, this.removeCount, NewAdaptiveFlowStatsCollector.this.sw.getStringId()});
                    if (totalFlowCount != calTotalCount) {
                        NewAdaptiveFlowStatsCollector.this.log.error("Real total flow count and calculated total flow count do NOT match");
                    }
                    if (immediateFlowCount < 0L) {
                        NewAdaptiveFlowStatsCollector.this.log.error("Immediate flow count is negative");
                    }
                }
            }
            NewAdaptiveFlowStatsCollector.this.log.trace("checkAndMoveLiveFlowAll: adaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
        }

        public synchronized void remove(FlowRule rule) {
            Preconditions.checkNotNull((Object)rule);
            TypedStoredFlowEntry removeStore = this.getFlowEntryInternal(rule);
            if (removeStore != null) {
                this.removeLiveFlowsInternal(removeStore);
                boolean result = this.getFlowEntriesInternal(rule.id()).remove(removeStore);
                if (result) {
                    ++this.removeCount;
                }
            }
        }

        private void removeLiveFlowsInternal(TypedStoredFlowEntry fe) {
            switch (fe.flowLiveType()) {
                case IMMEDIATE_FLOW: {
                    break;
                }
                case SHORT_FLOW: {
                    this.shortFlows.remove(fe);
                    break;
                }
                case MID_FLOW: {
                    this.midFlows.remove(fe);
                    break;
                }
                case LONG_FLOW: {
                    this.longFlows.remove(fe);
                    break;
                }
                default: {
                    NewAdaptiveFlowStatsCollector.this.log.error("removeLiveFlowsInternal: unknown live type error");
                }
            }
        }
    }

    private class LongFlowsTask
    implements Runnable {
        private LongFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("LongFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask = 3;
                } else {
                    NewAdaptiveFlowStatsCollector.this.longFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountLongFlowsTask + 3;
                }
            }
        }
    }

    private class MidFlowsTask
    implements Runnable {
        private MidFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("MidFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask = 2;
                } else {
                    NewAdaptiveFlowStatsCollector.this.midFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountMidFlowsTask + 2;
                }
            }
        }
    }

    private class CalAndShortFlowsTask
    implements Runnable {
        private CalAndShortFlowsTask() {
        }

        @Override
        public void run() {
            if (NewAdaptiveFlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                if (NewAdaptiveFlowStatsCollector.this.isFirstTimeStart) {
                    NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting Entire AdaptiveStats at first time start for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                    NewAdaptiveFlowStatsCollector.this.ofFlowStatsRequestAllSend();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask + 1;
                    NewAdaptiveFlowStatsCollector.this.isFirstTimeStart = false;
                } else if (NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask == 6) {
                    NewAdaptiveFlowStatsCollector.this.log.trace("CalAndShortFlowsTask Collecting Entire AdaptiveStats for {}", (Object)NewAdaptiveFlowStatsCollector.this.sw.getStringId());
                    NewAdaptiveFlowStatsCollector.this.ofFlowStatsRequestAllSend();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = 1;
                } else {
                    NewAdaptiveFlowStatsCollector.this.calAndShortFlowsTaskInternal();
                    NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask = NewAdaptiveFlowStatsCollector.this.callCountCalAndShortFlowsTask + 1;
                }
            }
        }
    }
}

