/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import com.google.common.base.Preconditions;
import java.util.Timer;
import java.util.TimerTask;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.flow.impl.SwitchDataCollector;
import org.projectfloodlight.openflow.protocol.OFFlowStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlowStatsCollector
implements SwitchDataCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int SECONDS = 1000;
    private final OpenFlowSwitch sw;
    private Timer timer;
    private TimerTask task;
    private int pollInterval;

    FlowStatsCollector(Timer timer, OpenFlowSwitch sw, int pollInterval) {
        this.timer = timer;
        this.sw = (OpenFlowSwitch)Preconditions.checkNotNull((Object)sw, (Object)"Null switch");
        this.pollInterval = pollInterval;
    }

    synchronized void adjustPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
        this.task.cancel();
        this.task = new InternalTimerTask();
        this.timer.scheduleAtFixedRate(this.task, pollInterval * 1000, (long)(pollInterval * 1000));
    }

    @Override
    public synchronized void start() {
        this.log.debug("Starting Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task = new InternalTimerTask();
        this.timer.scheduleAtFixedRate(this.task, 1000L, (long)(this.pollInterval * 1000));
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task.cancel();
        this.task = null;
    }

    private class InternalTimerTask
    extends TimerTask {
        private InternalTimerTask() {
        }

        @Override
        public void run() {
            if (FlowStatsCollector.this.sw.getRole() == RoleState.MASTER) {
                FlowStatsCollector.this.log.trace("Collecting stats for {}", (Object)FlowStatsCollector.this.sw.getStringId());
                OFFlowStatsRequest request = FlowStatsCollector.this.sw.factory().buildFlowStatsRequest().setMatch(FlowStatsCollector.this.sw.factory().matchWildcardAll()).setTableId(TableId.ALL).setOutPort(OFPort.NO_MASK).build();
                FlowStatsCollector.this.sw.sendMsg((OFMessage)request);
            }
        }
    }
}

