/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.OduSignalType;
import org.onosproject.provider.of.flow.util.NoMappingFoundException;

public final class OpenFlowValueMapper {
    private static final BiMap<GridType, Byte> GRID_TYPES = EnumHashBiMap.create(GridType.class);
    private static final BiMap<ChannelSpacing, Byte> CHANNEL_SPACING;
    private static final BiMap<OchSignalType, Byte> OCH_SIGNAL_TYPES;
    private static final BiMap<OduSignalType, Byte> ODU_SIGNAL_TYPES;

    private OpenFlowValueMapper() {
    }

    private static <I, O> O lookup(BiMap<I, O> map, I input, Class<O> cls) {
        if (!map.containsKey(input)) {
            throw new NoMappingFoundException(input, cls);
        }
        return (O)map.get(input);
    }

    public static byte lookupGridType(GridType type) {
        return OpenFlowValueMapper.lookup(GRID_TYPES, type, Byte.class);
    }

    public static GridType lookupGridType(byte type) {
        return OpenFlowValueMapper.lookup(GRID_TYPES.inverse(), type, GridType.class);
    }

    public static byte lookupChannelSpacing(ChannelSpacing spacing) {
        return OpenFlowValueMapper.lookup(CHANNEL_SPACING, spacing, Byte.class);
    }

    public static ChannelSpacing lookupChannelSpacing(byte spacing) {
        return OpenFlowValueMapper.lookup(CHANNEL_SPACING.inverse(), spacing, ChannelSpacing.class);
    }

    public static byte lookupOchSignalType(OchSignalType signalType) {
        return OpenFlowValueMapper.lookup(OCH_SIGNAL_TYPES, signalType, Byte.class);
    }

    public static OchSignalType lookupOchSignalType(byte signalType) {
        return OpenFlowValueMapper.lookup(OCH_SIGNAL_TYPES.inverse(), signalType, OchSignalType.class);
    }

    public static byte lookupOduSignalType(OduSignalType signalType) {
        return OpenFlowValueMapper.lookup(ODU_SIGNAL_TYPES, signalType, Byte.class);
    }

    public static OduSignalType lookupOduSignalType(byte signalType) {
        return OpenFlowValueMapper.lookup(ODU_SIGNAL_TYPES.inverse(), signalType, OduSignalType.class);
    }

    static {
        GRID_TYPES.put((Object)GridType.DWDM, (Object)1);
        GRID_TYPES.put((Object)GridType.CWDM, (Object)2);
        GRID_TYPES.put((Object)GridType.FLEX, (Object)3);
        CHANNEL_SPACING = EnumHashBiMap.create(ChannelSpacing.class);
        CHANNEL_SPACING.put((Object)ChannelSpacing.CHL_100GHZ, (Object)1);
        CHANNEL_SPACING.put((Object)ChannelSpacing.CHL_50GHZ, (Object)2);
        CHANNEL_SPACING.put((Object)ChannelSpacing.CHL_25GHZ, (Object)3);
        CHANNEL_SPACING.put((Object)ChannelSpacing.CHL_12P5GHZ, (Object)4);
        CHANNEL_SPACING.put((Object)ChannelSpacing.CHL_6P25GHZ, (Object)5);
        OCH_SIGNAL_TYPES = EnumHashBiMap.create(OchSignalType.class);
        OCH_SIGNAL_TYPES.put((Object)OchSignalType.FIXED_GRID, (Object)1);
        OCH_SIGNAL_TYPES.put((Object)OchSignalType.FLEX_GRID, (Object)2);
        ODU_SIGNAL_TYPES = EnumHashBiMap.create(OduSignalType.class);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU1, (Object)1);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU2, (Object)2);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU3, (Object)3);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU4, (Object)4);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU0, (Object)10);
        ODU_SIGNAL_TYPES.put((Object)OduSignalType.ODU2e, (Object)11);
    }
}

