/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.flow.impl;

import java.util.Timer;
import java.util.TimerTask;
import org.onlab.util.SharedExecutors;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.flow.impl.SwitchDataCollector;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFTableStatsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableStatisticsCollector
implements SwitchDataCollector {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int SECONDS = 1000;
    private final OpenFlowSwitch sw;
    private Timer timer;
    private TimerTask task;
    private int pollInterval;

    TableStatisticsCollector(Timer timer, OpenFlowSwitch sw, int pollInterval) {
        this.timer = timer;
        this.sw = sw;
        this.pollInterval = pollInterval;
    }

    synchronized void adjustPollInterval(int pollInterval) {
        this.pollInterval = pollInterval;
        this.task.cancel();
        this.task = new InternalTimerTask();
        this.timer.scheduleAtFixedRate(this.task, pollInterval * 1000, (long)(pollInterval * 1000));
    }

    @Override
    public synchronized void start() {
        this.log.debug("Starting Table Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task = new InternalTimerTask();
        SharedExecutors.getTimer().scheduleAtFixedRate(this.task, 1000L, (long)(this.pollInterval * 1000));
    }

    @Override
    public synchronized void stop() {
        this.log.debug("Stopping Table Stats collection thread for {}", (Object)this.sw.getStringId());
        this.task.cancel();
        this.task = null;
    }

    private class InternalTimerTask
    extends TimerTask {
        private InternalTimerTask() {
        }

        @Override
        public void run() {
            if (TableStatisticsCollector.this.sw.getRole() == RoleState.MASTER) {
                TableStatisticsCollector.this.log.trace("Collecting stats for {}", (Object)TableStatisticsCollector.this.sw.getStringId());
                OFTableStatsRequest request = TableStatisticsCollector.this.sw.factory().buildTableStatsRequest().build();
                TableStatisticsCollector.this.sw.sendMsg((OFMessage)request);
            }
        }
    }
}

