/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.group.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip6Address;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.openflow.controller.ExtensionTreatmentInterpreter;
import org.projectfloodlight.openflow.protocol.OFBucket;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupAdd;
import org.projectfloodlight.openflow.protocol.OFGroupDelete;
import org.projectfloodlight.openflow.protocol.OFGroupMod;
import org.projectfloodlight.openflow.protocol.OFGroupModify;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.action.OFAction;
import org.projectfloodlight.openflow.protocol.action.OFActionGroup;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Flabel;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmVlanPcp;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.types.VlanPcp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroupModBuilder {
    private GroupBuckets buckets;
    private GroupId groupId;
    private GroupDescription.Type type;
    private OFFactory factory;
    private Long xid;
    private Optional<DriverService> driverService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int OFPCML_NO_BUFFER = 65535;

    private GroupModBuilder(GroupBuckets buckets, GroupId groupId, GroupDescription.Type type, OFFactory factory, Optional<Long> xid) {
        this.buckets = buckets;
        this.groupId = groupId;
        this.type = type;
        this.factory = factory;
        this.xid = xid.orElse(0L);
    }

    private GroupModBuilder(GroupBuckets buckets, GroupId groupId, GroupDescription.Type type, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        this.buckets = buckets;
        this.groupId = groupId;
        this.type = type;
        this.factory = factory;
        this.xid = xid.orElse(0L);
        this.driverService = driverService;
    }

    public static GroupModBuilder builder(GroupBuckets buckets, GroupId groupId, GroupDescription.Type type, OFFactory factory, Optional<Long> xid) {
        return new GroupModBuilder(buckets, groupId, type, factory, xid);
    }

    public static GroupModBuilder builder(GroupBuckets buckets, GroupId groupId, GroupDescription.Type type, OFFactory factory, Optional<Long> xid, Optional<DriverService> driverService) {
        return new GroupModBuilder(buckets, groupId, type, factory, xid, driverService);
    }

    public OFGroupAdd buildGroupAdd() {
        ArrayList<OFBucket> ofBuckets = new ArrayList<OFBucket>();
        for (GroupBucket bucket : this.buckets.buckets()) {
            List<OFAction> actions = this.buildActions(bucket.treatment());
            OFBucket.Builder bucketBuilder = this.factory.buildBucket();
            bucketBuilder.setActions(actions);
            if (this.type == GroupDescription.Type.SELECT) {
                bucketBuilder.setWeight((int)bucket.weight());
            }
            if (this.type == GroupDescription.Type.FAILOVER && bucket.watchPort() != null) {
                bucketBuilder.setWatchPort(OFPort.of((int)((int)bucket.watchPort().toLong())));
            } else {
                bucketBuilder.setWatchPort(OFPort.ANY);
            }
            if (this.type == GroupDescription.Type.FAILOVER && bucket.watchGroup() != null) {
                bucketBuilder.setWatchGroup(OFGroup.of((int)bucket.watchGroup().id()));
            } else {
                bucketBuilder.setWatchGroup(OFGroup.ANY);
            }
            OFBucket ofBucket = bucketBuilder.build();
            ofBuckets.add(ofBucket);
        }
        OFGroupAdd groupMsg = this.factory.buildGroupAdd().setGroup(OFGroup.of((int)this.groupId.id())).setBuckets(ofBuckets).setGroupType(this.getOFGroupType(this.type)).setXid(this.xid.longValue()).build();
        return groupMsg;
    }

    public OFGroupMod buildGroupMod() {
        ArrayList<OFBucket> ofBuckets = new ArrayList<OFBucket>();
        for (GroupBucket bucket : this.buckets.buckets()) {
            List<OFAction> actions = this.buildActions(bucket.treatment());
            OFBucket.Builder bucketBuilder = this.factory.buildBucket();
            bucketBuilder.setActions(actions);
            if (this.type == GroupDescription.Type.SELECT) {
                bucketBuilder.setWeight((int)bucket.weight());
            }
            if (this.type == GroupDescription.Type.FAILOVER && bucket.watchPort() != null) {
                bucketBuilder.setWatchPort(OFPort.of((int)((int)bucket.watchPort().toLong())));
            } else {
                bucketBuilder.setWatchPort(OFPort.ANY);
            }
            if (this.type == GroupDescription.Type.FAILOVER && bucket.watchGroup() != null) {
                bucketBuilder.setWatchGroup(OFGroup.of((int)bucket.watchGroup().id()));
            } else {
                bucketBuilder.setWatchGroup(OFGroup.ANY);
            }
            OFBucket ofBucket = bucketBuilder.build();
            ofBuckets.add(ofBucket);
        }
        OFGroupModify groupMsg = this.factory.buildGroupModify().setGroup(OFGroup.of((int)this.groupId.id())).setBuckets(ofBuckets).setGroupType(this.getOFGroupType(this.type)).setXid(this.xid.longValue()).build();
        return groupMsg;
    }

    public OFGroupDelete buildGroupDel() {
        OFGroupDelete groupMsg = this.factory.buildGroupDelete().setGroup(OFGroup.of((int)this.groupId.id())).setGroupType(OFGroupType.SELECT).setXid(this.xid.longValue()).build();
        return groupMsg;
    }

    private List<OFAction> buildActions(TrafficTreatment treatment) {
        if (treatment == null) {
            return Collections.emptyList();
        }
        LinkedList<OFAction> actions = new LinkedList<OFAction>();
        block8: for (Instruction i : treatment.allInstructions()) {
            switch (i.type()) {
                case L0MODIFICATION: {
                    actions.add(this.buildL0Modification(i));
                    continue block8;
                }
                case L2MODIFICATION: {
                    actions.add(this.buildL2Modification(i));
                    continue block8;
                }
                case L3MODIFICATION: {
                    actions.add(this.buildL3Modification(i));
                    continue block8;
                }
                case OUTPUT: {
                    Instructions.OutputInstruction out = (Instructions.OutputInstruction)i;
                    OFActionOutput.Builder action = this.factory.actions().buildOutput().setPort(OFPort.of((int)((int)out.port().toLong())));
                    if (out.port().equals((Object)PortNumber.CONTROLLER)) {
                        action.setMaxLen(65535);
                    }
                    actions.add((OFAction)action.build());
                    continue block8;
                }
                case GROUP: {
                    Instructions.GroupInstruction grp = (Instructions.GroupInstruction)i;
                    OFActionGroup.Builder actgrp = this.factory.actions().buildGroup().setGroup(OFGroup.of((int)grp.groupId().id()));
                    actions.add((OFAction)actgrp.build());
                    continue block8;
                }
                case EXTENSION: {
                    Instructions.ExtensionInstructionWrapper wrapper = (Instructions.ExtensionInstructionWrapper)i;
                    actions.add(this.buildExtensionAction(wrapper.extensionInstruction(), wrapper.deviceId()));
                    continue block8;
                }
            }
            this.log.warn("Instruction type {} not yet implemented.", (Object)i.type());
        }
        return actions;
    }

    private OFAction buildL0Modification(Instruction i) {
        L0ModificationInstruction l0m = (L0ModificationInstruction)i;
        switch (l0m.subtype()) {
            default: 
        }
        this.log.warn("Unimplemented action type {}.", (Object)l0m.subtype());
        return null;
    }

    private OFAction buildL2Modification(Instruction i) {
        L2ModificationInstruction l2m = (L2ModificationInstruction)i;
        OFOxmVlanPcp oxm = null;
        switch (l2m.subtype()) {
            case ETH_DST: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                oxm = this.factory.oxms().ethDst(MacAddress.of((long)eth.mac().toLong()));
                break;
            }
            case ETH_SRC: {
                L2ModificationInstruction.ModEtherInstruction eth = (L2ModificationInstruction.ModEtherInstruction)l2m;
                oxm = this.factory.oxms().ethSrc(MacAddress.of((long)eth.mac().toLong()));
                break;
            }
            case VLAN_ID: {
                L2ModificationInstruction.ModVlanIdInstruction vlanId = (L2ModificationInstruction.ModVlanIdInstruction)l2m;
                oxm = this.factory.oxms().vlanVid(OFVlanVidMatch.ofVlan((int)vlanId.vlanId().toShort()));
                break;
            }
            case VLAN_PCP: {
                L2ModificationInstruction.ModVlanPcpInstruction vlanPcp = (L2ModificationInstruction.ModVlanPcpInstruction)l2m;
                oxm = this.factory.oxms().vlanPcp(VlanPcp.of((byte)vlanPcp.vlanPcp()));
                break;
            }
            case VLAN_POP: {
                return this.factory.actions().popVlan();
            }
            case VLAN_PUSH: {
                L2ModificationInstruction.ModVlanHeaderInstruction pushVlanInstruction = (L2ModificationInstruction.ModVlanHeaderInstruction)l2m;
                return this.factory.actions().pushVlan(EthType.of((int)pushVlanInstruction.ethernetType().toShort()));
            }
            case MPLS_PUSH: {
                L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstructions = (L2ModificationInstruction.ModMplsHeaderInstruction)l2m;
                return this.factory.actions().pushMpls(EthType.of((int)pushHeaderInstructions.ethernetType().toShort()));
            }
            case MPLS_POP: {
                L2ModificationInstruction.ModMplsHeaderInstruction popHeaderInstructions = (L2ModificationInstruction.ModMplsHeaderInstruction)l2m;
                return this.factory.actions().popMpls(EthType.of((int)popHeaderInstructions.ethernetType().toShort()));
            }
            case MPLS_LABEL: {
                L2ModificationInstruction.ModMplsLabelInstruction mplsLabel = (L2ModificationInstruction.ModMplsLabelInstruction)l2m;
                oxm = this.factory.oxms().mplsLabel(U32.of((long)mplsLabel.label().toInt()));
                break;
            }
            case MPLS_BOS: {
                L2ModificationInstruction.ModMplsBosInstruction mplsBos = (L2ModificationInstruction.ModMplsBosInstruction)l2m;
                oxm = this.factory.oxms().mplsBos(mplsBos.mplsBos() ? OFBooleanValue.TRUE : OFBooleanValue.FALSE);
                break;
            }
            case DEC_MPLS_TTL: {
                return this.factory.actions().decMplsTtl();
            }
            case TUNNEL_ID: {
                L2ModificationInstruction.ModTunnelIdInstruction tunnelId = (L2ModificationInstruction.ModTunnelIdInstruction)l2m;
                oxm = this.factory.oxms().tunnelId(U64.of((long)tunnelId.tunnelId()));
                break;
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l2m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory.actions().buildSetField().setField((OFOxm)oxm).build();
        }
        return null;
    }

    private OFAction buildL3Modification(Instruction i) {
        L3ModificationInstruction l3m = (L3ModificationInstruction)i;
        OFOxmIpv6Flabel oxm = null;
        switch (l3m.subtype()) {
            case IPV4_SRC: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                oxm = this.factory.oxms().ipv4Src(IPv4Address.of((int)ip4.toInt()));
                break;
            }
            case IPV4_DST: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip4Address ip4 = ip.ip().getIp4Address();
                oxm = this.factory.oxms().ipv4Dst(IPv4Address.of((int)ip4.toInt()));
                break;
            }
            case IPV6_SRC: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip6Address ip6 = ip.ip().getIp6Address();
                oxm = this.factory.oxms().ipv6Src(IPv6Address.of((byte[])ip6.toOctets()));
                break;
            }
            case IPV6_DST: {
                L3ModificationInstruction.ModIPInstruction ip = (L3ModificationInstruction.ModIPInstruction)i;
                Ip6Address ip6 = ip.ip().getIp6Address();
                oxm = this.factory.oxms().ipv6Dst(IPv6Address.of((byte[])ip6.toOctets()));
                break;
            }
            case IPV6_FLABEL: {
                L3ModificationInstruction.ModIPv6FlowLabelInstruction flowLabelInstruction = (L3ModificationInstruction.ModIPv6FlowLabelInstruction)i;
                int flowLabel = flowLabelInstruction.flowLabel();
                oxm = this.factory.oxms().ipv6Flabel(IPv6FlowLabel.of((int)flowLabel));
                break;
            }
            case DEC_TTL: {
                return this.factory.actions().decNwTtl();
            }
            case TTL_IN: {
                return this.factory.actions().copyTtlIn();
            }
            case TTL_OUT: {
                return this.factory.actions().copyTtlOut();
            }
            default: {
                this.log.warn("Unimplemented action type {}.", (Object)l3m.subtype());
            }
        }
        if (oxm != null) {
            return this.factory.actions().buildSetField().setField((OFOxm)oxm).build();
        }
        return null;
    }

    private OFGroupType getOFGroupType(GroupDescription.Type groupType) {
        switch (groupType) {
            case INDIRECT: {
                return OFGroupType.INDIRECT;
            }
            case SELECT: {
                return OFGroupType.SELECT;
            }
            case FAILOVER: {
                return OFGroupType.FF;
            }
            case ALL: {
                return OFGroupType.ALL;
            }
        }
        this.log.error("Unsupported group type : {}", (Object)groupType);
        return null;
    }

    private OFAction buildExtensionAction(ExtensionTreatment i, DeviceId deviceId) {
        if (!this.driverService.isPresent()) {
            this.log.error("No driver service present");
            return null;
        }
        Driver driver = this.driverService.get().getDriver(deviceId);
        if (driver.hasBehaviour(ExtensionTreatmentInterpreter.class)) {
            DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driver, deviceId));
            ExtensionTreatmentInterpreter interpreter = (ExtensionTreatmentInterpreter)handler.behaviour(ExtensionTreatmentInterpreter.class);
            return interpreter.mapInstruction(this.factory, i);
        }
        return null;
    }
}

