/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.group.impl;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.util.Timer;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.group.impl.OpenFlowGroupProvider;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFGroupStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.types.OFGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupStatsCollector
implements TimerTask {
    private final HashedWheelTimer timer = Timer.getTimer();
    private final OpenFlowSwitch sw;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int refreshInterval;
    private Timeout timeout;
    private boolean stopTimer = false;

    public GroupStatsCollector(OpenFlowSwitch sw, int interval) {
        this.sw = sw;
        this.refreshInterval = interval;
    }

    public void run(Timeout timeout) throws Exception {
        this.log.trace("Collecting stats for {}", (Object)this.sw.getStringId());
        this.sendGroupStatistic();
        if (!this.stopTimer) {
            this.log.trace("Scheduling stats collection in {} seconds for {}", (Object)this.refreshInterval, (Object)this.sw.getStringId());
            timeout.getTimer().newTimeout((TimerTask)this, (long)this.refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void sendGroupStatistic() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendGroupStatistics {}:{}", (Object)this.sw.getStringId(), (Object)this.sw.getRole());
        }
        if (this.sw.getRole() != RoleState.MASTER) {
            return;
        }
        if (!this.sw.isConnected()) {
            return;
        }
        Long statsXid = OpenFlowGroupProvider.getXidAndAdd(2);
        OFGroupStatsRequest statsRequest = this.sw.factory().buildGroupStatsRequest().setGroup(OFGroup.ALL).setXid(statsXid.longValue()).build();
        this.sw.sendMsg((OFMessage)statsRequest);
        Long descXid = statsXid + 1L;
        OFGroupDescStatsRequest descStatsRequest = this.sw.factory().buildGroupDescStatsRequest().setXid(descXid.longValue()).build();
        this.sw.sendMsg((OFMessage)descStatsRequest);
    }

    public void start() {
        this.log.info("Starting Group Stats collection thread for {}", (Object)this.sw.getStringId());
        this.timeout = this.timer.newTimeout((TimerTask)this, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.log.info("Stopping Group Stats collection thread for {}", (Object)this.sw.getStringId());
        this.stopTimer = true;
        this.timeout.cancel();
    }
}

