/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.group.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProvider;
import org.onosproject.net.group.GroupProviderRegistry;
import org.onosproject.net.group.GroupProviderService;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowEventListener;
import org.onosproject.openflow.controller.OpenFlowMessageListener;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.OpenFlowSwitchListener;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.openflow.controller.RoleState;
import org.onosproject.provider.of.group.impl.OpenFlowGroupProvider;
import org.projectfloodlight.openflow.protocol.OFFactories;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupModFailedCode;
import org.projectfloodlight.openflow.protocol.OFGroupModify;
import org.projectfloodlight.openflow.protocol.OFGroupStatsReply;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFGroupModFailedErrorMsg;
import org.projectfloodlight.openflow.types.OFGroup;

public class OpenFlowGroupProviderTest {
    OpenFlowGroupProvider provider = new OpenFlowGroupProvider();
    private final OpenFlowController controller = new TestController();
    GroupProviderRegistry providerRegistry = new TestGroupProviderRegistry();
    GroupProviderService providerService;
    private DeviceId deviceId = DeviceId.deviceId((String)"of:0000000000000001");
    private Dpid dpid1 = Dpid.dpid((URI)this.deviceId.uri());

    @Before
    public void setUp() {
        this.provider.controller = this.controller;
        this.provider.providerRegistry = this.providerRegistry;
        this.provider.activate();
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)this.providerService);
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void addGroup() {
        DefaultGroupId groupId = new DefaultGroupId(1);
        ArrayList bucketList = Lists.newArrayList();
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.setOutput(PortNumber.portNumber((long)1L));
        GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)builder.build());
        bucketList.add(bucket);
        GroupBuckets buckets = new GroupBuckets((List)bucketList);
        ArrayList operationList = Lists.newArrayList();
        GroupOperation operation = GroupOperation.createAddGroupOperation((GroupId)groupId, (GroupDescription.Type)GroupDescription.Type.SELECT, (GroupBuckets)buckets);
        operationList.add(operation);
        GroupOperations operations = new GroupOperations((List)operationList);
        this.provider.performGroupOperation(this.deviceId, operations);
        Dpid dpid = Dpid.dpid((URI)this.deviceId.uri());
        TestOpenFlowSwitch sw = (TestOpenFlowSwitch)this.controller.getSwitch(dpid);
        Assert.assertNotNull((String)"Switch should not be nul", (Object)sw);
        Assert.assertNotNull((String)"OFGroupMsg should not be null", (Object)sw.msg);
    }

    @Test
    public void groupModFailure() {
        TestOpenFlowGroupProviderService testProviderService = (TestOpenFlowGroupProviderService)this.providerService;
        DefaultGroupId groupId = new DefaultGroupId(1);
        ArrayList bucketList = Lists.newArrayList();
        TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
        builder.setOutput(PortNumber.portNumber((long)1L));
        GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)builder.build());
        bucketList.add(bucket);
        GroupBuckets buckets = new GroupBuckets((List)bucketList);
        ArrayList operationList = Lists.newArrayList();
        GroupOperation operation = GroupOperation.createAddGroupOperation((GroupId)groupId, (GroupDescription.Type)GroupDescription.Type.SELECT, (GroupBuckets)buckets);
        operationList.add(operation);
        GroupOperations operations = new GroupOperations((List)operationList);
        this.provider.performGroupOperation(this.deviceId, operations);
        OFGroupModFailedErrorMsg.Builder errorBuilder = OFFactories.getFactory((OFVersion)OFVersion.OF_13).errorMsgs().buildGroupModFailedErrorMsg();
        OFGroupModify.Builder groupBuilder = OFFactories.getFactory((OFVersion)OFVersion.OF_13).buildGroupModify();
        groupBuilder.setGroupType(OFGroupType.ALL);
        groupBuilder.setGroup(OFGroup.of((int)1));
        errorBuilder.setCode(OFGroupModFailedCode.GROUP_EXISTS);
        errorBuilder.setXid(OpenFlowGroupProvider.getXidAndAdd((int)0) - 1L);
        this.controller.processPacket(this.dpid1, (OFMessage)errorBuilder.build());
        Assert.assertNotNull((String)"Operation failed should not be null", (Object)testProviderService.failedOperation);
    }

    @Test
    public void groupStatsEvent() {
        TestOpenFlowGroupProviderService testProviderService = (TestOpenFlowGroupProviderService)this.providerService;
        OFGroupStatsReply.Builder rep1 = OFFactories.getFactory((OFVersion)OFVersion.OF_13).buildGroupStatsReply();
        rep1.setXid(1L);
        this.controller.processPacket(this.dpid1, (OFMessage)rep1.build());
        OFGroupDescStatsReply.Builder rep2 = OFFactories.getFactory((OFVersion)OFVersion.OF_13).buildGroupDescStatsReply();
        Assert.assertNull((String)"group entries is not set yet", testProviderService.getGroupEntries());
        rep2.setXid(2L);
        this.controller.processPacket(this.dpid1, (OFMessage)rep2.build());
        Assert.assertNotNull((String)"group entries should be set", testProviderService.getGroupEntries());
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.providerRegistry = null;
        this.provider.controller = null;
    }

    private class TestOpenFlowSwitch
    implements OpenFlowSwitch {
        OFMessage msg = null;

        private TestOpenFlowSwitch() {
        }

        public void sendMsg(OFMessage msg) {
            this.msg = msg;
        }

        public void sendMsg(List<OFMessage> msgs) {
        }

        public void handleMessage(OFMessage fromSwitch) {
        }

        public void setRole(RoleState role) {
        }

        public RoleState getRole() {
            return null;
        }

        public List<OFPortDesc> getPorts() {
            return null;
        }

        public OFFactory factory() {
            return OFFactories.getFactory((OFVersion)OFVersion.OF_13);
        }

        public String getStringId() {
            return null;
        }

        public long getId() {
            return 0L;
        }

        public String manufacturerDescription() {
            return null;
        }

        public String datapathDescription() {
            return null;
        }

        public String hardwareDescription() {
            return null;
        }

        public String softwareDescription() {
            return null;
        }

        public String serialNumber() {
            return null;
        }

        public boolean isConnected() {
            return false;
        }

        public void disconnectSwitch() {
        }

        public void returnRoleReply(RoleState requested, RoleState response) {
        }

        public Device.Type deviceType() {
            return Device.Type.SWITCH;
        }

        public String channelId() {
            return null;
        }
    }

    private class TestGroupProviderRegistry
    implements GroupProviderRegistry {
        private TestGroupProviderRegistry() {
        }

        public GroupProviderService register(GroupProvider provider) {
            OpenFlowGroupProviderTest.this.providerService = new TestOpenFlowGroupProviderService(provider);
            return OpenFlowGroupProviderTest.this.providerService;
        }

        public void unregister(GroupProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }

    private class TestController
    implements OpenFlowController {
        OpenFlowEventListener eventListener = null;
        List<OpenFlowSwitch> switches = Lists.newArrayList();

        public TestController() {
            TestOpenFlowSwitch testSwitch = new TestOpenFlowSwitch();
            this.switches.add(testSwitch);
        }

        public void addListener(OpenFlowSwitchListener listener) {
        }

        public void removeListener(OpenFlowSwitchListener listener) {
        }

        public void addMessageListener(OpenFlowMessageListener listener) {
        }

        public void removeMessageListener(OpenFlowMessageListener listener) {
        }

        public void addPacketListener(int priority, PacketListener listener) {
        }

        public void removePacketListener(PacketListener listener) {
        }

        public void addEventListener(OpenFlowEventListener listener) {
            this.eventListener = listener;
        }

        public void removeEventListener(OpenFlowEventListener listener) {
        }

        public void write(Dpid dpid, OFMessage msg) {
        }

        public void processPacket(Dpid dpid, OFMessage msg) {
            this.eventListener.handleMessage(dpid, msg);
        }

        public void setRole(Dpid dpid, RoleState role) {
        }

        public Iterable<OpenFlowSwitch> getSwitches() {
            return this.switches;
        }

        public Iterable<OpenFlowSwitch> getMasterSwitches() {
            return null;
        }

        public Iterable<OpenFlowSwitch> getEqualSwitches() {
            return null;
        }

        public OpenFlowSwitch getSwitch(Dpid dpid) {
            return this.switches.get(0);
        }

        public OpenFlowSwitch getMasterSwitch(Dpid dpid) {
            return null;
        }

        public OpenFlowSwitch getEqualSwitch(Dpid dpid) {
            return null;
        }
    }

    private class TestOpenFlowGroupProviderService
    extends AbstractProviderService<GroupProvider>
    implements GroupProviderService {
        Collection<Group> groups;
        GroupOperation failedOperation;

        protected TestOpenFlowGroupProviderService(GroupProvider provider) {
            super((Provider)provider);
            this.groups = null;
            this.failedOperation = null;
        }

        public void groupOperationFailed(DeviceId deviceId, GroupOperation operation) {
            this.failedOperation = operation;
        }

        public void pushGroupMetrics(DeviceId deviceId, Collection<Group> groupEntries) {
            this.groups = groupEntries;
        }

        public void notifyOfFailovers(Collection<Group> groups) {
        }

        public Collection<Group> getGroupEntries() {
            return this.groups;
        }
    }
}

