/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.message.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.EnumHashBiMap;
import org.onosproject.cpman.ControlMessage;
import org.projectfloodlight.openflow.protocol.OFType;

public final class OpenFlowControlMessageMapper {
    private static final BiMap<OFType, ControlMessage.Type> MESSAGE_TYPE = EnumHashBiMap.create(OFType.class);

    private OpenFlowControlMessageMapper() {
    }

    private static <I, O> O lookup(BiMap<I, O> map, I input, Class<O> cls) {
        if (!map.containsKey(input)) {
            throw new RuntimeException(String.format("No mapping found for %s when converting to %s", input, cls.getName()));
        }
        return (O)map.get(input);
    }

    public static ControlMessage.Type lookupControlMessageType(OFType type) {
        return OpenFlowControlMessageMapper.lookup(MESSAGE_TYPE, type, ControlMessage.Type.class);
    }

    public static OFType lookupOFType(ControlMessage.Type type) {
        return OpenFlowControlMessageMapper.lookup(MESSAGE_TYPE.inverse(), type, OFType.class);
    }

    static {
        MESSAGE_TYPE.put((Object)OFType.PACKET_IN, (Object)ControlMessage.Type.INBOUND_PACKET);
        MESSAGE_TYPE.put((Object)OFType.PACKET_OUT, (Object)ControlMessage.Type.OUTBOUND_PACKET);
        MESSAGE_TYPE.put((Object)OFType.FLOW_MOD, (Object)ControlMessage.Type.FLOW_MOD_PACKET);
        MESSAGE_TYPE.put((Object)OFType.FLOW_REMOVED, (Object)ControlMessage.Type.FLOW_REMOVED_PACKET);
        MESSAGE_TYPE.put((Object)OFType.STATS_REQUEST, (Object)ControlMessage.Type.REQUEST_PACKET);
        MESSAGE_TYPE.put((Object)OFType.STATS_REPLY, (Object)ControlMessage.Type.REPLY_PACKET);
    }
}

