/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.message.impl;

import com.codahale.metrics.Meter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.onlab.metrics.MetricsComponent;
import org.onlab.metrics.MetricsFeature;
import org.onlab.metrics.MetricsService;
import org.onosproject.cpman.ControlMessage;
import org.onosproject.cpman.DefaultControlMessage;
import org.onosproject.cpman.message.ControlMessageProviderService;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.of.message.impl.OpenFlowControlMessageMapper;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFlowControlMessageAggregator
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Set<OFType> OF_TYPE_SET = ImmutableSet.of((Object)OFType.PACKET_IN, (Object)OFType.PACKET_OUT, (Object)OFType.FLOW_MOD, (Object)OFType.FLOW_REMOVED, (Object)OFType.STATS_REQUEST, (Object)OFType.STATS_REPLY, (Object[])new OFType[0]);
    private final Map<OFType, Meter> rateMeterMap = Maps.newHashMap();
    private final Map<OFType, Meter> countMeterMap = Maps.newHashMap();
    private final DeviceId deviceId;
    private final ControlMessageProviderService providerService;
    private static final String RATE_NAME = "rate";
    private static final String COUNT_NAME = "count";
    private Set<ControlMessage> controlMessages = Sets.newConcurrentHashSet();
    private static final int EXECUTE_PERIOD_IN_SECOND = 60;

    public OpenFlowControlMessageAggregator(MetricsService metricsService, ControlMessageProviderService providerService, DeviceId deviceId) {
        MetricsComponent mc = metricsService.registerComponent(deviceId.toString());
        OF_TYPE_SET.forEach(type -> {
            MetricsFeature metricsFeature = mc.registerFeature(type.toString());
            Meter rateMeter = metricsService.createMeter(mc, metricsFeature, RATE_NAME);
            Meter countMeter = metricsService.createMeter(mc, metricsFeature, COUNT_NAME);
            this.rateMeterMap.put((OFType)type, rateMeter);
            this.countMeterMap.put((OFType)type, countMeter);
        });
        this.deviceId = deviceId;
        this.providerService = providerService;
        metricsService.notifyReporters();
    }

    public void increment(OFMessage msg) {
        this.rateMeterMap.get(msg.getType()).mark((long)msg.toString().length());
        this.countMeterMap.get(msg.getType()).mark(1L);
    }

    @Override
    public void run() {
        OF_TYPE_SET.forEach(type -> this.controlMessages.add((ControlMessage)new DefaultControlMessage(OpenFlowControlMessageMapper.lookupControlMessageType(type), this.deviceId, this.getLoad((OFType)type), this.getRate((OFType)type), this.getCount((OFType)type), System.currentTimeMillis())));
        this.log.debug("sent aggregated control message");
        this.providerService.updateStatsInfo(this.deviceId, (Set)ImmutableSet.copyOf(this.controlMessages));
        this.controlMessages.clear();
    }

    private long getLoad(OFType type) {
        if (this.countMeterMap.get(type).getOneMinuteRate() == 0.0) {
            return 0L;
        }
        return (long)(this.rateMeterMap.get(type).getOneMinuteRate() / this.countMeterMap.get(type).getOneMinuteRate());
    }

    private long getRate(OFType type) {
        return (long)this.rateMeterMap.get(type).getOneMinuteRate();
    }

    private long getCount(OFType type) {
        return (long)(this.countMeterMap.get(type).getOneMinuteRate() * 60.0);
    }
}

