/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.meter.impl;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.onlab.util.Timer;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.RoleState;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMeterStatsRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterStatsCollector
implements TimerTask {
    private final HashedWheelTimer timer = Timer.getTimer();
    private final OpenFlowSwitch sw;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int refreshInterval;
    private Timeout timeout;
    private boolean stopTimer = false;

    public MeterStatsCollector(OpenFlowSwitch sw, int interval) {
        this.sw = sw;
        this.refreshInterval = interval;
    }

    public void run(Timeout timeout) throws Exception {
        if (!this.sw.isConnected()) {
            this.log.debug("Switch {} disconnected. Aborting meter stats collection", (Object)this.sw.getStringId());
            return;
        }
        this.log.trace("Collecting stats for {}", (Object)this.sw.getStringId());
        this.sendMeterStatistic();
        if (!this.stopTimer) {
            this.log.trace("Scheduling stats collection in {} seconds for {}", (Object)this.refreshInterval, (Object)this.sw.getStringId());
            timeout.getTimer().newTimeout((TimerTask)this, (long)this.refreshInterval, TimeUnit.SECONDS);
        }
    }

    private void sendMeterStatistic() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendMeterStatistics {}:{}", (Object)this.sw.getStringId(), (Object)this.sw.getRole());
        }
        if (this.sw.getRole() != RoleState.MASTER) {
            return;
        }
        OFMeterStatsRequest.Builder builder = this.sw.factory().buildMeterStatsRequest();
        builder.setXid(0L).setMeterId(-1L);
        this.sw.sendMsg((OFMessage)builder.build());
    }

    public void start() {
        this.log.info("Starting Meter Stats collection thread for {}", (Object)this.sw.getStringId());
        this.timeout = this.timer.newTimeout((TimerTask)this, 1L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.log.info("Stopping Meter Stats collection thread for {}", (Object)this.sw.getStringId());
        this.stopTimer = true;
        this.timeout.cancel();
    }
}

