/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.meter.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFMeterMod;
import org.projectfloodlight.openflow.protocol.OFMeterModCommand;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBand;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBandDrop;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBandDscpRemark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MeterModBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long xid;
    private final OFFactory factory;
    private Meter.Unit unit = Meter.Unit.KB_PER_SEC;
    private boolean burst = false;
    private Long id;
    private Collection<Band> bands;

    public MeterModBuilder(long xid, OFFactory factory) {
        this.xid = xid;
        this.factory = factory;
    }

    public static MeterModBuilder builder(long xid, OFFactory factory) {
        return new MeterModBuilder(xid, factory);
    }

    public MeterModBuilder withRateUnit(Meter.Unit unit) {
        this.unit = unit;
        return this;
    }

    public MeterModBuilder burst() {
        this.burst = true;
        return this;
    }

    public MeterModBuilder withId(MeterId meterId) {
        this.id = (Long)meterId.id();
        return this;
    }

    public MeterModBuilder withBands(Collection<Band> bands) {
        this.bands = bands;
        return this;
    }

    public OFMeterMod add() {
        this.validate();
        OFMeterMod.Builder builder = this.builderMeterMod();
        builder.setCommand(OFMeterModCommand.ADD.ordinal());
        return builder.build();
    }

    public OFMeterMod remove() {
        this.validate();
        OFMeterMod.Builder builder = this.builderMeterMod();
        builder.setCommand(OFMeterModCommand.DELETE.ordinal());
        return builder.build();
    }

    public OFMeterMod modify() {
        this.validate();
        OFMeterMod.Builder builder = this.builderMeterMod();
        builder.setCommand(OFMeterModCommand.MODIFY.ordinal());
        return builder.build();
    }

    private OFMeterMod.Builder builderMeterMod() {
        OFMeterMod.Builder builder = this.factory.buildMeterMod();
        int flags = 0;
        if (this.burst) {
            flags |= 1 << OFMeterFlags.BURST.ordinal();
        }
        switch (this.unit) {
            case PKTS_PER_SEC: {
                flags |= 1 << OFMeterFlags.PKTPS.ordinal();
                break;
            }
            case KB_PER_SEC: {
                flags |= 1 << OFMeterFlags.KBPS.ordinal();
                break;
            }
            default: {
                this.log.warn("Unknown unit type {}", (Object)this.unit);
            }
        }
        builder.setMeters(this.buildBands());
        builder.setFlags(flags).setMeterId(this.id.longValue()).setXid(this.xid);
        return builder;
    }

    private List<OFMeterBand> buildBands() {
        return this.bands.stream().map(b -> {
            switch (b.type()) {
                case DROP: {
                    OFMeterBandDrop.Builder dropBuilder = this.factory.meterBands().buildDrop();
                    if (this.burst) {
                        dropBuilder.setBurstSize(b.burst().longValue());
                    }
                    dropBuilder.setRate(b.rate());
                    return dropBuilder.build();
                }
                case REMARK: {
                    OFMeterBandDscpRemark.Builder remarkBand = this.factory.meterBands().buildDscpRemark();
                    if (this.burst) {
                        remarkBand.setBurstSize(b.burst().longValue());
                    }
                    remarkBand.setRate(b.rate());
                    remarkBand.setPrecLevel(b.dropPrecedence().shortValue());
                    return remarkBand.build();
                }
            }
            this.log.warn("Unknown band type {}", (Object)b.type());
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.id, (Object)"id cannot be null");
        Preconditions.checkNotNull(this.bands, (Object)"Must have bands");
        Preconditions.checkArgument((this.bands.size() > 0 ? 1 : 0) != 0, (Object)"Must have at lease one band");
    }
}

