/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.packet.impl;

import java.util.List;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Ethernet;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFlowCorePacketContext
extends DefaultPacketContext {
    private static final Logger log = LoggerFactory.getLogger(OpenFlowCorePacketContext.class);
    private final OpenFlowPacketContext ofPktCtx;

    protected OpenFlowCorePacketContext(long time, InboundPacket inPkt, OutboundPacket outPkt, boolean block, OpenFlowPacketContext ofPktCtx) {
        super(time, inPkt, outPkt, block);
        this.ofPktCtx = ofPktCtx;
    }

    public void send() {
        if (!this.block()) {
            if (this.outPacket() == null) {
                this.sendPacket(null);
            } else {
                try {
                    Ethernet eth = (Ethernet)Ethernet.deserializer().deserialize(this.outPacket().data().array(), 0, this.outPacket().data().array().length);
                    this.sendPacket(eth);
                }
                catch (DeserializationException e) {
                    log.warn("Unable to deserialize packet");
                }
            }
        }
    }

    private void sendPacket(Ethernet eth) {
        List ins = this.treatmentBuilder().build().allInstructions();
        OFPort p = null;
        for (Instruction i : ins) {
            if (i.type() != Instruction.Type.OUTPUT) continue;
            p = this.buildPort(((Instructions.OutputInstruction)i).port());
            break;
        }
        if (eth == null) {
            this.ofPktCtx.build(p);
        } else {
            this.ofPktCtx.build(eth, p);
        }
        this.ofPktCtx.send();
    }

    private OFPort buildPort(PortNumber port) {
        return OFPort.of((int)((int)port.toLong()));
    }
}

