/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.of.packet.impl;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProvider;
import org.onosproject.net.packet.PacketProviderRegistry;
import org.onosproject.net.packet.PacketProviderService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowController;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.openflow.controller.PacketListener;
import org.onosproject.provider.of.packet.impl.OpenFlowCorePacketContext;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpenFlowPacketProvider
extends AbstractProvider
implements PacketProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OpenFlowController controller;
    private PacketProviderService providerService;
    private final InternalPacketProvider listener = new InternalPacketProvider();

    public OpenFlowPacketProvider() {
        super(new ProviderId("of", "org.onosproject.provider.openflow"));
    }

    @Activate
    public void activate() {
        this.providerService = (PacketProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addPacketListener(20, (PacketListener)this.listener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.controller.removePacketListener((PacketListener)this.listener);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public void emit(OutboundPacket packet) {
        DeviceId devId = packet.sendThrough();
        String scheme = devId.toString().split(":")[0];
        if (!scheme.equals(this.id().scheme())) {
            throw new IllegalArgumentException("Don't know how to handle Device with scheme " + scheme);
        }
        Dpid dpid = Dpid.dpid((URI)devId.uri());
        OpenFlowSwitch sw = this.controller.getSwitch(dpid);
        if (sw == null) {
            this.log.warn("Device {} isn't available?", (Object)devId);
            return;
        }
        OFPortDesc p = null;
        for (Instruction inst : packet.treatment().allInstructions()) {
            if (!inst.type().equals((Object)Instruction.Type.OUTPUT)) continue;
            p = this.portDesc(((Instructions.OutputInstruction)inst).port());
            OFPacketOut po = this.packetOut(sw, packet.data().array(), p.getPortNo());
            sw.sendMsg((OFMessage)po);
        }
    }

    private OFPortDesc portDesc(PortNumber port) {
        OFPortDesc.Builder builder = OFFactoryVer10.INSTANCE.buildPortDesc();
        builder.setPortNo(OFPort.of((int)((int)port.toLong())));
        return builder.build();
    }

    private OFPacketOut packetOut(OpenFlowSwitch sw, byte[] eth, OFPort out) {
        OFPacketOut.Builder builder = sw.factory().buildPacketOut();
        OFActionOutput act = sw.factory().actions().buildOutput().setPort(out).build();
        return builder.setBufferId(OFBufferId.NO_BUFFER).setInPort(OFPort.CONTROLLER).setActions(Collections.singletonList(act)).setData(eth).build();
    }

    protected void bindProviderRegistry(PacketProviderRegistry packetProviderRegistry) {
        this.providerRegistry = packetProviderRegistry;
    }

    protected void unbindProviderRegistry(PacketProviderRegistry packetProviderRegistry) {
        if (this.providerRegistry == packetProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindController(OpenFlowController openFlowController) {
        this.controller = openFlowController;
    }

    protected void unbindController(OpenFlowController openFlowController) {
        if (this.controller == openFlowController) {
            this.controller = null;
        }
    }

    private class InternalPacketProvider
    implements PacketListener {
        private InternalPacketProvider() {
        }

        public void handlePacket(OpenFlowPacketContext pktCtx) {
            DeviceId id = DeviceId.deviceId((URI)Dpid.uri((long)pktCtx.dpid().value()));
            DefaultInboundPacket inPkt = new DefaultInboundPacket(new ConnectPoint((ElementId)id, PortNumber.portNumber((long)pktCtx.inPort().intValue())), pktCtx.parsed(), ByteBuffer.wrap(pktCtx.unparsed()), pktCtx.cookie());
            DefaultOutboundPacket outPkt = null;
            if (!pktCtx.isBuffered()) {
                outPkt = new DefaultOutboundPacket(id, null, ByteBuffer.wrap(pktCtx.unparsed()));
            }
            OpenFlowCorePacketContext corePktCtx = new OpenFlowCorePacketContext(System.currentTimeMillis(), (InboundPacket)inPkt, (OutboundPacket)outPkt, pktCtx.isHandled(), pktCtx);
            OpenFlowPacketProvider.this.providerService.processPacket((PacketContext)corePktCtx);
        }
    }
}

