/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.providers.device;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.TpPort;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbEventListener;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbNodeListener;
import org.onosproject.ovsdb.providers.device.OvsdbDeviceProvider;

public class OvsdbDeviceProviderTest {
    private final OvsdbDeviceProvider provider = new OvsdbDeviceProvider();
    private final TestDeviceRegistry registry = new TestDeviceRegistry();
    private final TestController controller = new TestController();

    @Before
    public void startUp() {
        this.provider.providerRegistry = this.registry;
        this.provider.controller = this.controller;
        this.provider.activate();
        Assert.assertNotNull((String)"provider should be registered", (Object)this.registry.provider);
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.controller = null;
        this.provider.providerRegistry = null;
    }

    @Test
    public void triggerProbe() {
    }

    @Test
    public void testNodeAdded() {
        this.controller.listener.nodeAdded(new OvsdbNodeId(IpAddress.valueOf((String)"192.168.202.36"), 5000L));
        Assert.assertEquals((String)"ovsdb node added", (long)1L, (long)this.registry.connected.size());
    }

    @Test
    public void testNodeRemoved() {
        this.controller.listener.nodeAdded(new OvsdbNodeId(IpAddress.valueOf((String)"192.168.202.36"), 5000L));
        this.controller.listener.nodeRemoved(new OvsdbNodeId(IpAddress.valueOf((String)"192.168.202.36"), 5000L));
        Assert.assertEquals((String)"ovsdb node removded", (long)0L, (long)this.registry.connected.size());
    }

    private class TestController
    implements OvsdbController {
        OvsdbNodeListener listener = null;

        private TestController() {
        }

        public void addNodeListener(OvsdbNodeListener listener) {
            this.listener = listener;
        }

        public void removeNodeListener(OvsdbNodeListener listener) {
            this.listener = null;
        }

        public void addOvsdbEventListener(OvsdbEventListener listener) {
        }

        public void removeOvsdbEventListener(OvsdbEventListener listener) {
        }

        public List<OvsdbNodeId> getNodeIds() {
            return null;
        }

        public OvsdbClientService getOvsdbClient(OvsdbNodeId nodeId) {
            return null;
        }

        public void connect(IpAddress ip, TpPort port) {
        }
    }

    private class TestDeviceRegistry
    implements DeviceProviderRegistry {
        DeviceProvider provider;
        Set<DeviceId> connected = new HashSet<DeviceId>();
        Multimap<DeviceId, PortDescription> ports = HashMultimap.create();
        PortDescription descr = null;

        private TestDeviceRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.provider = provider;
            return new TestProviderService();
        }

        public void unregister(DeviceProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }

        private class TestProviderService
        implements DeviceProviderService {
            private TestProviderService() {
            }

            public DeviceProvider provider() {
                return null;
            }

            public void deviceConnected(DeviceId deviceId, DeviceDescription deviceDescription) {
                TestDeviceRegistry.this.connected.add(deviceId);
            }

            public void deviceDisconnected(DeviceId deviceId) {
                TestDeviceRegistry.this.connected.remove(deviceId);
                TestDeviceRegistry.this.ports.removeAll((Object)deviceId);
            }

            public void updatePorts(DeviceId deviceId, List<PortDescription> portDescriptions) {
                for (PortDescription p : portDescriptions) {
                    TestDeviceRegistry.this.ports.put((Object)deviceId, (Object)p);
                }
            }

            public void portStatusChanged(DeviceId deviceId, PortDescription portDescription) {
                TestDeviceRegistry.this.ports.put((Object)deviceId, (Object)portDescription);
                TestDeviceRegistry.this.descr = portDescription;
            }

            public void receivedRoleReply(DeviceId deviceId, MastershipRole requested, MastershipRole response) {
            }

            public void updatePortStatistics(DeviceId deviceId, Collection<PortStatistics> portStatistics) {
            }
        }
    }
}

