/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.providers.device;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ovsdb.controller.OvsdbClientService;
import org.onosproject.ovsdb.controller.OvsdbController;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbNodeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class OvsdbDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected OvsdbController controller;
    private DeviceProviderService providerService;
    private OvsdbNodeListener innerNodeListener = new InnerOvsdbNodeListener();
    protected static final String ISNOTNULL = "OvsdbNodeId is not null";
    private static final String UNKNOWN = "unknown";

    @Activate
    public void activate() {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.controller.addNodeListener(this.innerNodeListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    public OvsdbDeviceProvider() {
        super(new ProviderId("ovsdb", "org.onosproject.ovsdb.provider.device"));
    }

    public void triggerProbe(DeviceId deviceId) {
        this.log.info("Triggering probe on device {}", (Object)deviceId);
        if (!this.isReachable(deviceId)) {
            this.log.error("Failed to probe device {}", (Object)deviceId);
            this.providerService.deviceDisconnected(deviceId);
        } else {
            this.log.trace("Confirmed device {} connection", (Object)deviceId);
        }
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        OvsdbClientService ovsdbClient = this.controller.getOvsdbClient(this.changeDeviceIdToNodeId(deviceId));
        return ovsdbClient != null && ovsdbClient.isConnected();
    }

    private OvsdbNodeId changeDeviceIdToNodeId(DeviceId deviceId) {
        String[] strings = deviceId.toString().split(":");
        if (strings.length < 1) {
            return null;
        }
        return new OvsdbNodeId(IpAddress.valueOf((String)strings[1]), 0L);
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindController(OvsdbController ovsdbController) {
        this.controller = ovsdbController;
    }

    protected void unbindController(OvsdbController ovsdbController) {
        if (this.controller == ovsdbController) {
            this.controller = null;
        }
    }

    private class InnerOvsdbNodeListener
    implements OvsdbNodeListener {
        private InnerOvsdbNodeListener() {
        }

        public void nodeAdded(OvsdbNodeId nodeId) {
            Preconditions.checkNotNull((Object)nodeId, (Object)OvsdbDeviceProvider.ISNOTNULL);
            DeviceId deviceId = DeviceId.deviceId((String)nodeId.toString());
            URI uri = URI.create(nodeId.toString());
            ChassisId cid = new ChassisId();
            String ipAddress = nodeId.getIpAddress();
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("ipaddress", ipAddress).build();
            DefaultDeviceDescription deviceDescription = new DefaultDeviceDescription(uri, Device.Type.CONTROLLER, OvsdbDeviceProvider.UNKNOWN, OvsdbDeviceProvider.UNKNOWN, OvsdbDeviceProvider.UNKNOWN, OvsdbDeviceProvider.UNKNOWN, cid, new SparseAnnotations[]{annotations});
            OvsdbDeviceProvider.this.providerService.deviceConnected(deviceId, (DeviceDescription)deviceDescription);
        }

        public void nodeRemoved(OvsdbNodeId nodeId) {
            Preconditions.checkNotNull((Object)nodeId, (Object)OvsdbDeviceProvider.ISNOTNULL);
            DeviceId deviceId = DeviceId.deviceId((String)nodeId.toString());
            OvsdbDeviceProvider.this.providerService.deviceDisconnected(deviceId);
        }
    }
}

