/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.provider.tunnel;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderRegistry;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ovsdb.provider.tunnel.OvsdbTunnelProvider;

public class OvsdbTunnelProviderTest {
    private final OvsdbTunnelProvider provider = new OvsdbTunnelProvider();
    private final TestTunnelRegistry tunnelRegistry = new TestTunnelRegistry();
    private TestTunnelProviderService providerService;
    Link link = DefaultLink.builder().providerId(this.provider.id()).src(ConnectPoint.deviceConnectPoint((String)"192.168.2.3/20")).dst(ConnectPoint.deviceConnectPoint((String)"192.168.2.4/30")).type(Link.Type.DIRECT).build();

    @Before
    public void setUp() {
        this.provider.providerRegistry = this.tunnelRegistry;
        this.provider.activate();
    }

    @Test
    public void basics() {
        Assert.assertNotNull((String)"registration expected", (Object)((Object)this.providerService));
        Assert.assertEquals((String)"incorrect provider", (Object)this.provider, (Object)this.providerService.provider());
    }

    @Test
    public void testTunnelAdded() {
        IpTunnelEndPoint src = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)"192.168.1.1"));
        IpTunnelEndPoint dst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)"192.168.1.3"));
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("bandwidth", "1024").build();
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(this.link);
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(TunnelId.valueOf((String)"1234"), (TunnelEndPoint)src, (TunnelEndPoint)dst, Tunnel.Type.VXLAN, new DefaultGroupId(0), this.provider.id(), TunnelName.tunnelName((String)"tunnel12"), (Path)new DefaultPath(this.provider.id(), links, 0.3, new Annotations[0]), new SparseAnnotations[]{annotations});
        this.provider.tunnelAdded((TunnelDescription)tunnel);
        Assert.assertEquals((long)1L, (long)this.providerService.tunnelSet.size());
    }

    @Test
    public void testTunnelRemoved() {
        IpTunnelEndPoint src = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)"192.168.1.1"));
        IpTunnelEndPoint dst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)"192.168.1.3"));
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("bandwidth", "1024").build();
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(this.link);
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(TunnelId.valueOf((String)"1234"), (TunnelEndPoint)src, (TunnelEndPoint)dst, Tunnel.Type.VXLAN, new DefaultGroupId(0), this.provider.id(), TunnelName.tunnelName((String)"tunnel1"), (Path)new DefaultPath(this.provider.id(), links, 0.3, new Annotations[0]), new SparseAnnotations[]{annotations});
        this.provider.tunnelRemoved((TunnelDescription)tunnel);
        Assert.assertEquals((long)0L, (long)this.providerService.tunnelSet.size());
    }

    @After
    public void tearDown() {
        this.provider.deactivate();
        this.provider.providerRegistry = null;
    }

    private class TestTunnelProviderService
    extends AbstractProviderService<TunnelProvider>
    implements TunnelProviderService {
        Set<TunnelDescription> tunnelSet;

        protected TestTunnelProviderService(TunnelProvider provider) {
            super((Provider)provider);
            this.tunnelSet = new HashSet<TunnelDescription>();
        }

        public TunnelId tunnelAdded(TunnelDescription tunnel) {
            this.tunnelSet.add(tunnel);
            return null;
        }

        public TunnelId tunnelAdded(TunnelDescription tunnel, Tunnel.State state) {
            return null;
        }

        public void tunnelRemoved(TunnelDescription tunnel) {
            this.tunnelSet.remove(tunnel);
        }

        public void tunnelUpdated(TunnelDescription tunnel) {
        }

        public void tunnelUpdated(TunnelDescription tunnel, Tunnel.State state) {
        }

        public Tunnel tunnelQueryById(TunnelId tunnelId) {
            return null;
        }
    }

    private class TestTunnelRegistry
    implements TunnelProviderRegistry {
        private TestTunnelRegistry() {
        }

        public TunnelProviderService register(TunnelProvider provider) {
            OvsdbTunnelProviderTest.this.providerService = new TestTunnelProviderService(provider);
            return OvsdbTunnelProviderTest.this.providerService;
        }

        public void unregister(TunnelProvider provider) {
        }

        public Set<ProviderId> getProviders() {
            return null;
        }
    }
}

