/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.Channel;
import org.junit.Assert;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.LspKey;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcepio.protocol.PcepFactories;
import org.onosproject.pcepio.protocol.PcepFactory;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.PcepVersion;

public class PcepClientAdapter
implements PcepClient {
    private Channel channel;
    protected String channelId;
    private boolean connected;
    private PccId pccId;
    private ClientCapability capability;
    private PcepVersion pcepVersion;
    private PcepSyncStatus lspDbSyncStatus;
    private PcepSyncStatus labelDbSyncStatus;
    private Map<LspKey, Boolean> lspDelegationInfo = new HashMap<LspKey, Boolean>();
    private Map<PccId, List<PcepStateReport>> sycRptCache = new HashMap<PccId, List<PcepStateReport>>();

    public void init(PccId pccId, PcepVersion pcepVersion) {
        this.pccId = pccId;
        this.pcepVersion = pcepVersion;
    }

    public final void disconnectClient() {
        this.channel.close();
    }

    public final void sendMessage(PcepMessage m) {
    }

    public final void sendMessage(List<PcepMessage> msgs) {
        PcepMessage pcepMsg = msgs.get(0);
        Assert.assertNotNull((String)"PCEP MSG should be created.", (Object)pcepMsg);
    }

    public final boolean isConnected() {
        return this.connected;
    }

    public String channelId() {
        return this.channelId;
    }

    public final PccId getPccId() {
        return this.pccId;
    }

    public final String getStringId() {
        return this.pccId.toString();
    }

    public final void handleMessage(PcepMessage m) {
    }

    public boolean isOptical() {
        return false;
    }

    public PcepFactory factory() {
        return PcepFactories.getFactory((PcepVersion)this.pcepVersion);
    }

    public void setLspDbSyncStatus(PcepSyncStatus syncStatus) {
        this.lspDbSyncStatus = syncStatus;
    }

    public PcepSyncStatus lspDbSyncStatus() {
        return this.lspDbSyncStatus;
    }

    public void setLabelDbSyncStatus(PcepSyncStatus syncStatus) {
        this.labelDbSyncStatus = syncStatus;
    }

    public PcepSyncStatus labelDbSyncStatus() {
        return this.labelDbSyncStatus;
    }

    public void setCapability(ClientCapability capability) {
        this.capability = capability;
    }

    public ClientCapability capability() {
        return this.capability;
    }

    public void addNode(PcepClient pc) {
    }

    public void deleteNode(PccId pccId) {
    }

    public void setLspAndDelegationInfo(LspKey lspKey, boolean dFlag) {
        this.lspDelegationInfo.put(lspKey, dFlag);
    }

    public Boolean delegationInfo(LspKey lspKey) {
        return this.lspDelegationInfo.get(lspKey);
    }

    public void initializeSyncMsgList(PccId pccId) {
        LinkedList rptMsgList = new LinkedList();
        this.sycRptCache.put(pccId, rptMsgList);
    }

    public List<PcepStateReport> getSyncMsgList(PccId pccId) {
        return this.sycRptCache.get(pccId);
    }

    public void removeSyncMsgList(PccId pccId) {
        this.sycRptCache.remove(pccId);
    }

    public void addSyncMsgToList(PccId pccId, PcepStateReport rptMsg) {
        List<PcepStateReport> rptMsgList = this.sycRptCache.get(pccId);
        rptMsgList.add(rptMsg);
        this.sycRptCache.put(pccId, rptMsgList);
    }
}

