/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.controller.ClientCapability;
import org.onosproject.pcep.controller.LspType;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.provider.pcep.tunnel.impl.PcepClientControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepControllerAdapter;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelProvider;
import org.onosproject.provider.pcep.tunnel.impl.TunnelProviderRegistryAdapter;
import org.onosproject.provider.pcep.tunnel.impl.TunnelServiceAdapter;

public class PcepSetupTunnelProviderTest {
    private static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    private PcepTunnelProvider tunnelProvider = new PcepTunnelProvider();
    private final TunnelProviderRegistryAdapter registry = new TunnelProviderRegistryAdapter();
    private final PcepClientControllerAdapter controller = new PcepClientControllerAdapter();
    private final PcepControllerAdapter ctl = new PcepControllerAdapter();
    private final TunnelServiceAdapter tunnelService = new TunnelServiceAdapter();
    private final DeviceServiceAdapter deviceService = new DeviceServiceAdapter();
    private final MastershipServiceAdapter mastershipService = new MastershipServiceAdapter();

    @Before
    public void setUp() throws IOException {
        this.tunnelProvider.tunnelProviderRegistry = this.registry;
        this.tunnelProvider.pcepClientController = this.controller;
        this.tunnelProvider.controller = this.ctl;
        this.tunnelProvider.deviceService = this.deviceService;
        this.tunnelProvider.mastershipService = this.mastershipService;
        this.tunnelProvider.cfgService = new ComponentConfigAdapter();
        this.tunnelProvider.tunnelService = this.tunnelService;
        this.tunnelProvider.activate();
    }

    @Test
    public void testCasePcepSetupTunnel() {
        ProviderId pid = new ProviderId("pcep", PROVIDER_ID);
        ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
        IpAddress srcIp = IpAddress.valueOf((int)0xC010101);
        IpElementId srcElementId = IpElementId.ipElement((IpAddress)srcIp);
        IpAddress dstIp = IpAddress.valueOf((int)201392386);
        IpElementId dstElementId = IpElementId.ipElement((IpAddress)dstIp);
        IpTunnelEndPoint ipTunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint ipTunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        ConnectPoint src = new ConnectPoint((ElementId)srcElementId, PortNumber.portNumber((long)10023L));
        ConnectPoint dst = new ConnectPoint((ElementId)dstElementId, PortNumber.portNumber((long)10023L));
        DefaultLink link = DefaultLink.builder().providerId(pid).src(src).dst(dst).type(Link.Type.DIRECT).build();
        links.add(link);
        DefaultPath path = new DefaultPath(pid, links, 10.0, new Annotations[]{DefaultAnnotations.EMPTY});
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("lspSigType", LspType.WITH_SIGNALLING.name()).build();
        DefaultTunnel tunnel = new DefaultTunnel(pid, (TunnelEndPoint)ipTunnelEndPointSrc, (TunnelEndPoint)ipTunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), TunnelId.valueOf((String)"1"), TunnelName.tunnelName((String)"T123"), (Path)path, new Annotations[]{annotations});
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((int)0xC010101))).setCapability(new ClientCapability(true, true, true, true, true));
        this.tunnelProvider.setupTunnel((Tunnel)tunnel, (Path)path);
        MatcherAssert.assertThat((Object)this.tunnelProvider.pcepTunnelApiMapper, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCasePcepSetupTunnel2() {
        ProviderId pid = new ProviderId("pcep", PROVIDER_ID);
        ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
        IpAddress srcIp = IpAddress.valueOf((int)201392387);
        IpElementId srcElementId = IpElementId.ipElement((IpAddress)srcIp);
        IpAddress dstIp = IpAddress.valueOf((int)201392386);
        IpElementId dstElementId = IpElementId.ipElement((IpAddress)dstIp);
        IpTunnelEndPoint ipTunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint ipTunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        ConnectPoint src = new ConnectPoint((ElementId)srcElementId, PortNumber.portNumber((long)10023L));
        ConnectPoint dst = new ConnectPoint((ElementId)dstElementId, PortNumber.portNumber((long)10023L));
        DefaultLink link = DefaultLink.builder().providerId(pid).src(src).dst(dst).type(Link.Type.DIRECT).build();
        links.add(link);
        DefaultPath path = new DefaultPath(pid, links, 10.0, new Annotations[]{DefaultAnnotations.EMPTY});
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("lspSigType", LspType.WITH_SIGNALLING.name()).build();
        DefaultTunnel tunnel = new DefaultTunnel(pid, (TunnelEndPoint)ipTunnelEndPointSrc, (TunnelEndPoint)ipTunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), TunnelId.valueOf((String)"1"), TunnelName.tunnelName((String)"T123"), (Path)path, new Annotations[]{annotations});
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((int)201392387))).setCapability(new ClientCapability(true, true, true, true, true));
        this.tunnelProvider.setupTunnel((Tunnel)tunnel, (Path)path);
        MatcherAssert.assertThat((Object)this.tunnelProvider.pcepTunnelApiMapper.checkFromTunnelRequestQueue(1), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCasePcepSetupSrTunnel() {
        ProviderId pid = new ProviderId("pcep", PROVIDER_ID);
        ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
        IpAddress srcIp = IpAddress.valueOf((int)0xC010101);
        IpElementId srcElementId = IpElementId.ipElement((IpAddress)srcIp);
        IpAddress dstIp = IpAddress.valueOf((int)201392386);
        IpElementId dstElementId = IpElementId.ipElement((IpAddress)dstIp);
        IpTunnelEndPoint ipTunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint ipTunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        ConnectPoint src = new ConnectPoint((ElementId)srcElementId, PortNumber.portNumber((long)10023L));
        ConnectPoint dst = new ConnectPoint((ElementId)dstElementId, PortNumber.portNumber((long)10023L));
        DefaultLink link = DefaultLink.builder().providerId(pid).src(src).dst(dst).type(Link.Type.DIRECT).build();
        links.add(link);
        DefaultPath path = new DefaultPath(pid, links, 10.0, new Annotations[]{DefaultAnnotations.EMPTY});
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("lspSigType", LspType.SR_WITHOUT_SIGNALLING.name()).build();
        DefaultTunnel tunnel = new DefaultTunnel(pid, (TunnelEndPoint)ipTunnelEndPointSrc, (TunnelEndPoint)ipTunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), TunnelId.valueOf((String)"1"), TunnelName.tunnelName((String)"T123"), (Path)path, new Annotations[]{annotations});
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((int)0xC010101))).setCapability(new ClientCapability(true, true, true, true, true));
        this.tunnelProvider.setupTunnel((Tunnel)tunnel, (Path)path);
        MatcherAssert.assertThat((Object)this.tunnelProvider.pcepTunnelApiMapper, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
    }

    @Test
    public void testCasePcepSetupTunnelWithoutSigSr() {
        ProviderId pid = new ProviderId("pcep", PROVIDER_ID);
        ArrayList<DefaultLink> links = new ArrayList<DefaultLink>();
        IpAddress srcIp = IpAddress.valueOf((int)0xC010101);
        IpElementId srcElementId = IpElementId.ipElement((IpAddress)srcIp);
        IpAddress dstIp = IpAddress.valueOf((int)201392386);
        IpElementId dstElementId = IpElementId.ipElement((IpAddress)dstIp);
        IpTunnelEndPoint ipTunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint ipTunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        ConnectPoint src = new ConnectPoint((ElementId)srcElementId, PortNumber.portNumber((long)10023L));
        ConnectPoint dst = new ConnectPoint((ElementId)dstElementId, PortNumber.portNumber((long)10023L));
        DefaultLink link = DefaultLink.builder().providerId(pid).src(src).dst(dst).type(Link.Type.DIRECT).build();
        links.add(link);
        DefaultPath path = new DefaultPath(pid, links, 10.0, new Annotations[]{DefaultAnnotations.EMPTY});
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("lspSigType", LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR.name()).build();
        DefaultTunnel tunnel = new DefaultTunnel(pid, (TunnelEndPoint)ipTunnelEndPointSrc, (TunnelEndPoint)ipTunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), TunnelId.valueOf((String)"1"), TunnelName.tunnelName((String)"T123"), (Path)path, new Annotations[]{annotations});
        this.controller.getClient(PccId.pccId((IpAddress)IpAddress.valueOf((int)0xC010101))).setCapability(new ClientCapability(true, true, true, true, true));
        this.tunnelProvider.setupTunnel((Tunnel)tunnel, (Path)path);
        MatcherAssert.assertThat((Object)this.tunnelProvider.pcepTunnelApiMapper, (Matcher)IsNot.not((Matcher)Matchers.nullValue()));
    }

    @After
    public void tearDown() throws IOException {
        this.tunnelProvider.deactivate();
        this.tunnelProvider.controller = null;
        this.tunnelProvider.pcepClientController = null;
        this.tunnelProvider.tunnelProviderRegistry = null;
        this.tunnelProvider.deviceService = null;
        this.tunnelProvider.mastershipService = null;
    }
}

