/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.pcep.tunnel.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.tunnel.DefaultLabelStack;
import org.onosproject.incubator.net.tunnel.DefaultOpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.DefaultTunnelDescription;
import org.onosproject.incubator.net.tunnel.DefaultTunnelStatistics;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.OpticalLogicId;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelAdminService;
import org.onosproject.incubator.net.tunnel.TunnelDescription;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelProvider;
import org.onosproject.incubator.net.tunnel.TunnelProviderRegistry;
import org.onosproject.incubator.net.tunnel.TunnelProviderService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.incubator.net.tunnel.TunnelStatistics;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pcep.api.PcepController;
import org.onosproject.pcep.api.PcepDpid;
import org.onosproject.pcep.api.PcepHopNodeDescription;
import org.onosproject.pcep.api.PcepOperator;
import org.onosproject.pcep.api.PcepTunnel;
import org.onosproject.pcep.api.PcepTunnelListener;
import org.onosproject.pcep.api.PcepTunnelStatistics;
import org.onosproject.pcep.controller.LspKey;
import org.onosproject.pcep.controller.LspType;
import org.onosproject.pcep.controller.PccId;
import org.onosproject.pcep.controller.PcepClient;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepClientListener;
import org.onosproject.pcep.controller.PcepEventListener;
import org.onosproject.pcep.controller.PcepLspStatus;
import org.onosproject.pcep.controller.PcepLspSyncAction;
import org.onosproject.pcep.controller.PcepSyncStatus;
import org.onosproject.pcep.controller.SrpIdGenerators;
import org.onosproject.pcepio.exceptions.PcepParseException;
import org.onosproject.pcepio.protocol.PcInitiatedLspRequest;
import org.onosproject.pcepio.protocol.PcepAttribute;
import org.onosproject.pcepio.protocol.PcepBandwidthObject;
import org.onosproject.pcepio.protocol.PcepEndPointsObject;
import org.onosproject.pcepio.protocol.PcepEroObject;
import org.onosproject.pcepio.protocol.PcepInitiateMsg;
import org.onosproject.pcepio.protocol.PcepLspObject;
import org.onosproject.pcepio.protocol.PcepMessage;
import org.onosproject.pcepio.protocol.PcepMetricObject;
import org.onosproject.pcepio.protocol.PcepMsgPath;
import org.onosproject.pcepio.protocol.PcepReportMsg;
import org.onosproject.pcepio.protocol.PcepSrpObject;
import org.onosproject.pcepio.protocol.PcepStateReport;
import org.onosproject.pcepio.protocol.PcepUpdateMsg;
import org.onosproject.pcepio.protocol.PcepUpdateRequest;
import org.onosproject.pcepio.types.IPv4SubObject;
import org.onosproject.pcepio.types.PathSetupTypeTlv;
import org.onosproject.pcepio.types.PcepNaiIpv4Adjacency;
import org.onosproject.pcepio.types.PcepValueType;
import org.onosproject.pcepio.types.SrEroSubObject;
import org.onosproject.pcepio.types.StatefulIPv4LspIdentifiersTlv;
import org.onosproject.pcepio.types.SymbolicPathNameTlv;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelApiMapper;
import org.onosproject.provider.pcep.tunnel.impl.PcepTunnelData;
import org.onosproject.provider.pcep.tunnel.impl.RequestType;
import org.onosproject.provider.pcep.tunnel.impl.TunnelStatsCollector;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PcepTunnelProvider
extends AbstractProvider
implements TunnelProvider {
    private static final Logger log = LoggerFactory.getLogger(PcepTunnelProvider.class);
    private static final long MAX_BANDWIDTH = 99999744L;
    private static final long MIN_BANDWIDTH = 64L;
    private static final String BANDWIDTH_UINT = "kbps";
    static final String PROVIDER_ID = "org.onosproject.provider.tunnel.pcep";
    public static final long IDENTIFIER_SET = 0x100000000L;
    public static final long SET = 0xFFFFFFFFL;
    private static final int DELAY = 2;
    private static final int WAIT_TIME = 5;
    public static final String LSRID = "lsrId";
    static final int POLL_INTERVAL = 10;
    @Property(name="tunnelStatsPollFrequency", intValue={10}, label="Frequency (in seconds) for polling tunnel statistics")
    private int tunnelStatsPollFrequency = 10;
    private static final String TUNNLE_NOT_NULL = "Create failed,The given port may be wrong or has been occupied.";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelProviderRegistry tunnelProviderRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PcepClientController pcepClientController;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelAdminService tunnelAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    TunnelProviderService service;
    HashMap<String, TunnelId> tunnelMap = new HashMap();
    HashMap<TunnelId, TunnelStatistics> tunnelStatisticsMap = new HashMap();
    private HashMap<String, TunnelStatsCollector> collectors = Maps.newHashMap();
    private InnerTunnelProvider listener = new InnerTunnelProvider();
    protected PcepTunnelApiMapper pcepTunnelApiMapper = new PcepTunnelApiMapper();
    private static final int DEFAULT_BANDWIDTH_VALUE = 10;

    public PcepTunnelProvider() {
        super(new ProviderId("pcep", PROVIDER_ID));
    }

    @Activate
    public void activate() {
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.service = (TunnelProviderService)this.tunnelProviderRegistry.register((Provider)this);
        this.controller.addTunnelListener((PcepTunnelListener)this.listener);
        this.pcepClientController.addListener((PcepClientListener)this.listener);
        this.pcepClientController.addEventListener((PcepEventListener)this.listener);
        this.tunnelService.queryAllTunnels().forEach(tunnel -> {
            String pcepTunnelId = this.getPcepTunnelKey(tunnel.tunnelId());
            TunnelStatsCollector tsc = new TunnelStatsCollector(pcepTunnelId, this.tunnelStatsPollFrequency);
            tsc.start();
            this.collectors.put((String)tunnel.tunnelId().id(), tsc);
        });
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.tunnelProviderRegistry.unregister((Provider)this);
        this.controller.removeTunnelListener((PcepTunnelListener)this.listener);
        this.collectors.values().forEach(TunnelStatsCollector::stop);
        this.pcepClientController.removeListener((PcepClientListener)this.listener);
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        int newTunnelStatsPollFrequency;
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"tunnelStatsPollFrequency");
            newTunnelStatsPollFrequency = Strings.isNullOrEmpty((String)s) ? this.tunnelStatsPollFrequency : Integer.parseInt(s.trim());
        }
        catch (ClassCastException | NumberFormatException e) {
            newTunnelStatsPollFrequency = this.tunnelStatsPollFrequency;
        }
        if (newTunnelStatsPollFrequency != this.tunnelStatsPollFrequency) {
            this.tunnelStatsPollFrequency = newTunnelStatsPollFrequency;
            this.collectors.values().forEach(tsc -> tsc.adjustPollInterval(this.tunnelStatsPollFrequency));
            log.info("New setting: tunnelStatsPollFrequency={}", (Object)this.tunnelStatsPollFrequency);
        }
    }

    public void setupTunnel(Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        if (pc.capability().pcInstantiationCapability() && this.mastershipService.isLocalMaster(this.getDevice(pc.getPccId()))) {
            this.pcepSetupTunnel(tunnel, path, pc);
        }
    }

    public void setupTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
        if (tunnel.annotations().value("PLspId") != null) {
            if (LspType.valueOf((String)tunnel.annotations().value("lspSigType")) != LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR) {
                this.updateTunnel(tunnel, path);
            } else {
                Collection tunnels = this.tunnelService.queryTunnel(tunnel.src(), tunnel.dst());
                for (Tunnel t : tunnels) {
                    if (!t.state().equals((Object)Tunnel.State.INIT) || !t.tunnelName().equals((Object)tunnel.tunnelName())) continue;
                    tunnel = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), t.state(), tunnel.groupId(), t.tunnelId(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
                    break;
                }
                if (!this.pcepClientController.allocateLocalLabel(tunnel)) {
                    log.error("Unable to allocate labels for the tunnel {}.", (Object)tunnel.toString());
                }
            }
            return;
        }
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with this device {}" + srcElement.toString());
            return;
        }
        if (pc.capability().pcInstantiationCapability() && this.mastershipService.isLocalMaster(this.getDevice(pc.getPccId()))) {
            this.pcepSetupTunnel(tunnel, path, pc);
        }
    }

    public void releaseTunnel(Tunnel tunnel) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        if (pc.capability().pcInstantiationCapability() && this.mastershipService.isLocalMaster(this.getDevice(pc.getPccId()))) {
            this.pcepReleaseTunnel(tunnel, pc);
        }
    }

    public void releaseTunnel(ElementId srcElement, Tunnel tunnel) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(srcElement instanceof IpElementId)) {
            log.error("Element id is not valid");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpElementId)srcElement).ipAddress()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpElementId)srcElement).ipAddress().toString());
            return;
        }
        if (pc.capability().pcInstantiationCapability() && this.mastershipService.isLocalMaster(this.getDevice(pc.getPccId()))) {
            this.pcepReleaseTunnel(tunnel, pc);
        }
    }

    public void updateTunnel(Tunnel tunnel, Path path) {
        PcepClient pc;
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        Collection tunnels = this.tunnelService.queryTunnel(tunnel.src(), tunnel.dst());
        for (Tunnel t : tunnels) {
            if (!t.state().equals((Object)Tunnel.State.INIT) || !t.tunnelName().equals((Object)tunnel.tunnelName())) continue;
            tunnel = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), t.state(), tunnel.groupId(), t.tunnelId(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
            break;
        }
        if (!((pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpTunnelEndPoint)tunnel.src()).ip()))) instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpTunnelEndPoint)tunnel.src()).ip().toString());
            return;
        }
        if (pc.capability().statefulPceCapability()) {
            if (tunnel.annotations().value("pceInit") != null && tunnel.annotations().value("pceInit").equals("true")) {
                this.pcepUpdateTunnel(tunnel, path, pc);
            } else {
                Short localLspId = 0;
                for (Tunnel t : tunnels) {
                    if (t.tunnelId().equals((Object)tunnel.tunnelId()) || !t.tunnelName().equals((Object)tunnel.tunnelName())) continue;
                    localLspId = Short.valueOf(t.annotations().value("localLspId"));
                }
                if (localLspId == 0) {
                    log.error("Local LSP ID for old tunnel not found");
                    return;
                }
                if (pc.delegationInfo(new LspKey(Integer.valueOf(tunnel.annotations().value("PLspId")).intValue(), localLspId.shortValue())) != null) {
                    this.pcepUpdateTunnel(tunnel, path, pc);
                }
            }
        }
    }

    public void updateTunnel(ElementId srcElement, Tunnel tunnel, Path path) {
        if (tunnel.type() != Tunnel.Type.MPLS) {
            log.error("Tunnel Type MPLS is only supported");
            return;
        }
        if (!(srcElement instanceof IpElementId)) {
            log.error("Element id is not valid");
            return;
        }
        if (!(tunnel.src() instanceof IpTunnelEndPoint) || !(tunnel.dst() instanceof IpTunnelEndPoint)) {
            log.error("Tunnel source or destination is not valid");
            return;
        }
        PcepClient pc = this.pcepClientController.getClient(PccId.pccId((IpAddress)((IpElementId)srcElement).ipAddress()));
        if (!(pc instanceof PcepClient)) {
            log.error("There is no PCC connected with ip addresss {}" + ((IpElementId)srcElement).ipAddress().toString());
            return;
        }
        if (pc.capability().statefulPceCapability() && pc.delegationInfo(new LspKey(Integer.valueOf(tunnel.annotations().value("PLspId")).intValue(), Short.valueOf(tunnel.annotations().value("localLspId")).shortValue())) != null) {
            this.pcepUpdateTunnel(tunnel, path, pc);
        }
    }

    public TunnelId tunnelAdded(TunnelDescription tunnel) {
        return this.handleTunnelAdded(tunnel, null);
    }

    public TunnelId tunnelAdded(TunnelDescription tunnel, Tunnel.State tunnelState) {
        return this.handleTunnelAdded(tunnel, tunnelState);
    }

    private TunnelId handleTunnelAdded(TunnelDescription tunnel, Tunnel.State tunnelState) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelApiMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            if (tunnelState == null) {
                return this.service.tunnelAdded(tunnel);
            }
            return this.service.tunnelAdded(tunnel, tunnelState);
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return null;
        }
        OpticalTunnelEndPoint src = (OpticalTunnelEndPoint)tunnel.src();
        OpticalTunnelEndPoint dst = (OpticalTunnelEndPoint)tunnel.dst();
        DeviceId srcId = (DeviceId)src.elementId().get();
        DeviceId dstId = (DeviceId)dst.elementId().get();
        long srcPort = ((PortNumber)src.portNumber().get()).toLong();
        long dstPort = ((PortNumber)dst.portNumber().get()).toLong();
        if (tunnel.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel creation.");
            return null;
        }
        PcepTunnel pcepTunnel = this.controller.applyTunnel(srcId, dstId, srcPort, dstPort, bandwidth, tunnel.tunnelName().value());
        Preconditions.checkNotNull((Object)pcepTunnel, (Object)TUNNLE_NOT_NULL);
        TunnelDescription tunnelAdded = this.buildOpticalTunnel(pcepTunnel, null);
        TunnelId tunnelId = this.service.tunnelAdded(tunnelAdded);
        this.tunnelMap.put(String.valueOf(pcepTunnel.id()), tunnelId);
        return tunnelId;
    }

    private void tunnelUpdated(Tunnel tunnel, Path path, Tunnel.State tunnelState) {
        this.handleTunnelUpdate(tunnel, path, tunnelState);
    }

    private void handleTunnelUpdate(Tunnel tunnel, Path path, Tunnel.State tunnelState) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelApiMapper.removeFromCoreTunnelRequestQueue(tunnel.tunnelId());
            DefaultTunnelDescription td = new DefaultTunnelDescription(tunnel.tunnelId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), tunnel.providerId(), tunnel.tunnelName(), path, tunnel.resource(), new SparseAnnotations[]{(SparseAnnotations)tunnel.annotations()});
            this.service.tunnelUpdated((TunnelDescription)td, tunnelState);
            return;
        }
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.tunnelId());
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel update.");
            return;
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return;
        }
        String pcepTunnelId = this.getPcepTunnelKey(tunnel.tunnelId());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"Invalid tunnel id");
        if (!this.controller.updateTunnelBandwidth(pcepTunnelId, bandwidth).booleanValue()) {
            this.error("Update failed,maybe invalid bandwidth.");
            return;
        }
        this.tunnelAdminService.updateTunnel(tunnel, path);
    }

    public void tunnelRemoved(TunnelDescription tunnel) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelApiMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            this.service.tunnelRemoved(tunnel);
            return;
        }
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.id());
        Preconditions.checkNotNull((Object)tunnelOld, (Object)"The tunnel id is not exsited.");
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel deletion.");
            return;
        }
        String pcepTunnelId = this.getPcepTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"The tunnel id is not exsited.");
        if (!this.controller.deleteTunnel(pcepTunnelId).booleanValue()) {
            this.error("Delete tunnel failed, Maybe some devices have been disconnected.");
            return;
        }
        this.tunnelMap.remove(pcepTunnelId);
        this.service.tunnelRemoved(tunnel);
    }

    public void tunnelUpdated(TunnelDescription tunnel) {
        this.handleTunnelUpdate(tunnel, null);
    }

    public void tunnelUpdated(TunnelDescription tunnel, Tunnel.State tunnelState) {
        this.handleTunnelUpdate(tunnel, tunnelState);
    }

    private void handleTunnelUpdate(TunnelDescription tunnel, Tunnel.State tunnelState) {
        if (tunnel.type() == Tunnel.Type.MPLS) {
            this.pcepTunnelApiMapper.removeFromCoreTunnelRequestQueue(tunnel.id());
            if (tunnelState == null) {
                this.service.tunnelUpdated(tunnel);
            } else {
                this.service.tunnelUpdated(tunnel, tunnelState);
            }
            return;
        }
        Tunnel tunnelOld = this.tunnelQueryById(tunnel.id());
        if (tunnelOld.type() != Tunnel.Type.VLAN) {
            this.error("Illegal tunnel type. Only support VLAN tunnel update.");
            return;
        }
        long bandwidth = Long.parseLong(tunnel.annotations().value("bandwidth"));
        if (bandwidth < 64L || bandwidth > 99999744L) {
            this.error("Update failed, invalid bandwidth.");
            return;
        }
        String pcepTunnelId = this.getPcepTunnelKey(tunnel.id());
        Preconditions.checkNotNull((Object)pcepTunnelId, (Object)"Invalid tunnel id");
        if (!this.controller.updateTunnelBandwidth(pcepTunnelId, bandwidth).booleanValue()) {
            this.error("Update failed,maybe invalid bandwidth.");
            return;
        }
        this.service.tunnelUpdated(tunnel);
    }

    private void error(String info) {
        System.err.println(info);
    }

    private ConnectPoint connectPoint(PcepDpid id, long port) {
        return new ConnectPoint((ElementId)DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)id)), PortNumber.portNumber((long)port));
    }

    private Link link(PcepDpid src, long sp, PcepDpid dst, long dp) {
        return DefaultLink.builder().providerId(this.id()).src(this.connectPoint(src, sp)).dst(this.connectPoint(dst, dp)).type(Link.Type.TUNNEL).build();
    }

    private Path createPath(List<PcepHopNodeDescription> hopList, PcepTunnel.PathType pathtype, PcepTunnel.PathState pathState) {
        if (hopList == null || hopList.size() == 0) {
            return null;
        }
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 1; i < hopList.size() - 1; i += 2) {
            links.add(this.link(hopList.get(i).getDeviceId(), hopList.get(i).getPortNum(), hopList.get(i + 1).getDeviceId(), hopList.get(i + 1).getPortNum()));
        }
        int hopNum = hopList.size() - 2;
        DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("pathNum", String.valueOf(hopNum)).set("pathState", String.valueOf(pathState)).set("pathType", String.valueOf(pathtype)).build();
        return new DefaultPath(this.id(), links, (double)hopNum, new Annotations[]{extendAnnotations});
    }

    public String pathToString(List<Link> links) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Link link : links) {
            builder.append("(Device:" + link.src().deviceId() + "  Port:" + link.src().port().toLong());
            builder.append(" Device:" + link.dst().deviceId() + "  Port:" + link.dst().port().toLong());
            builder.append(")");
        }
        builder.append("}");
        return builder.toString();
    }

    private TunnelDescription buildOpticalTunnel(PcepTunnel pcepTunnel, TunnelId tunnelId) {
        DefaultOpticalTunnelEndPoint srcPoint = null;
        DefaultOpticalTunnelEndPoint dstPoint = null;
        Tunnel.Type tunnelType = null;
        TunnelName name = TunnelName.tunnelName((String)pcepTunnel.name());
        Path path = this.createPath(pcepTunnel.getHopList(), pcepTunnel.getPathType(), pcepTunnel.getPathState());
        OpticalTunnelEndPoint.Type endPointType = null;
        switch (pcepTunnel.type()) {
            case OCH: {
                tunnelType = Tunnel.Type.OCH;
                endPointType = OpticalTunnelEndPoint.Type.LAMBDA;
                break;
            }
            case OTN: {
                tunnelType = Tunnel.Type.ODUK;
                endPointType = OpticalTunnelEndPoint.Type.TIMESLOT;
                break;
            }
            case UNI: {
                tunnelType = Tunnel.Type.VLAN;
                endPointType = null;
                break;
            }
        }
        DeviceId srcDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.srcDeviceID()));
        DeviceId dstDid = DeviceId.deviceId((URI)PcepDpid.uri((PcepDpid)pcepTunnel.dstDeviceId()));
        PortNumber srcPort = PortNumber.portNumber((long)pcepTunnel.srcPort());
        PortNumber dstPort = PortNumber.portNumber((long)pcepTunnel.dstPort());
        srcPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(srcDid), Optional.of(srcPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        dstPoint = new DefaultOpticalTunnelEndPoint(this.id(), Optional.of(dstDid), Optional.of(dstPort), null, endPointType, OpticalLogicId.logicId((long)0L), true, new Annotations[0]);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("SLA", String.valueOf(pcepTunnel.getSla())).set("bandwidth", String.valueOf(pcepTunnel.bandWidth()) + BANDWIDTH_UINT).set("index", String.valueOf(pcepTunnel.id())).build();
        if (pcepTunnel.underlayTunnelId() != 0L) {
            DefaultAnnotations extendAnnotations = DefaultAnnotations.builder().set("underLayTunnelIndex", String.valueOf(pcepTunnel.underlayTunnelId())).build();
            annotations = DefaultAnnotations.merge((DefaultAnnotations)annotations, (SparseAnnotations)extendAnnotations);
        }
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription(tunnelId, (TunnelEndPoint)srcPoint, (TunnelEndPoint)dstPoint, tunnelType, new DefaultGroupId(0), this.id(), name, path, new SparseAnnotations[]{annotations});
        return tunnel;
    }

    private TunnelId getTunnelId(String tunnelKey) {
        for (String key : this.tunnelMap.keySet()) {
            if (!key.equals(tunnelKey)) continue;
            return this.tunnelMap.get(key);
        }
        return null;
    }

    private String getPcepTunnelKey(TunnelId tunnelId) {
        for (String key : this.tunnelMap.keySet()) {
            if (!Objects.equals(this.tunnelMap.get(key).id(), tunnelId.id())) continue;
            return key;
        }
        return null;
    }

    private TunnelStatistics buildTunnelStatistics(PcepTunnelStatistics statistics) {
        DefaultTunnelStatistics.Builder builder = new DefaultTunnelStatistics.Builder();
        DefaultTunnelStatistics tunnelStatistics = builder.setBwUtilization(statistics.bandwidthUtilization()).setPacketLossRatio(statistics.packetLossRate()).setFlowDelay(statistics.flowDelay()).setAlarms(statistics.alarms()).build();
        return tunnelStatistics;
    }

    private LinkedList<PcepValueType> createPcepPath(Path path) {
        LinkedList<PcepValueType> llSubObjects = new LinkedList<PcepValueType>();
        List listLink = path.links();
        ConnectPoint source = null;
        ConnectPoint destination = null;
        Ip4Address ipDstAddress = null;
        Ip4Address ipSrcAddress = null;
        IPv4SubObject subObj = null;
        for (Link link : listLink) {
            long portNo;
            source = link.src();
            if (!source.equals(destination)) {
                portNo = source.port().toLong();
                portNo = (portNo & 0x100000000L) == 0x100000000L ? portNo & 0xFFFFFFFFL : portNo;
                ipSrcAddress = Ip4Address.valueOf((int)((int)portNo));
                subObj = new IPv4SubObject(ipSrcAddress.getIp4Address().toInt());
                llSubObjects.add((PcepValueType)subObj);
            }
            portNo = ((portNo = (destination = link.dst()).port().toLong()) & 0x100000000L) == 0x100000000L ? portNo & 0xFFFFFFFFL : portNo;
            ipDstAddress = Ip4Address.valueOf((int)((int)portNo));
            subObj = new IPv4SubObject(ipDstAddress.getIp4Address().toInt());
            llSubObjects.add((PcepValueType)subObj);
        }
        return llSubObjects;
    }

    LinkedList<PcInitiatedLspRequest> createPcInitiatedLspReqList(Tunnel tunnel, Path path, PcepClient pc, int srpId) throws PcepParseException {
        String localLspIdString;
        LinkedList llSubObjects = null;
        LspType lspType = LspType.valueOf((String)tunnel.annotations().value("lspSigType"));
        if (lspType == LspType.SR_WITHOUT_SIGNALLING) {
            NetworkResource labelStack = tunnel.resource();
            if (!(labelStack != null && labelStack instanceof DefaultLabelStack || (labelStack = this.pcepClientController.computeLabelStack(tunnel.path())) != null)) {
                log.error("Unable to create label stack.");
                return null;
            }
            llSubObjects = this.pcepClientController.createPcepLabelStack((DefaultLabelStack)labelStack, path);
        } else {
            llSubObjects = this.createPcepPath(path);
        }
        if (llSubObjects == null || llSubObjects.size() == 0) {
            log.error("There is no link information to create tunnel");
            return null;
        }
        LinkedList<PathSetupTypeTlv> llOptionalTlv = new LinkedList<PathSetupTypeTlv>();
        PathSetupTypeTlv tlv = new PathSetupTypeTlv(lspType.type());
        llOptionalTlv.add(tlv);
        PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(false).setOptionalTlv(llOptionalTlv).build();
        llOptionalTlv = new LinkedList();
        LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = new LinkedList<PcInitiatedLspRequest>();
        short localLspId = 0;
        if (LspType.valueOf((String)tunnel.annotations().value("lspSigType")) != LspType.WITH_SIGNALLING && (localLspIdString = tunnel.annotations().value("localLspId")) != null) {
            localLspId = Short.valueOf(localLspIdString);
        }
        tunnel.annotations().value("lspSigType");
        tlv = new StatefulIPv4LspIdentifiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), localLspId, 0, 0, ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
        llOptionalTlv.add(tlv);
        tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
        llOptionalTlv.add(tlv);
        PcepLspObject lspobj = pc.factory().buildLspObject().setAFlag(true).setDFlag(true).setOFlag((byte)0).setPlspId(0).setOptionalTlv(llOptionalTlv).build();
        PcepEndPointsObject endpointsobj = pc.factory().buildEndPointsObject().setSourceIpAddress(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt()).setDestIpAddress(((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt()).setPFlag(true).build();
        PcepEroObject eroobj = pc.factory().buildEroObject().setSubObjects(llSubObjects).build();
        float iBandwidth = 10.0f;
        if (tunnel.annotations().value("bandwidth") != null) {
            iBandwidth = Float.valueOf(tunnel.annotations().value("bandwidth")).floatValue();
        }
        PcepBandwidthObject bandwidthObject = pc.factory().buildBandwidthObject().setBandwidth(iBandwidth).build();
        PcepAttribute pcepAttribute = pc.factory().buildPcepAttribute().setBandwidthObject(bandwidthObject).build();
        PcInitiatedLspRequest initiateLspRequest = pc.factory().buildPcInitiatedLspRequest().setSrpObject(srpobj).setLspObject(lspobj).setEndPointsObject(endpointsobj).setEroObject(eroobj).setPcepAttribute(pcepAttribute).build();
        llPcInitiatedLspRequestList.add(initiateLspRequest);
        return llPcInitiatedLspRequestList;
    }

    private void pcepSetupTunnel(Tunnel tunnel, Path path, PcepClient pc) {
        try {
            if (!pc.lspDbSyncStatus().equals((Object)PcepSyncStatus.SYNCED)) {
                log.error("Setup tunnel has failed as LSP DB sync is not finished");
                return;
            }
            int srpId = SrpIdGenerators.create();
            Collection tunnels = this.tunnelService.queryTunnel(tunnel.src(), tunnel.dst());
            for (Tunnel t : tunnels) {
                if (!t.tunnelName().equals((Object)tunnel.tunnelName())) continue;
                tunnel = new DefaultTunnel(tunnel.providerId(), tunnel.src(), tunnel.dst(), tunnel.type(), t.state(), tunnel.groupId(), t.tunnelId(), tunnel.tunnelName(), tunnel.path(), tunnel.resource(), new Annotations[]{tunnel.annotations()});
                break;
            }
            if (tunnel.tunnelId() == null) {
                log.error("Tunnel ID not found");
                return;
            }
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, path, RequestType.CREATE);
            this.pcepTunnelApiMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = this.createPcInitiatedLspReqList(tunnel, path, pc, srpId);
            if (llPcInitiatedLspRequestList == null || llPcInitiatedLspRequestList.size() == 0) {
                log.error("Failed to create PcInitiatedLspRequestList");
                return;
            }
            PcepInitiateMsg pcInitiateMsg = pc.factory().buildPcepInitiateMsg().setPcInitiatedLspRequestList(llPcInitiatedLspRequestList).build();
            pc.sendMessage(Collections.singletonList(pcInitiateMsg));
            this.pcepTunnelApiMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing setup tunnel {}", (Object)e.getMessage());
        }
    }

    private void pcepReleaseTunnel(Tunnel tunnel, PcepClient pc) {
        try {
            if (!pc.lspDbSyncStatus().equals((Object)PcepSyncStatus.SYNCED)) {
                log.error("Release tunnel has failed as LSP DB sync is not finished");
                return;
            }
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, RequestType.DELETE);
            this.pcepTunnelApiMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            int srpId = SrpIdGenerators.create();
            LinkedList<PathSetupTypeTlv> llOptionalTlv = new LinkedList<PathSetupTypeTlv>();
            PathSetupTypeTlv tlv = new PathSetupTypeTlv(LspType.valueOf((String)tunnel.annotations().value("lspSigType")).type());
            llOptionalTlv.add(tlv);
            PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(true).setOptionalTlv(llOptionalTlv).build();
            llOptionalTlv = new LinkedList();
            LinkedList<PcInitiatedLspRequest> llPcInitiatedLspRequestList = new LinkedList<PcInitiatedLspRequest>();
            tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
            llOptionalTlv.add(tlv);
            String localLspIdString = tunnel.annotations().value("localLspId");
            String pccTunnelIdString = tunnel.annotations().value("PccTunnelId");
            String pLspIdString = tunnel.annotations().value("PLspId");
            short localLspId = 0;
            short pccTunnelId = 0;
            int plspId = 0;
            if (localLspIdString != null) {
                localLspId = Short.valueOf(localLspIdString);
            }
            if (pccTunnelIdString != null) {
                pccTunnelId = Short.valueOf(pccTunnelIdString);
            }
            if (pLspIdString != null) {
                plspId = Integer.valueOf(pLspIdString);
            }
            tlv = new StatefulIPv4LspIdentifiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), localLspId, pccTunnelId, 0, ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
            llOptionalTlv.add(tlv);
            PcepLspObject lspobj = pc.factory().buildLspObject().setRFlag(false).setPlspId(plspId).setOptionalTlv(llOptionalTlv).build();
            PcInitiatedLspRequest releaseLspRequest = pc.factory().buildPcInitiatedLspRequest().setSrpObject(srpobj).setLspObject(lspobj).build();
            llPcInitiatedLspRequestList.add(releaseLspRequest);
            PcepInitiateMsg pcInitiateMsg = pc.factory().buildPcepInitiateMsg().setPcInitiatedLspRequestList(llPcInitiatedLspRequestList).build();
            pc.sendMessage(Collections.singletonList(pcInitiateMsg));
            this.pcepTunnelApiMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing release tunnel {}", (Object)e.getMessage());
        }
    }

    private void pcepUpdateTunnel(Tunnel tunnel, Path path, PcepClient pc) {
        try {
            PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, path, RequestType.UPDATE);
            this.pcepTunnelApiMapper.addToCoreTunnelRequestQueue(pcepTunnelData);
            int srpId = SrpIdGenerators.create();
            LinkedList llSubObjects = null;
            LspType lspSigType = LspType.valueOf((String)tunnel.annotations().value("lspSigType"));
            if (lspSigType == LspType.SR_WITHOUT_SIGNALLING) {
                NetworkResource labelStack = tunnel.resource();
                if (!(labelStack != null && labelStack instanceof DefaultLabelStack || (labelStack = this.pcepClientController.computeLabelStack(tunnel.path())) != null)) {
                    log.error("Unable to create label stack.");
                    return;
                }
                llSubObjects = this.pcepClientController.createPcepLabelStack((DefaultLabelStack)labelStack, path);
            } else {
                llSubObjects = this.createPcepPath(path);
            }
            LinkedList<PathSetupTypeTlv> llOptionalTlv = new LinkedList<PathSetupTypeTlv>();
            LinkedList<PcepUpdateRequest> llUpdateRequestList = new LinkedList<PcepUpdateRequest>();
            PathSetupTypeTlv tlv = new PathSetupTypeTlv(lspSigType.type());
            llOptionalTlv.add(tlv);
            PcepSrpObject srpobj = pc.factory().buildSrpObject().setSrpID(srpId).setRFlag(false).setOptionalTlv(llOptionalTlv).build();
            llOptionalTlv = new LinkedList();
            if (lspSigType != LspType.WITH_SIGNALLING) {
                String localLspIdString = tunnel.annotations().value("localLspId");
                String pccTunnelIdString = tunnel.annotations().value("PccTunnelId");
                short localLspId = 0;
                short pccTunnelId = 0;
                if (localLspIdString != null) {
                    localLspId = Short.valueOf(localLspIdString);
                }
                if (pccTunnelIdString != null) {
                    pccTunnelId = Short.valueOf(pccTunnelIdString);
                }
                tlv = new StatefulIPv4LspIdentifiersTlv(((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), localLspId, pccTunnelId, ((IpTunnelEndPoint)tunnel.src()).ip().getIp4Address().toInt(), ((IpTunnelEndPoint)tunnel.dst()).ip().getIp4Address().toInt());
                llOptionalTlv.add(tlv);
            }
            if (tunnel.tunnelName().value() != null) {
                tlv = new SymbolicPathNameTlv(tunnel.tunnelName().value().getBytes());
                llOptionalTlv.add(tlv);
            }
            boolean delegated = tunnel.annotations().value("delegate") == null ? false : Boolean.valueOf(tunnel.annotations().value("delegate"));
            boolean initiated = tunnel.annotations().value("pceInit") == null ? false : Boolean.valueOf(tunnel.annotations().value("pceInit"));
            PcepLspObject lspobj = pc.factory().buildLspObject().setAFlag(true).setPlspId(Integer.valueOf(tunnel.annotations().value("PLspId")).intValue()).setDFlag(delegated).setCFlag(initiated).setOptionalTlv(llOptionalTlv).build();
            PcepEroObject eroobj = pc.factory().buildEroObject().setSubObjects(llSubObjects).build();
            float iBandwidth = 10.0f;
            if (tunnel.annotations().value("bandwidth") != null) {
                iBandwidth = Float.parseFloat(tunnel.annotations().value("bandwidth"));
            }
            PcepBandwidthObject bandwidthObject = pc.factory().buildBandwidthObject().setBandwidth(iBandwidth).build();
            PcepAttribute pcepAttribute = pc.factory().buildPcepAttribute().setBandwidthObject(bandwidthObject).build();
            PcepMsgPath msgPath = pc.factory().buildPcepMsgPath().setEroObject(eroobj).setPcepAttribute(pcepAttribute).build();
            PcepUpdateRequest updateRequest = pc.factory().buildPcepUpdateRequest().setSrpObject(srpobj).setLspObject(lspobj).setMsgPath(msgPath).build();
            llUpdateRequestList.add(updateRequest);
            PcepUpdateMsg pcUpdateMsg = pc.factory().buildUpdateMsg().setUpdateRequestList(llUpdateRequestList).build();
            pc.sendMessage(Collections.singletonList(pcUpdateMsg));
            this.pcepTunnelApiMapper.addToTunnelRequestQueue(srpId, pcepTunnelData);
        }
        catch (PcepParseException e) {
            log.error("PcepParseException occurred while processing release tunnel {}", (Object)e.getMessage());
        }
    }

    public Tunnel tunnelQueryById(TunnelId tunnelId) {
        return this.service.tunnelQueryById(tunnelId);
    }

    private DeviceId getDevice(PccId pccId) {
        IpAddress lsrId = pccId.ipAddress();
        String lsrIdentifier = String.valueOf(lsrId);
        Iterable devices = this.deviceService.getAvailableDevices();
        for (Device dev : devices) {
            if (!dev.annotations().value("type").equals("L3") || !dev.annotations().value(LSRID).equals(lsrIdentifier)) continue;
            return dev.id();
        }
        return null;
    }

    protected void bindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        this.tunnelProviderRegistry = tunnelProviderRegistry;
    }

    protected void unbindTunnelProviderRegistry(TunnelProviderRegistry tunnelProviderRegistry) {
        if (this.tunnelProviderRegistry == tunnelProviderRegistry) {
            this.tunnelProviderRegistry = null;
        }
    }

    protected void bindController(PcepController pcepController) {
        this.controller = pcepController;
    }

    protected void unbindController(PcepController pcepController) {
        if (this.controller == pcepController) {
            this.controller = null;
        }
    }

    protected void bindPcepClientController(PcepClientController pcepClientController) {
        this.pcepClientController = pcepClientController;
    }

    protected void unbindPcepClientController(PcepClientController pcepClientController) {
        if (this.pcepClientController == pcepClientController) {
            this.pcepClientController = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindTunnelAdminService(TunnelAdminService tunnelAdminService) {
        this.tunnelAdminService = tunnelAdminService;
    }

    protected void unbindTunnelAdminService(TunnelAdminService tunnelAdminService) {
        if (this.tunnelAdminService == tunnelAdminService) {
            this.tunnelAdminService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    private class UpdateDelegation
    implements Runnable {
        DefaultTunnelDescription td;
        ProviderId providerId;
        SparseAnnotations annotations;
        PccId pccId;
        ScheduledExecutorService executor;
        Tunnel.State tunnelState;
        StatefulIPv4LspIdentifiersTlv ipv4LspIdentifiersTlv;

        public UpdateDelegation(DefaultTunnelDescription td, ProviderId providerId, SparseAnnotations annotations, PccId pccId, ScheduledExecutorService executor, Tunnel.State tunnelState, StatefulIPv4LspIdentifiersTlv ipv4LspIdentifiersTlv) {
            this.td = td;
            this.providerId = providerId;
            this.annotations = annotations;
            this.pccId = pccId;
            this.executor = executor;
            this.tunnelState = tunnelState;
            this.ipv4LspIdentifiersTlv = ipv4LspIdentifiersTlv;
        }

        @Override
        public void run() {
            Collection tunnelQueryResult = PcepTunnelProvider.this.tunnelService.queryTunnel(this.td.src(), this.td.dst());
            TunnelId tempTunnelId = null;
            for (Tunnel t : tunnelQueryResult) {
                if (t.annotations().value("localLspId") == null || t.annotations().value("PLspId") == null || !t.annotations().value("localLspId").equals(this.td.annotations().value("localLspId")) || !t.annotations().value("PLspId").equals(this.td.annotations().value("PLspId")) || !((IpTunnelEndPoint)t.src()).ip().equals(this.pccId.id())) continue;
                tempTunnelId = t.tunnelId();
                break;
            }
            if (tempTunnelId != null) {
                DefaultTunnel tunnel = new DefaultTunnel(this.providerId, this.td.src(), this.td.dst(), Tunnel.Type.MPLS, new DefaultGroupId(0), tempTunnelId, this.td.tunnelName(), this.td.path(), new Annotations[]{this.annotations});
                PcepTunnelData pcepTunnelData = new PcepTunnelData((Tunnel)tunnel, tunnel.path(), RequestType.LSP_STATE_RPT);
                pcepTunnelData.setStatefulIpv4IndentifierTlv(this.ipv4LspIdentifiersTlv);
                pcepTunnelData.setLspDFlag(Boolean.valueOf(tunnel.annotations().value("delegate")));
                PcepTunnelProvider.this.pcepTunnelApiMapper.addToTunnelIdMap(pcepTunnelData);
                PcepTunnelProvider.this.tunnelUpdated((Tunnel)tunnel, this.td.path(), this.tunnelState);
                this.executor.shutdown();
                try {
                    this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error("updating delegation failed");
                }
            }
        }
    }

    private class InnerTunnelProvider
    implements PcepTunnelListener,
    PcepEventListener,
    PcepClientListener {
        private InnerTunnelProvider() {
        }

        public void handlePcepTunnel(PcepTunnel pcepTunnel) {
            TunnelDescription tunnel = null;
            String tunnelKey = String.valueOf(pcepTunnel.getInstance()) + String.valueOf(pcepTunnel.id());
            if (tunnelKey == null || "".equals(tunnelKey)) {
                log.error("Invalid PCEP tunnel");
                return;
            }
            TunnelId tunnelId = PcepTunnelProvider.this.getTunnelId(tunnelKey);
            tunnel = PcepTunnelProvider.this.buildOpticalTunnel(pcepTunnel, tunnelId);
            PcepOperator.OperationType operType = pcepTunnel.getOperationType();
            switch (operType) {
                case ADD: {
                    tunnelId = PcepTunnelProvider.this.service.tunnelAdded(tunnel);
                    PcepTunnelProvider.this.tunnelMap.put(tunnelKey, tunnelId);
                    break;
                }
                case UPDATE: {
                    PcepTunnelProvider.this.service.tunnelUpdated(tunnel);
                    break;
                }
                case DELETE: {
                    PcepTunnelProvider.this.service.tunnelRemoved(tunnel);
                    PcepTunnelProvider.this.tunnelMap.remove(tunnelKey);
                    break;
                }
                default: {
                    log.error("Invalid tunnel operation");
                }
            }
        }

        public void handleMessage(PccId pccId, PcepMessage msg) {
            try {
                log.debug("tunnel provider handle message {}", (Object)msg.getType().toString());
                switch (msg.getType()) {
                    case REPORT: {
                        int srpId = 0;
                        LinkedList llStateReportList = null;
                        llStateReportList = ((PcepReportMsg)msg).getStateReportList();
                        ListIterator listIterator = llStateReportList.listIterator();
                        PcepSrpObject srpObj = null;
                        PcepLspObject lspObj = null;
                        while (listIterator.hasNext()) {
                            PcepStateReport stateRpt = (PcepStateReport)listIterator.next();
                            srpObj = stateRpt.getSrpObject();
                            lspObj = stateRpt.getLspObject();
                            if (srpObj instanceof PcepSrpObject) {
                                srpId = srpObj.getSrpID();
                            }
                            log.debug("Plsp ID in handle message " + lspObj.getPlspId());
                            log.debug("SRP ID in handle message " + srpId);
                            if (!PcepTunnelProvider.this.pcepTunnelApiMapper.checkFromTunnelRequestQueue(srpId)) {
                                this.handleRptWithoutSrpId(stateRpt, pccId);
                                continue;
                            }
                            this.handleReportMessage(srpId, lspObj, stateRpt);
                        }
                        break;
                    }
                    default: {
                        log.debug("Received unsupported message type {}", (Object)msg.getType().toString());
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.error("Exception occured while processing report message {}", (Object)e.getMessage());
            }
        }

        private void handleReportMessage(int srpId, PcepLspObject lspObj, PcepStateReport stateRpt) {
            ProviderId providerId = new ProviderId("pcep", PcepTunnelProvider.PROVIDER_ID);
            PcepTunnelData pcepTunnelData = PcepTunnelProvider.this.pcepTunnelApiMapper.getDataFromTunnelRequestQueue(srpId);
            pcepTunnelData.setPlspId(lspObj.getPlspId());
            pcepTunnelData.setLspAFlag(lspObj.getAFlag());
            pcepTunnelData.setLspOFlag(lspObj.getOFlag());
            pcepTunnelData.setLspDFlag(lspObj.getDFlag());
            StatefulIPv4LspIdentifiersTlv ipv4LspTlv = null;
            ListIterator listTlvIterator = lspObj.getOptionalTlv().listIterator();
            while (listTlvIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listTlvIterator.next();
                if (tlv.getType() != 18) continue;
                ipv4LspTlv = (StatefulIPv4LspIdentifiersTlv)tlv;
                break;
            }
            if (ipv4LspTlv != null) {
                pcepTunnelData.setStatefulIpv4IndentifierTlv(ipv4LspTlv);
            }
            Path path = pcepTunnelData.path();
            Tunnel tunnel = pcepTunnelData.tunnel();
            DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
            annotationBuilder.putAll(pcepTunnelData.tunnel().annotations());
            if (tunnel.annotations().value("PLspId") == null) {
                annotationBuilder.set("PLspId", String.valueOf(lspObj.getPlspId()));
            }
            if (tunnel.annotations().value("localLspId") == null) {
                annotationBuilder.set("localLspId", String.valueOf(ipv4LspTlv.getLspId()));
            }
            if (tunnel.annotations().value("PccTunnelId") == null) {
                annotationBuilder.set("PccTunnelId", String.valueOf(ipv4LspTlv.getTunnelId()));
            }
            DefaultAnnotations annotations = annotationBuilder.build();
            DefaultTunnelDescription td = new DefaultTunnelDescription(tunnel.tunnelId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), providerId, tunnel.tunnelName(), path, tunnel.resource(), new SparseAnnotations[]{annotations});
            if (RequestType.CREATE == pcepTunnelData.requestType()) {
                PcepTunnelProvider.this.pcepTunnelApiMapper.addToTunnelIdMap(pcepTunnelData);
                PcepTunnelProvider.this.pcepTunnelApiMapper.handleCreateTunnelRequestQueue(srpId, pcepTunnelData);
            } else if (RequestType.DELETE == pcepTunnelData.requestType()) {
                PcepTunnelProvider.this.pcepTunnelApiMapper.handleRemoveFromTunnelRequestQueue(srpId, pcepTunnelData);
            } else if (RequestType.UPDATE == pcepTunnelData.requestType()) {
                pcepTunnelData.setRptFlag(true);
                PcepTunnelProvider.this.pcepTunnelApiMapper.addToTunnelIdMap(pcepTunnelData);
                PcepTunnelProvider.this.pcepTunnelApiMapper.handleUpdateTunnelRequestQueue(srpId, pcepTunnelData);
            }
            PcepLspStatus pcepLspStatus = PcepLspStatus.values()[lspObj.getOFlag()];
            if (lspObj.getRFlag()) {
                PcepTunnelProvider.this.tunnelRemoved((TunnelDescription)td);
            } else {
                Tunnel.State tunnelState = PcepLspStatus.getTunnelStatusFromLspStatus((PcepLspStatus)pcepLspStatus);
                PcepTunnelProvider.this.tunnelUpdated((TunnelDescription)td, tunnelState);
            }
            if (pcepLspStatus == PcepLspStatus.GOING_UP && LspType.valueOf((String)tunnel.annotations().value("lspSigType")) == LspType.SR_WITHOUT_SIGNALLING) {
                PcepTunnelProvider.this.updateTunnel(PcepTunnelProvider.this.service.tunnelQueryById(tunnel.tunnelId()), tunnel.path());
            }
        }

        private SparseAnnotations getAnnotations(PcepLspObject lspObj, StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv, String bandwidth, LspType lspType, String costType, boolean isPceInit) {
            DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
            if (costType != null) {
                builder.set("costType", costType);
            }
            if (isPceInit) {
                builder.set("pceInit", String.valueOf(isPceInit));
            }
            if (bandwidth != null) {
                builder.set("bandwidth", bandwidth);
            }
            DefaultAnnotations annotations = builder.set("lspSigType", lspType.name()).set("PccTunnelId", String.valueOf(ipv4LspIdenTlv.getTunnelId())).set("PLspId", String.valueOf(lspObj.getPlspId())).set("localLspId", String.valueOf(ipv4LspIdenTlv.getLspId())).set("delegate", String.valueOf(lspObj.getDFlag())).build();
            return annotations;
        }

        private LspType getLspType(PcepSrpObject srpObj) {
            LspType lspType = LspType.WITH_SIGNALLING;
            if (null != srpObj) {
                LinkedList llOptionalTlv = srpObj.getOptionalTlv();
                ListIterator listIterator = llOptionalTlv.listIterator();
                while (listIterator.hasNext()) {
                    PcepValueType tlv = (PcepValueType)listIterator.next();
                    switch (tlv.getType()) {
                        case 28: {
                            lspType = LspType.values()[Integer.valueOf(((PathSetupTypeTlv)tlv).getPst())];
                            break;
                        }
                    }
                }
            }
            return lspType;
        }

        private void handleRptWithoutSrpId(PcepStateReport stateRpt, PccId pccId) {
            ProviderId providerId = new ProviderId("pcep", PcepTunnelProvider.PROVIDER_ID);
            String costType = null;
            PcepStateReport.PcepMsgPath msgPath = stateRpt.getMsgPath();
            Preconditions.checkNotNull((Object)msgPath);
            PcepEroObject eroObj = msgPath.getEroObject();
            if (eroObj == null) {
                log.error("ERO object is null in report message.");
                return;
            }
            PcepAttribute attributes = msgPath.getPcepAttribute();
            float bandwidth = 0.0f;
            int cost = 0;
            if (attributes != null) {
                if (attributes.getMetricObjectList() != null) {
                    ListIterator iterator = attributes.getMetricObjectList().listIterator();
                    PcepMetricObject metricObj = (PcepMetricObject)iterator.next();
                    while (metricObj != null) {
                        if (metricObj.getBType() == 1) {
                            costType = "COST";
                        } else if (metricObj.getBType() == 2) {
                            costType = "TE_COST";
                        }
                        if (costType != null) {
                            cost = metricObj.getMetricVal();
                            log.debug("Path cost {}", (Object)cost);
                            break;
                        }
                        metricObj = (PcepMetricObject)iterator.next();
                    }
                }
                if (attributes.getBandwidthObject() != null) {
                    bandwidth = attributes.getBandwidthObject().getBandwidth();
                }
            }
            PcepLspObject lspObj = stateRpt.getLspObject();
            List<Object> eroSubObjList = this.buildPathFromEroObj(eroObj, providerId);
            ArrayList<Link> links = new ArrayList<Link>();
            ArrayList<LabelResourceId> labels = new ArrayList<LabelResourceId>();
            for (Object linkOrLabel : eroSubObjList) {
                if (linkOrLabel instanceof Link) {
                    links.add((Link)linkOrLabel);
                    continue;
                }
                if (!(linkOrLabel instanceof Integer)) continue;
                labels.add(LabelResourceId.labelResourceId((long)((Integer)linkOrLabel).longValue()));
            }
            DefaultPath path = null;
            if (!links.isEmpty()) {
                path = new DefaultPath(providerId, links, (double)cost, new Annotations[]{DefaultAnnotations.EMPTY});
            } else if (!lspObj.getRFlag()) {
                return;
            }
            DefaultLabelStack labelStack = new DefaultLabelStack(labels);
            PcepSrpObject srpObj = stateRpt.getSrpObject();
            LspType lspType = this.getLspType(srpObj);
            ListIterator listTlvIterator = lspObj.getOptionalTlv().listIterator();
            StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv = null;
            SymbolicPathNameTlv pathNameTlv = null;
            while (listTlvIterator.hasNext()) {
                PcepValueType tlv = (PcepValueType)listTlvIterator.next();
                switch (tlv.getType()) {
                    case 18: {
                        ipv4LspIdenTlv = (StatefulIPv4LspIdentifiersTlv)tlv;
                        break;
                    }
                    case 17: {
                        pathNameTlv = (SymbolicPathNameTlv)tlv;
                        break;
                    }
                }
            }
            if (ipv4LspIdenTlv == null) {
                log.error("Stateful IPv4 identifier TLV is null in PCRpt msg.");
                return;
            }
            IpTunnelEndPoint tunnelEndPointSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)ipv4LspIdenTlv.getIpv4IngressAddress()));
            IpTunnelEndPoint tunnelEndPointDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((int)ipv4LspIdenTlv.getIpv4EgressAddress()));
            Collection tunnelQueryResult = PcepTunnelProvider.this.tunnelService.queryTunnel((TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst);
            if (lspObj.getDFlag()) {
                PcepTunnelProvider.this.pcepClientController.getClient(pccId).setLspAndDelegationInfo(new LspKey(lspObj.getPlspId(), ipv4LspIdenTlv.getLspId()), lspObj.getDFlag());
            }
            Tunnel tunnel = null;
            SparseAnnotations oldTunnelAnnotations = null;
            for (Tunnel tunnelObj : tunnelQueryResult) {
                if (tunnelObj.annotations().value("PLspId") == null) {
                    if (pathNameTlv == null || !Arrays.equals(tunnelObj.tunnelName().value().getBytes(), pathNameTlv.getValue())) continue;
                    tunnel = tunnelObj;
                    break;
                }
                if (Integer.valueOf(tunnelObj.annotations().value("PLspId")).intValue() != lspObj.getPlspId()) continue;
                if (Integer.valueOf(tunnelObj.annotations().value("localLspId")).intValue() == ipv4LspIdenTlv.getLspId()) {
                    tunnel = tunnelObj;
                }
                if (Integer.valueOf(tunnelObj.annotations().value("localLspId")).intValue() == ipv4LspIdenTlv.getLspId()) continue;
                oldTunnelAnnotations = (SparseAnnotations)tunnelObj.annotations();
            }
            SparseAnnotations annotations = null;
            Tunnel.State tunnelState = PcepLspStatus.getTunnelStatusFromLspStatus((PcepLspStatus)PcepLspStatus.values()[lspObj.getOFlag()]);
            if (tunnel == null) {
                if (lspObj.getRFlag()) {
                    return;
                }
                DeviceId deviceId = PcepTunnelProvider.this.getDevice(pccId);
                if (deviceId == null) {
                    log.error("Ingress deviceId not found");
                    return;
                }
                String tempBandwidth = null;
                String temoCostType = null;
                if (oldTunnelAnnotations != null) {
                    tempBandwidth = oldTunnelAnnotations.value("bandwidth");
                    temoCostType = oldTunnelAnnotations.value("costType");
                }
                annotations = this.getAnnotations(lspObj, ipv4LspIdenTlv, tempBandwidth, lspType, temoCostType, lspObj.getCFlag());
                DefaultTunnelDescription td = new DefaultTunnelDescription(null, (TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst, Tunnel.Type.MPLS, new DefaultGroupId(0), providerId, TunnelName.tunnelName((String)new String(pathNameTlv.getValue())), (Path)path, (NetworkResource)labelStack, new SparseAnnotations[]{annotations});
                if (!lspObj.getSFlag() && !lspObj.getCFlag()) {
                    log.error("Received PCC initiated LSP while not in sync.");
                    return;
                }
                if (PcepTunnelProvider.this.mastershipService.isLocalMaster(deviceId)) {
                    TunnelId tId = PcepTunnelProvider.this.tunnelAdded((TunnelDescription)td, tunnelState);
                    DefaultTunnel tunnelInserted = new DefaultTunnel(providerId, (TunnelEndPoint)tunnelEndPointSrc, (TunnelEndPoint)tunnelEndPointDst, Tunnel.Type.MPLS, tunnelState, new DefaultGroupId(0), tId, TunnelName.tunnelName((String)String.valueOf(pathNameTlv.getValue())), (Path)path, (NetworkResource)labelStack, new Annotations[]{annotations});
                    PcepTunnelData pcepTunnelData = new PcepTunnelData((Tunnel)tunnelInserted, (Path)path, RequestType.LSP_STATE_RPT);
                    pcepTunnelData.setStatefulIpv4IndentifierTlv(ipv4LspIdenTlv);
                    PcepTunnelProvider.this.pcepTunnelApiMapper.addToTunnelIdMap(pcepTunnelData);
                } else if (!PcepTunnelProvider.this.mastershipService.isLocalMaster(deviceId) && lspObj.getDFlag()) {
                    this.tunnelUpdateInDelegatedCase(pccId, annotations, td, providerId, tunnelState, ipv4LspIdenTlv);
                }
                return;
            }
            if (lspObj.getDFlag() && !lspObj.getRFlag()) {
                this.tunnelUpdateForDelegatedLsp(tunnel, lspObj, lspType, tunnelState, pccId, (NetworkResource)labelStack, ipv4LspIdenTlv);
                return;
            }
            this.removeOrUpdatetunnel(tunnel, lspObj, providerId, tunnelState, ipv4LspIdenTlv);
        }

        private void tunnelUpdateForDelegatedLsp(Tunnel tunnel, PcepLspObject lspObj, LspType lspType, Tunnel.State tunnelState, PccId pccId, NetworkResource labelStack, StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv) {
            SparseAnnotations annotations = null;
            boolean isPceInit = tunnel.annotations().value("pceInit") == null ? false : Boolean.valueOf(tunnel.annotations().value("pceInit"));
            annotations = this.getAnnotations(lspObj, ipv4LspIdenTlv, tunnel.annotations().value("bandwidth"), lspType, tunnel.annotations().value("costType"), isPceInit);
            DefaultTunnelDescription td = new DefaultTunnelDescription(null, tunnel.src(), tunnel.dst(), Tunnel.Type.MPLS, new DefaultGroupId(0), tunnel.providerId(), tunnel.tunnelName(), tunnel.path(), labelStack, new SparseAnnotations[]{annotations});
            this.tunnelUpdateInDelegatedCase(pccId, annotations, td, tunnel.providerId(), tunnelState, ipv4LspIdenTlv);
        }

        private void removeOrUpdatetunnel(Tunnel tunnel, PcepLspObject lspObj, ProviderId providerId, Tunnel.State tunnelState, StatefulIPv4LspIdentifiersTlv ipv4LspIdenTlv) {
            DefaultTunnelDescription td = new DefaultTunnelDescription(tunnel.tunnelId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), providerId, tunnel.tunnelName(), tunnel.path(), new SparseAnnotations[]{(SparseAnnotations)tunnel.annotations()});
            if (lspObj.getRFlag()) {
                PcepTunnelProvider.this.tunnelRemoved((TunnelDescription)td);
            } else {
                PcepTunnelData pcepTunnelData = new PcepTunnelData(tunnel, tunnel.path(), RequestType.LSP_STATE_RPT);
                pcepTunnelData.setStatefulIpv4IndentifierTlv(ipv4LspIdenTlv);
                PcepTunnelProvider.this.pcepTunnelApiMapper.addToTunnelIdMap(pcepTunnelData);
                PcepTunnelProvider.this.tunnelUpdated((TunnelDescription)td, tunnelState);
            }
        }

        private void tunnelUpdateInDelegatedCase(PccId pccId, SparseAnnotations annotations, DefaultTunnelDescription td, ProviderId providerId, Tunnel.State tunnelState, StatefulIPv4LspIdentifiersTlv ipv4LspIdentifiersTlv) {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleAtFixedRate(new UpdateDelegation(td, providerId, annotations, pccId, executor, tunnelState, ipv4LspIdentifiersTlv), 2L, 2L, TimeUnit.SECONDS);
        }

        private List<Object> buildPathFromEroObj(PcepEroObject eroObj, ProviderId providerId) {
            Preconditions.checkNotNull((Object)eroObj);
            ArrayList<Object> subObjList = new ArrayList<Object>();
            LinkedList llSubObj = eroObj.getSubObjects();
            if (0 == llSubObj.size()) {
                log.error("ERO in report message does not have hop information");
                return new ArrayList<Object>();
            }
            ListIterator tlvIterator = llSubObj.listIterator();
            ConnectPoint src = null;
            ConnectPoint dst = null;
            boolean isSrcSet = false;
            block4: while (tlvIterator.hasNext()) {
                PcepValueType subObj = (PcepValueType)tlvIterator.next();
                block0 : switch (subObj.getType()) {
                    case 1: {
                        Iterable links;
                        IPv4SubObject ipv4SubObj = (IPv4SubObject)subObj;
                        if (!isSrcSet) {
                            links = PcepTunnelProvider.this.linkService.getActiveLinks();
                            for (Link l : links) {
                                if (l.src().port().equals((Object)PortNumber.portNumber((long)ipv4SubObj.getIpAddress()))) {
                                    src = l.src();
                                    isSrcSet = true;
                                    break block0;
                                }
                                if (!l.dst().port().equals((Object)PortNumber.portNumber((long)ipv4SubObj.getIpAddress()))) continue;
                                src = l.dst();
                                isSrcSet = true;
                                break block0;
                            }
                            continue block4;
                        }
                        links = PcepTunnelProvider.this.linkService.getActiveLinks();
                        for (Link l : links) {
                            if (l.src().port().equals((Object)PortNumber.portNumber((long)ipv4SubObj.getIpAddress()))) {
                                dst = l.src();
                                break;
                            }
                            if (!l.dst().port().equals((Object)PortNumber.portNumber((long)ipv4SubObj.getIpAddress()))) continue;
                            dst = l.dst();
                            break;
                        }
                        DefaultLink link = DefaultLink.builder().providerId(providerId).src(src).dst(dst).type(Link.Type.DIRECT).build();
                        subObjList.add(link);
                        src = dst;
                        break;
                    }
                    case 36: {
                        SrEroSubObject srEroSubObj = (SrEroSubObject)subObj;
                        subObjList.add(srEroSubObj.getSid());
                        if (srEroSubObj.getSt() != 3) break;
                        PcepNaiIpv4Adjacency nai = (PcepNaiIpv4Adjacency)srEroSubObj.getNai();
                        int srcIp = nai.getLocalIpv4Addr();
                        int dstIp = nai.getRemoteIpv4Addr();
                        Iterable links = PcepTunnelProvider.this.linkService.getActiveLinks();
                        for (Link l : links) {
                            long lSrc = l.src().port().toLong();
                            long lDst = l.dst().port().toLong();
                            if (lSrc == (long)srcIp) {
                                src = l.src();
                            } else if (lDst == (long)srcIp) {
                                src = l.dst();
                            }
                            if (lSrc == (long)dstIp) {
                                dst = l.src();
                            } else if (lDst == (long)dstIp) {
                                dst = l.dst();
                            }
                            if (src == null || dst == null) continue;
                            break;
                        }
                        if (src == null || dst == null) {
                            return new ArrayList<Object>();
                        }
                        DefaultLink link = DefaultLink.builder().providerId(providerId).src(src).dst(dst).type(Link.Type.DIRECT).build();
                        subObjList.add(link);
                    }
                }
            }
            return subObjList;
        }

        public void clientConnected(PccId pccId) {
        }

        public void clientDisconnected(PccId pccId) {
        }

        public void handlePcepTunnelStatistics(PcepTunnelStatistics pcepTunnelStatistics) {
            TunnelId id = PcepTunnelProvider.this.getTunnelId(String.valueOf(pcepTunnelStatistics.id()));
            TunnelStatistics tunnelStatistics = PcepTunnelProvider.this.buildTunnelStatistics(pcepTunnelStatistics);
            PcepTunnelProvider.this.tunnelStatisticsMap.put(id, tunnelStatistics);
        }

        public void handleEndOfSyncAction(Tunnel tunnel, PcepLspSyncAction endOfSyncAction) {
            if (endOfSyncAction == PcepLspSyncAction.SEND_UPDATE) {
                PcepTunnelProvider.this.updateTunnel(tunnel, tunnel.path());
                return;
            }
            DefaultTunnelDescription td = new DefaultTunnelDescription(tunnel.tunnelId(), tunnel.src(), tunnel.dst(), tunnel.type(), tunnel.groupId(), tunnel.providerId(), tunnel.tunnelName(), tunnel.path(), new SparseAnnotations[]{(SparseAnnotations)tunnel.annotations()});
            if (endOfSyncAction == PcepLspSyncAction.UNSTABLE) {
                PcepTunnelProvider.this.tunnelUpdated((TunnelDescription)td, Tunnel.State.UNSTABLE);
                PcepTunnelProvider.this.tunnelRemoved((TunnelDescription)td);
            } else if (endOfSyncAction == PcepLspSyncAction.REMOVE) {
                PcepTunnelProvider.this.tunnelRemoved((TunnelDescription)td);
            }
        }
    }
}

