/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.rest.device.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.config.Config;
import org.onosproject.protocol.rest.DefaultRestSBDevice;
import org.onosproject.protocol.rest.RestSBDevice;

@Beta
public class RestProviderConfig
extends Config<ApplicationId> {
    public static final String CONFIG_VALUE_ERROR = "Error parsing config value";
    private static final String IP = "ip";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final String PORT = "port";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PROTOCOL = "protocol";
    private static final String URL = "url";

    public Set<RestSBDevice> getDevicesAddresses() throws ConfigException {
        HashSet devicesAddresses = Sets.newHashSet();
        try {
            for (JsonNode node : this.array) {
                String ip = node.path(IP).asText();
                IpAddress ipAddr = ip.isEmpty() ? null : IpAddress.valueOf((String)ip);
                int port = node.path(PORT).asInt(80);
                String username = node.path(USERNAME).asText();
                String password = node.path(PASSWORD).asText();
                String protocol = node.path(PROTOCOL).asText();
                String url = node.path(URL).asText();
                devicesAddresses.add(new DefaultRestSBDevice(ipAddr, port, username, password, protocol, url, false));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(CONFIG_VALUE_ERROR, (Throwable)e);
        }
        return devicesAddresses;
    }
}

