/*
 * Copyright 2015-present Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.onosproject.incubator.net.tunnel;

import com.google.common.annotations.Beta;

import java.util.Objects;

/**
 * Represents for a unique tunnel name. TunnelId is generated by ONOS while
 * TunnelName is given by producer. The consumer can borrow tunnels with
 * TunnelId or TunnelName.
 */
@Beta
public final class TunnelName {
    private final String str;

    // Default constructor for serialization
    private TunnelName(String tunnelName) {
        this.str = tunnelName;
    }


    /**
     * Creates a tunnel name using the supplied URI string.
     *
     * @param tunnelName tunnel name string
     * @return tunnel name object
     */
    public static TunnelName tunnelName(String tunnelName) {
        return new TunnelName(tunnelName);
    }

    /**
     * The string of tunnel name.
     *
     * @return the string of tunnel name
     */
    public String value() {
        return str;
    }

    @Override
    public int hashCode() {
        return Objects.hash(str);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TunnelName) {
            final TunnelName that = (TunnelName) obj;
            return this.getClass() == that.getClass()
                    && Objects.equals(this.str, that.str);
        }
        return false;
    }

    @Override
    public String toString() {
        return str;
    }
}
