/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.device.impl;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.packet.IpAddress;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.event.Event;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderRegistryAdapter;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceProviderServiceAdapter;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreAdapter;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.snmp.device.impl.SnmpControllerAdapter;
import org.onosproject.provider.snmp.device.impl.SnmpDeviceProvider;
import org.onosproject.provider.snmp.device.impl.SnmpProviderConfig;
import org.onosproject.snmp.SnmpController;

public class SnmpDeviceProviderTest {
    private final SnmpDeviceProvider provider = new SnmpDeviceProvider();
    private final SnmpController controller = new SnmpControllerAdapter();
    private final DeviceProviderRegistry providerRegistry = new MockDeviceProviderRegistry();
    private final DeviceService deviceService = new MockDeviceService();
    private final NetworkConfigRegistry netCfgService = new MockNetworkConfigRegistry();
    private final DeviceStore deviceStore = new MockDeviceStore();
    protected CoreService coreService = new MockCoreService();
    private final DeviceProviderService deviceProviderService = new MockDeviceProviderService();
    private final TestApplicationId applicationId = new TestApplicationId("TestAppId");
    private final NetworkConfigEvent deviceAddedEvent = new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_ADDED, null, SnmpProviderConfig.class);
    private final SnmpProviderConfig snmpProviderConfig = new MockSnmpProviderConfig();
    private final NetworkConfigEvent deviceAddedIrrelevantEvent = new NetworkConfigEvent(NetworkConfigEvent.Type.CONFIG_ADDED, null, BasicDeviceConfig.class);
    private final DeviceId deviceId = DeviceId.deviceId((String)"snmp:1.1.1.1:1");
    private final DeviceId wrongDeviceId = DeviceId.deviceId((String)"snmp:2.2.2.2:2");
    private ConfigFactory cfgFactory;
    private Set<NetworkConfigListener> netCfgListeners = new HashSet<NetworkConfigListener>();

    @Before
    public void setUp() throws Exception {
        this.provider.controller = this.controller;
        this.provider.providerRegistry = this.providerRegistry;
        this.provider.deviceService = this.deviceService;
        this.provider.netCfgService = this.netCfgService;
        this.provider.deviceStore = this.deviceStore;
        this.provider.coreService = this.coreService;
        this.provider.activate(null);
    }

    @Test
    public void testActivate() {
        Assert.assertEquals((String)"Incorrect provider service", (Object)this.deviceProviderService, (Object)this.provider.providerService);
        Assert.assertEquals((String)"Incorrect application id", (Object)this.applicationId, (Object)this.provider.appId);
        Assert.assertEquals((String)"Incorrect config factory", (Object)this.cfgFactory, (Object)this.provider.factory);
        Assert.assertTrue((String)"Incorrect network config listener", (boolean)this.netCfgListeners.contains(this.provider.cfgLister));
    }

    @Test
    public void testDeactivate() {
        this.addDevice();
        this.provider.deactivate(null);
        TestTools.assertAfter((int)500, () -> Assert.assertNull((String)"Device should be removed", (Object)this.controller.getDevice(this.deviceId)));
        Assert.assertNull((String)"Network config factory not removed", (Object)this.cfgFactory);
        Assert.assertFalse((String)"Network config listener not removed", (boolean)this.netCfgListeners.contains(this.provider.cfgLister));
        Assert.assertFalse((String)"Provider not unregistered", (boolean)this.providerRegistry.getProviders().contains(this.provider.id()));
        Assert.assertNull((String)"Provider registry not removed", (Object)this.provider.providerService);
    }

    @Test
    public void eventNotRelevant() {
        Assert.assertFalse((String)"Event should not be relevant", (boolean)this.provider.cfgLister.isRelevant((Event)this.deviceAddedIrrelevantEvent));
        Assert.assertFalse((String)"Device should not be reachable", (boolean)this.provider.isReachable(this.wrongDeviceId));
    }

    @Test
    public void addDevice() {
        Assert.assertTrue((String)"Event should be relevant", (boolean)this.provider.cfgLister.isRelevant((Event)this.deviceAddedEvent));
        this.provider.cfgLister.event((Event)this.deviceAddedEvent);
        AbstractProjectableModel.setDriverService(null, (DriverService)new MockDriverService());
        TestTools.assertAfter((int)500, () -> Assert.assertNotNull((String)"Device should be added to controller", (Object)this.controller.getDevice(this.deviceId)));
        Assert.assertTrue((String)"Device should be reachable", (boolean)this.provider.isReachable(this.deviceId));
    }

    private class MockDriverService
    extends DriverServiceAdapter {
        private MockDriverService() {
        }
    }

    private class MockSnmpProviderConfig
    extends SnmpProviderConfig {
        protected SnmpProviderConfig.SnmpDeviceInfo deviceInfo = new SnmpProviderConfig.SnmpDeviceInfo((SnmpProviderConfig)this, IpAddress.valueOf((String)"1.1.1.1"), 1, "test", "test");

        private MockSnmpProviderConfig() {
        }

        public Set<SnmpProviderConfig.SnmpDeviceInfo> getDevicesInfo() throws ConfigException {
            return ImmutableSet.of((Object)this.deviceInfo);
        }
    }

    private class MockDeviceProviderService
    extends DeviceProviderServiceAdapter {
        DeviceStore store;

        private MockDeviceProviderService() {
            this.store = SnmpDeviceProviderTest.this.deviceStore;
        }

        public void deviceConnected(DeviceId deviceId, DeviceDescription desc) {
            this.store.createOrUpdateDevice(ProviderId.NONE, deviceId, desc);
        }
    }

    private class MockCoreService
    extends CoreServiceAdapter {
        private MockCoreService() {
        }

        public ApplicationId registerApplication(String name) {
            return SnmpDeviceProviderTest.this.applicationId;
        }
    }

    private class MockDeviceStore
    extends DeviceStoreAdapter {
        protected HashMap<DeviceId, Device> devices = new HashMap();

        private MockDeviceStore() {
        }

        public DeviceEvent createOrUpdateDevice(ProviderId providerId, DeviceId deviceId, DeviceDescription desc) {
            this.devices.put(deviceId, (Device)new DefaultDevice(providerId, deviceId, desc.type(), desc.manufacturer(), desc.hwVersion(), desc.swVersion(), desc.serialNumber(), desc.chassisId(), new Annotations[]{DefaultAnnotations.builder().build()}));
            return null;
        }

        public Device getDevice(DeviceId deviceId) {
            return this.devices.get(deviceId);
        }
    }

    private class MockNetworkConfigRegistry
    extends NetworkConfigRegistryAdapter {
        private MockNetworkConfigRegistry() {
        }

        public void registerConfigFactory(ConfigFactory configFactory) {
            SnmpDeviceProviderTest.this.cfgFactory = configFactory;
        }

        public void unregisterConfigFactory(ConfigFactory configFactory) {
            SnmpDeviceProviderTest.this.cfgFactory = null;
        }

        public void addListener(NetworkConfigListener listener) {
            SnmpDeviceProviderTest.this.netCfgListeners.add(listener);
        }

        public void removeListener(NetworkConfigListener listener) {
            SnmpDeviceProviderTest.this.netCfgListeners.remove(listener);
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass.equals(SnmpProviderConfig.class)) {
                return (C)SnmpDeviceProviderTest.this.snmpProviderConfig;
            }
            return (C)new BasicDeviceConfig();
        }
    }

    private class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            return SnmpDeviceProviderTest.this.deviceStore.getDevice(deviceId);
        }
    }

    private class MockDeviceProviderRegistry
    extends DeviceProviderRegistryAdapter {
        Set<ProviderId> providers = new HashSet<ProviderId>();

        private MockDeviceProviderRegistry() {
        }

        public DeviceProviderService register(DeviceProvider provider) {
            this.providers.add(provider.id());
            return SnmpDeviceProviderTest.this.deviceProviderService;
        }

        public void unregister(DeviceProvider provider) {
            this.providers.remove(provider.id());
        }

        public Set<ProviderId> getProviders() {
            return this.providers;
        }
    }
}

