/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.device.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.config.Config;

@Beta
public class SnmpProviderConfig
extends Config<ApplicationId> {
    public static final String CONFIG_VALUE_ERROR = "Error parsing config value";
    private static final String IP = "ip";
    private static final int DEFAULT_TCP_PORT = 830;
    private static final String PORT = "port";
    private static final String NAME = "username";
    private static final String PASSWORD = "password";

    public Set<SnmpDeviceInfo> getDevicesInfo() throws ConfigException {
        HashSet deviceInfos = Sets.newHashSet();
        try {
            for (JsonNode node : this.array) {
                String ip = node.path(IP).asText();
                IpAddress ipAddr = ip.isEmpty() ? null : IpAddress.valueOf((String)ip);
                int port = node.path(PORT).asInt(830);
                String name = node.path(NAME).asText();
                String password = node.path(PASSWORD).asText();
                deviceInfos.add(new SnmpDeviceInfo(ipAddr, port, name, password));
            }
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException(CONFIG_VALUE_ERROR, (Throwable)e);
        }
        return deviceInfos;
    }

    public class SnmpDeviceInfo {
        private final IpAddress ip;
        private final int port;
        private final String username;
        private final String password;

        public SnmpDeviceInfo(IpAddress ip, int port, String username, String password) {
            this.ip = ip;
            this.port = port;
            this.username = username;
            this.password = password;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }
    }
}

