/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.rest;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.protocol.rest.RestSBDevice;

public class DefaultRestSBDevice
implements RestSBDevice {
    private static final String REST = "rest";
    private static final String COLON = ":";
    private final IpAddress ip;
    private final int port;
    private final String username;
    private final String password;
    private boolean isActive;
    private String protocol;
    private String url;

    public DefaultRestSBDevice(IpAddress ip, int port, String name, String password, String protocol, String url, boolean isActive) {
        Preconditions.checkNotNull((Object)ip, (Object)"IP address cannot be null");
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port address cannot be negative");
        Preconditions.checkNotNull((Object)protocol, (Object)"protocol address cannot be null");
        this.ip = ip;
        this.port = port;
        this.username = name;
        this.password = StringUtils.isEmpty((CharSequence)password) ? null : password;
        this.isActive = isActive;
        this.protocol = protocol;
        this.url = StringUtils.isEmpty((CharSequence)url) ? null : url;
    }

    @Override
    public IpAddress ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public DeviceId deviceId() {
        try {
            return DeviceId.deviceId((URI)new URI(REST, this.ip + COLON + this.port, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create deviceID rest:" + this.ip + COLON + this.port, e);
        }
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String url() {
        return this.url;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("url", (Object)this.url).add("protocol", (Object)this.protocol).add("username", (Object)this.username).add("port", this.port).add("ip", (Object)this.ip).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RestSBDevice)) {
            return false;
        }
        RestSBDevice device = (RestSBDevice)obj;
        return this.username.equals(device.username()) && this.ip.equals((Object)device.ip()) && this.port == device.port();
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.port);
    }
}

