/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.rest.ctl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.protocol.rest.DefaultRestSBDevice;
import org.onosproject.protocol.rest.RestSBDevice;
import org.onosproject.protocol.rest.ctl.RestSBControllerImpl;

public class RestSBControllerImplTest {
    RestSBControllerImpl controller;
    RestSBDevice device1;
    RestSBDevice device2;

    @Before
    public void setUp() {
        this.controller = new RestSBControllerImpl();
        this.controller.activate();
        this.device1 = new DefaultRestSBDevice(IpAddress.valueOf((String)"127.0.0.1"), 8080, "foo", "bar", "http", null, true);
        this.device2 = new DefaultRestSBDevice(IpAddress.valueOf((String)"127.0.0.2"), 8080, "foo1", "bar2", "http", null, true);
        this.controller.addDevice(this.device1);
    }

    @Test
    public void basics() {
        Assert.assertTrue((String)"Device1 non added", (boolean)this.controller.getDevices().containsValue(this.device1));
        Assert.assertEquals((String)"Device1 added but with wrong key", this.controller.getDevices().get(this.device1.deviceId()), (Object)this.device1);
        Assert.assertEquals((String)"Incorrect Get Device by ID", (Object)this.controller.getDevice(this.device1.deviceId()), (Object)this.device1);
        Assert.assertEquals((String)"Incorrect Get Device by IP, Port", (Object)this.controller.getDevice(this.device1.ip(), this.device1.port()), (Object)this.device1);
        this.controller.addDevice(this.device2);
        Assert.assertTrue((String)"Device2 non added", (boolean)this.controller.getDevices().containsValue(this.device2));
        this.controller.removeDevice(this.device2.deviceId());
        Assert.assertFalse((String)"Device2 not removed", (boolean)this.controller.getDevices().containsValue(this.device2));
    }
}

