/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.rest.ctl;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.protocol.rest.RestSBController;
import org.onosproject.protocol.rest.RestSBDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RestSBControllerImpl
implements RestSBController {
    private static final Logger log = LoggerFactory.getLogger(RestSBControllerImpl.class);
    private static final String XML = "xml";
    private static final String JSON = "json";
    private static final String DOUBLESLASH = "//";
    private static final String COLON = ":";
    private static final int STATUS_OK = Response.Status.OK.getStatusCode();
    private static final int STATUS_CREATED = Response.Status.CREATED.getStatusCode();
    private static final int STATUS_ACCEPTED = Response.Status.ACCEPTED.getStatusCode();
    private static final String HTTPS = "https";
    private static final String AUTHORIZATION_PROPERTY = "authorization";
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private final Map<DeviceId, RestSBDevice> deviceMap = new ConcurrentHashMap<DeviceId, RestSBDevice>();
    Client client;

    @Activate
    public void activate() {
        this.client = Client.create();
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceMap.clear();
        log.info("Stopped");
    }

    public Map<DeviceId, RestSBDevice> getDevices() {
        return ImmutableMap.copyOf(this.deviceMap);
    }

    public RestSBDevice getDevice(DeviceId deviceInfo) {
        return this.deviceMap.get(deviceInfo);
    }

    public RestSBDevice getDevice(IpAddress ip, int port) {
        return this.deviceMap.values().stream().filter(v -> v.ip().equals((Object)ip) && v.port() == port).findFirst().get();
    }

    public void addDevice(RestSBDevice device) {
        this.deviceMap.put(device.deviceId(), device);
    }

    public void removeDevice(DeviceId deviceId) {
        this.deviceMap.remove(deviceId);
    }

    public boolean post(DeviceId device, String request, InputStream payload, String mediaType) {
        WebResource webResource = this.getWebResource(device, request);
        ClientResponse response = null;
        if (payload != null) {
            try {
                response = (ClientResponse)webResource.accept(new String[]{mediaType}).post(ClientResponse.class, (Object)IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error("Cannot do POST {} request on device {} because can't read payload", (Object)request, (Object)device);
            }
        } else {
            response = (ClientResponse)webResource.accept(new String[]{mediaType}).post(ClientResponse.class);
        }
        return this.checkReply(response);
    }

    public boolean put(DeviceId device, String request, InputStream payload, String mediaType) {
        WebResource webResource = this.getWebResource(device, request);
        ClientResponse response = null;
        if (payload != null) {
            try {
                response = (ClientResponse)webResource.accept(new String[]{mediaType}).put(ClientResponse.class, (Object)IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error("Cannot do PUT {} request on device {} because can't read payload", (Object)request, (Object)device);
            }
        } else {
            response = (ClientResponse)webResource.accept(new String[]{mediaType}).put(ClientResponse.class);
        }
        return this.checkReply(response);
    }

    public InputStream get(DeviceId device, String request, String mediaType) {
        String type;
        WebResource webResource = this.getWebResource(device, request);
        switch (mediaType) {
            case "xml": {
                type = "application/xml";
                break;
            }
            case "json": {
                type = "application/json";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported media type " + mediaType);
            }
        }
        ClientResponse s = (ClientResponse)webResource.accept(new String[]{type}).get(ClientResponse.class);
        if (this.checkReply(s)) {
            return new ByteArrayInputStream(((String)s.getEntity(String.class)).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    public boolean patch(DeviceId device, String request, InputStream payload, String mediaType) {
        try {
            log.debug("Url request {} ", (Object)this.getUrlString(device, request));
            HttpPatch httprequest = new HttpPatch(this.getUrlString(device, request));
            if (this.deviceMap.get(device).username() != null) {
                String pwd = this.deviceMap.get(device).password() == null ? "" : COLON + this.deviceMap.get(device).password();
                String userPassword = this.deviceMap.get(device).username() + pwd;
                String base64string = Base64.getEncoder().encodeToString(userPassword.getBytes(StandardCharsets.UTF_8));
                httprequest.addHeader(AUTHORIZATION_PROPERTY, BASIC_AUTH_PREFIX + base64string);
            }
            if (payload != null) {
                StringEntity input = new StringEntity(IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8));
                input.setContentType(mediaType);
                httprequest.setEntity((HttpEntity)input);
            }
            CloseableHttpClient httpClient = this.deviceMap.containsKey(device) && this.deviceMap.get(device).protocol().equals(HTTPS) ? this.getApacheSslBypassClient() : HttpClients.createDefault();
            int responseStatusCode = httpClient.execute((HttpUriRequest)httprequest).getStatusLine().getStatusCode();
            return this.checkStatusCode(responseStatusCode);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("Cannot do PATCH {} request on device {}", new Object[]{request, device, e});
            return false;
        }
    }

    public boolean delete(DeviceId device, String request, InputStream payload, String mediaType) {
        WebResource webResource = this.getWebResource(device, request);
        ClientResponse response = null;
        if (payload != null) {
            try {
                response = (ClientResponse)webResource.accept(new String[]{mediaType}).delete(ClientResponse.class, (Object)IOUtils.toString((InputStream)payload, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                log.error("Cannot do PUT {} request on device {} because can't read payload", (Object)request, (Object)device);
            }
        } else {
            response = (ClientResponse)webResource.accept(new String[]{mediaType}).delete(ClientResponse.class);
        }
        return this.checkReply(response);
    }

    private WebResource getWebResource(DeviceId device, String request) {
        log.debug("Sending request to URL {} ", (Object)this.getUrlString(device, request));
        WebResource webResource = this.client.resource(this.getUrlString(device, request));
        if (this.deviceMap.containsKey(device) && this.deviceMap.get(device).username() != null) {
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.deviceMap.get(device).username(), this.deviceMap.get(device).password() == null ? "" : this.deviceMap.get(device).password()));
        }
        return webResource;
    }

    private CloseableHttpClient getApacheSslBypassClient() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        return HttpClients.custom().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).setSslcontext(new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build()).build();
    }

    private String getUrlString(DeviceId device, String request) {
        if (this.deviceMap.get(device).url() != null) {
            return this.deviceMap.get(device).protocol() + COLON + DOUBLESLASH + this.deviceMap.get(device).url() + request;
        }
        return this.deviceMap.get(device).protocol() + COLON + DOUBLESLASH + this.deviceMap.get(device).ip().toString() + COLON + this.deviceMap.get(device).port() + request;
    }

    private boolean checkReply(ClientResponse response) {
        if (response != null) {
            return this.checkStatusCode(response.getStatus());
        }
        log.error("Null reply from device");
        return false;
    }

    private boolean checkStatusCode(int statusCode) {
        if (statusCode == STATUS_OK || statusCode == STATUS_CREATED || statusCode == STATUS_ACCEPTED) {
            return true;
        }
        log.error("Failed request, HTTP error code : " + statusCode);
        return false;
    }
}

