/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.FastHashMap;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.core.CoreService;
import org.onosproject.core.Permission;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverAdminService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostClockService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentClockService;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.PartitionService;
import org.onosproject.net.link.LinkAdminService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.proxyarp.ProxyArpService;
import org.onosproject.net.resource.link.LinkResourceService;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.security.AppPermission;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PolicyBuilder {
    private PolicyBuilder() {
    }

    public static PermissionInfo[] getApplicationPermissions(HashMap<Permission, Set<String>> serviceDirectory, Set<Permission> permissions) {
        HashSet permSet = Sets.newHashSet();
        Collections.addAll(permSet, PolicyBuilder.getDefaultPerms());
        for (Permission perm : permissions) {
            permSet.add(new PermissionInfo(AppPermission.class.getName(), perm.name(), ""));
            permSet.addAll(serviceDirectory.get(perm).stream().map(service -> new PermissionInfo(ServicePermission.class.getName(), service, "get")).collect(Collectors.toList()));
        }
        PermissionInfo[] permissionInfos = new PermissionInfo[permSet.size()];
        return permSet.toArray(permissionInfos);
    }

    public static PermissionInfo[] getAdminApplicationPermissions(HashMap<Permission, Set<String>> serviceDirectory) {
        HashSet permSet = Sets.newHashSet();
        Collections.addAll(permSet, PolicyBuilder.getDefaultPerms());
        Collections.addAll(permSet, PolicyBuilder.getAdminDefaultPerms());
        permSet.addAll(serviceDirectory.keySet().stream().map(perm -> new PermissionInfo(AppPermission.class.getName(), perm.name(), "")).collect(Collectors.toList()));
        PermissionInfo[] permissionInfos = new PermissionInfo[permSet.size()];
        return permSet.toArray(permissionInfos);
    }

    public static PermissionInfo[] getDefaultPerms() {
        return new PermissionInfo[]{new PermissionInfo(PackagePermission.class.getName(), "*", "exportonly"), new PermissionInfo(PackagePermission.class.getName(), "*", "import"), new PermissionInfo(AdaptPermission.class.getName(), "*", "adapt")};
    }

    public static PermissionInfo[] getAdminDefaultPerms() {
        return new PermissionInfo[]{new PermissionInfo(ServicePermission.class.getName(), ApplicationAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), ClusterAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), MastershipAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), DeviceAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), HostAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), LinkAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), DriverAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), StorageAdminService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), ApplicationService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), ComponentConfigService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), CoreService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), ClusterService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), LeadershipService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), MastershipService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), DeviceService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), DeviceClockService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), DriverService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), FlowRuleService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), FlowObjectiveService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), GroupService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), HostService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), HostClockService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), IntentService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), IntentClockService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), IntentExtensionService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), PartitionService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), LinkService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), LinkResourceService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), PacketService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), ProxyArpService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), StatisticService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), PathService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), TopologyService.class.getName(), "get"), new PermissionInfo(ServicePermission.class.getName(), StorageService.class.getName(), "get")};
    }

    public static HashMap<Permission, Set<String>> getServiceDirectory() {
        FastHashMap serviceDirectory = new FastHashMap();
        serviceDirectory.put(Permission.APP_READ, ImmutableSet.of((Object)ApplicationService.class.getName(), (Object)CoreService.class.getName()));
        serviceDirectory.put(Permission.APP_EVENT, ImmutableSet.of((Object)ApplicationService.class.getName(), (Object)CoreService.class.getName()));
        serviceDirectory.put(Permission.CONFIG_READ, ImmutableSet.of((Object)ComponentConfigService.class.getName()));
        serviceDirectory.put(Permission.CONFIG_WRITE, ImmutableSet.of((Object)ComponentConfigService.class.getName()));
        serviceDirectory.put(Permission.CLUSTER_READ, ImmutableSet.of((Object)ClusterService.class.getName(), (Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName()));
        serviceDirectory.put(Permission.CLUSTER_WRITE, ImmutableSet.of((Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName()));
        serviceDirectory.put(Permission.CLUSTER_EVENT, ImmutableSet.of((Object)ClusterService.class.getName(), (Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName()));
        serviceDirectory.put(Permission.DEVICE_READ, ImmutableSet.of((Object)DeviceService.class.getName(), (Object)DeviceClockService.class.getName()));
        serviceDirectory.put(Permission.DEVICE_EVENT, ImmutableSet.of((Object)DeviceService.class.getName()));
        serviceDirectory.put(Permission.DRIVER_READ, ImmutableSet.of((Object)DriverService.class.getName()));
        serviceDirectory.put(Permission.DRIVER_WRITE, ImmutableSet.of((Object)DriverService.class.getName()));
        serviceDirectory.put(Permission.FLOWRULE_READ, ImmutableSet.of((Object)FlowRuleService.class.getName()));
        serviceDirectory.put(Permission.FLOWRULE_WRITE, ImmutableSet.of((Object)FlowRuleService.class.getName(), (Object)FlowObjectiveService.class.getName()));
        serviceDirectory.put(Permission.FLOWRULE_EVENT, ImmutableSet.of((Object)FlowRuleService.class.getName()));
        serviceDirectory.put(Permission.GROUP_READ, ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(Permission.GROUP_WRITE, ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(Permission.GROUP_EVENT, ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(Permission.HOST_READ, ImmutableSet.of((Object)HostService.class.getName(), (Object)HostClockService.class.getName()));
        serviceDirectory.put(Permission.HOST_WRITE, ImmutableSet.of((Object)HostService.class.getName()));
        serviceDirectory.put(Permission.HOST_EVENT, ImmutableSet.of((Object)HostService.class.getName()));
        serviceDirectory.put(Permission.INTENT_READ, ImmutableSet.of((Object)IntentService.class.getName(), (Object)PartitionService.class.getName(), (Object)IntentClockService.class.getName()));
        serviceDirectory.put(Permission.INTENT_WRITE, ImmutableSet.of((Object)IntentService.class.getName()));
        serviceDirectory.put(Permission.INTENT_EVENT, ImmutableSet.of((Object)IntentService.class.getName()));
        serviceDirectory.put(Permission.PACKET_READ, ImmutableSet.of((Object)PacketService.class.getName(), (Object)ProxyArpService.class.getName()));
        serviceDirectory.put(Permission.PACKET_WRITE, ImmutableSet.of((Object)PacketService.class.getName(), (Object)ProxyArpService.class.getName()));
        serviceDirectory.put(Permission.PACKET_EVENT, ImmutableSet.of((Object)PacketService.class.getName()));
        serviceDirectory.put(Permission.STATISTIC_READ, ImmutableSet.of((Object)StatisticService.class.getName()));
        serviceDirectory.put(Permission.TOPOLOGY_READ, ImmutableSet.of((Object)TopologyService.class.getName(), (Object)PathService.class.getName()));
        serviceDirectory.put(Permission.TOPOLOGY_EVENT, ImmutableSet.of((Object)TopologyService.class.getName()));
        serviceDirectory.put(Permission.STORAGE_WRITE, ImmutableSet.of((Object)StorageService.class.getName()));
        return serviceDirectory;
    }
}

