/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security.impl;

import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.FastHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationListener;
import org.onosproject.app.ApplicationState;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.security.AppPermission;
import org.onosproject.security.impl.PolicyBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.ServicePermission;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SecurityModeManager {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationAdminService appAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FeaturesService featuresService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogReaderService logReaderService;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private SecurityBundleListener securityBundleListener = new SecurityBundleListener();
    private SecurityApplicationListener securityApplicationListener = new SecurityApplicationListener();
    private SecurityLogListener securityLogListener = new SecurityLogListener();
    private Bundle bundle = null;
    private BundleContext bundleContext = null;
    private PermissionAdmin permissionAdmin = null;
    private HashMap<String, ApplicationId> appTracker = null;
    private HashMap<org.onosproject.core.Permission, Set<String>> serviceDirectory = null;

    @Activate
    public void activate() {
        if (System.getSecurityManager() == null) {
            this.log.warn("J2EE security manager is disabled.");
            this.deactivate();
            return;
        }
        this.bundle = FrameworkUtil.getBundle(this.getClass());
        this.bundleContext = this.bundle.getBundleContext();
        this.bundleContext.addBundleListener((BundleListener)this.securityBundleListener);
        this.appAdminService.addListener((ApplicationListener)this.securityApplicationListener);
        this.logReaderService.addLogListener((LogListener)this.securityLogListener);
        this.appTracker = new FastHashMap();
        this.permissionAdmin = this.getPermissionAdmin(this.bundleContext);
        if (this.permissionAdmin == null) {
            this.log.warn("Permission Admin not found.");
            this.deactivate();
            return;
        }
        this.serviceDirectory = PolicyBuilder.getServiceDirectory();
        PermissionInfo[] allPerm = new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), "", "")};
        this.permissionAdmin.setPermissions(this.bundle.getLocation(), allPerm);
        this.log.warn("Security-Mode Started");
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext.removeBundleListener((BundleListener)this.securityBundleListener);
        this.appAdminService.removeListener((ApplicationListener)this.securityApplicationListener);
        this.logReaderService.removeLogListener((LogListener)this.securityLogListener);
        this.log.info("Stopped");
    }

    private void clearPermissions(BundleEvent bundleEvent) {
        if (this.appTracker.containsKey(bundleEvent.getBundle().getLocation())) {
            this.permissionAdmin.setPermissions(bundleEvent.getBundle().getLocation(), new PermissionInfo[0]);
            this.appTracker.remove(bundleEvent.getBundle().getLocation());
        }
    }

    private void setPermissions(BundleEvent bundleEvent) {
        for (Application app : this.appAdminService.getApplications()) {
            if (!this.getBundleLocations(app).contains(bundleEvent.getBundle().getLocation())) continue;
            String location = bundleEvent.getBundle().getLocation();
            Set permissions = this.appAdminService.getPermissions(app.id());
            if (permissions == null) {
                permissions = app.permissions();
            }
            if (permissions.isEmpty()) {
                this.print("Application %s has not been granted any permission.", app.id().name());
            }
            PermissionInfo[] perms = null;
            switch (app.role()) {
                case ADMIN: {
                    perms = PolicyBuilder.getAdminApplicationPermissions(this.serviceDirectory);
                    break;
                }
                case REGULAR: {
                    perms = PolicyBuilder.getApplicationPermissions(this.serviceDirectory, permissions);
                    break;
                }
                default: {
                    perms = PolicyBuilder.getDefaultPerms();
                    this.log.warn("Application %s has no role assigned.", (Object)app.id().name());
                }
            }
            this.permissionAdmin.setPermissions(location, perms);
            this.appTracker.put(location, app.id());
            break;
        }
    }

    private void handleException(String name, Permission perm) {
        if (perm instanceof ServicePermission || perm instanceof PackagePermission) {
            this.print("%s has attempted to %s %s.", name, perm.getActions(), perm.getName());
        } else if (perm instanceof AppPermission) {
            this.print("%s has attempted to call an NB API that requires %s permission.", name, perm.getName().toUpperCase());
        } else {
            this.print("%s has attempted to perform an action that requires %s", name, perm.toString());
        }
        this.print("POLICY VIOLATION: Deactivating %s.", name);
    }

    private void print(String format, Object ... args) {
        System.out.println(String.format("SM-ONOS: " + format, args));
        this.log.warn(String.format(format, args));
    }

    private List<String> getBundleLocations(Application app) {
        ArrayList<String> locations = new ArrayList<String>();
        for (String name : app.features()) {
            try {
                Feature feature = this.featuresService.getFeature(name);
                locations.addAll(feature.getBundles().stream().map(BundleInfo::getLocation).collect(Collectors.toList()));
            }
            catch (Exception e) {
                return locations;
            }
        }
        return locations;
    }

    private PermissionAdmin getPermissionAdmin(BundleContext context) {
        return (PermissionAdmin)context.getService(context.getServiceReference(PermissionAdmin.class.getName()));
    }

    protected void bindAppAdminService(ApplicationAdminService applicationAdminService) {
        this.appAdminService = applicationAdminService;
    }

    protected void unbindAppAdminService(ApplicationAdminService applicationAdminService) {
        if (this.appAdminService == applicationAdminService) {
            this.appAdminService = null;
        }
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (this.featuresService == featuresService) {
            this.featuresService = null;
        }
    }

    protected void bindLogReaderService(LogReaderService logReaderService) {
        this.logReaderService = logReaderService;
    }

    protected void unbindLogReaderService(LogReaderService logReaderService) {
        if (this.logReaderService == logReaderService) {
            this.logReaderService = null;
        }
    }

    private class SecurityLogListener
    implements LogListener {
        private SecurityLogListener() {
        }

        public void logged(LogEntry entry) {
            ApplicationId applicationId;
            if (entry != null && entry.getException() != null && (applicationId = (ApplicationId)SecurityModeManager.this.appTracker.get(entry.getBundle().getLocation())) != null && SecurityModeManager.this.appAdminService.getState(applicationId).equals((Object)ApplicationState.ACTIVE) && entry.getException() instanceof AccessControlException) {
                Permission permission = ((AccessControlException)entry.getException()).getPermission();
                SecurityModeManager.this.handleException(applicationId.name(), permission);
                SecurityModeManager.this.appAdminService.deactivate(applicationId);
            }
        }
    }

    private class SecurityBundleListener
    implements BundleListener {
        private SecurityBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            switch (event.getType()) {
                case 1: {
                    SecurityModeManager.this.setPermissions(event);
                    break;
                }
                case 16: {
                    SecurityModeManager.this.clearPermissions(event);
                    break;
                }
            }
        }
    }

    private class SecurityApplicationListener
    implements ApplicationListener {
        private SecurityApplicationListener() {
        }

        public void event(ApplicationEvent event) {
            if (event.type() == ApplicationEvent.Type.APP_PERMISSIONS_CHANGED && SecurityModeManager.this.appAdminService.getState(((Application)event.subject()).id()) == ApplicationState.ACTIVE) {
                SecurityModeManager.this.appAdminService.deactivate(((Application)event.subject()).id());
                SecurityModeManager.this.print("Permissions updated (%s). Deactivating...", new Object[]{((Application)event.subject()).id().name()});
            }
        }
    }
}

