/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.Permissions;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.LoggingPermission;
import javax.net.ssl.SSLPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.PrivateCredentialPermission;
import javax.security.auth.kerberos.DelegationPermission;
import javax.security.auth.kerberos.ServicePermission;
import javax.sound.sampled.AudioPermission;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationService;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterAdminService;
import org.onosproject.cluster.ClusterMetadataAdminService;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.LeadershipAdminService;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.codec.CodecService;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipTermService;
import org.onosproject.net.config.BasicNetworkConfigService;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceAdminService;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverAdminService;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.edge.EdgePortService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostAdminService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentClockService;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentPartitionService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.key.DeviceKeyAdminService;
import org.onosproject.net.key.DeviceKeyService;
import org.onosproject.net.link.LinkAdminService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.newresource.ResourceAdminService;
import org.onosproject.net.newresource.ResourceService;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.proxyarp.ProxyArpService;
import org.onosproject.net.region.RegionAdminService;
import org.onosproject.net.region.RegionService;
import org.onosproject.net.statistic.FlowStatisticService;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.security.AppPermission;
import org.onosproject.security.Permission;
import org.onosproject.security.SecurityAdminService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.MutexExecutionService;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.ui.UiExtensionService;
import org.osgi.framework.AdaptPermission;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.CapabilityPermission;
import org.osgi.framework.PackagePermission;
import org.osgi.service.cm.ConfigurationPermission;

public final class DefaultPolicyBuilder {
    protected static ConcurrentHashMap<AppPermission.Type, Set<String>> serviceDirectory = DefaultPolicyBuilder.getServiceDirectory();
    protected static List<java.security.Permission> defaultPermissions = DefaultPolicyBuilder.getDefaultPerms();
    protected static List<java.security.Permission> adminServicePermissions = DefaultPolicyBuilder.getAdminDefaultPerms();

    private DefaultPolicyBuilder() {
    }

    public static List<java.security.Permission> getUserApplicationPermissions(Set<Permission> permissions) {
        ArrayList perms = Lists.newArrayList();
        perms.addAll(defaultPermissions);
        perms.addAll(DefaultPolicyBuilder.convertToJavaPermissions(permissions));
        return DefaultPolicyBuilder.optimizePermissions(perms);
    }

    public static List<java.security.Permission> getAdminApplicationPermissions(Set<Permission> permissions) {
        ArrayList perms = Lists.newArrayList();
        perms.addAll(defaultPermissions);
        perms.addAll(adminServicePermissions);
        for (AppPermission.Type perm : serviceDirectory.keySet()) {
            perms.add(new AppPermission(perm));
        }
        perms.addAll(DefaultPolicyBuilder.convertToJavaPermissions(permissions));
        return DefaultPolicyBuilder.optimizePermissions(perms);
    }

    public static List<java.security.Permission> convertToJavaPermissions(Set<Permission> permissions) {
        ArrayList result = Lists.newArrayList();
        for (Permission perm : permissions) {
            java.security.Permission javaPerm = DefaultPolicyBuilder.getPermission(perm);
            if (javaPerm == null) continue;
            if (javaPerm instanceof AppPermission) {
                if (((AppPermission)javaPerm).getType() == null) continue;
                AppPermission ap = (AppPermission)javaPerm;
                result.add(ap);
                if (!serviceDirectory.containsKey(ap.getType())) continue;
                for (String service : serviceDirectory.get(ap.getType())) {
                    result.add(new org.osgi.framework.ServicePermission(service, "get"));
                }
                continue;
            }
            if (javaPerm instanceof org.osgi.framework.ServicePermission) {
                if (javaPerm.getName().contains(SecurityAdminService.class.getName())) continue;
                result.add(javaPerm);
                continue;
            }
            result.add(javaPerm);
        }
        return result;
    }

    public static Set<Permission> convertToOnosPermissions(List<java.security.Permission> permissions) {
        HashSet result = Sets.newHashSet();
        for (java.security.Permission perm : permissions) {
            Permission onosPerm = DefaultPolicyBuilder.getOnosPermission(perm);
            if (onosPerm == null) continue;
            result.add(onosPerm);
        }
        return result;
    }

    public static List<java.security.Permission> getDefaultPerms() {
        ArrayList permSet = Lists.newArrayList();
        permSet.add(new PackagePermission("*", "exportonly"));
        permSet.add(new PackagePermission("*", "import"));
        permSet.add(new AdaptPermission("*", "adapt"));
        permSet.add(new ConfigurationPermission("*", "configure"));
        permSet.add(new AdminPermission("*", "metadata"));
        return permSet;
    }

    private static List<java.security.Permission> getAdminDefaultPerms() {
        ArrayList permSet = Lists.newArrayList();
        permSet.add(new org.osgi.framework.ServicePermission(ApplicationAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ClusterAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(LeadershipAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ClusterMetadataAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(MastershipAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DeviceAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DriverAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(HostAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DeviceKeyAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(LinkAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ResourceAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(RegionAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(PartitionAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(StorageAdminService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ApplicationService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ComponentConfigService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ClusterMetadataService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ClusterService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(LeadershipService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(CodecService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(CoreService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(EventDeliveryService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(MastershipService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(MastershipTermService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(BasicNetworkConfigService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(NetworkConfigService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DeviceService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DeviceClockService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DriverService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(EdgePortService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(FlowRuleService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(FlowObjectiveService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(GroupService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(HostService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(IntentService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(IntentClockService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(IntentExtensionService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(IntentPartitionService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(DeviceKeyService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(LinkService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ResourceService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(PacketService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ProxyArpService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(RegionService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(FlowStatisticService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(StatisticService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(PathService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(TopologyService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(PersistenceService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(ClusterCommunicationService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(MessagingService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(PartitionService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(LogicalClockService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(MutexExecutionService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(StorageService.class.getName(), "get"));
        permSet.add(new org.osgi.framework.ServicePermission(UiExtensionService.class.getName(), "get"));
        return permSet;
    }

    public static Set<String> getNBServiceList() {
        HashSet<String> permString = new HashSet<String>();
        for (java.security.Permission perm : DefaultPolicyBuilder.getAdminDefaultPerms()) {
            permString.add(perm.getName());
        }
        return permString;
    }

    private static ConcurrentHashMap<AppPermission.Type, Set<String>> getServiceDirectory() {
        ConcurrentHashMap<AppPermission.Type, Set<String>> serviceDirectory = new ConcurrentHashMap<AppPermission.Type, Set<String>>();
        serviceDirectory.put(AppPermission.Type.APP_READ, (Set<String>)ImmutableSet.of((Object)ApplicationService.class.getName(), (Object)CoreService.class.getName()));
        serviceDirectory.put(AppPermission.Type.APP_EVENT, (Set<String>)ImmutableSet.of((Object)ApplicationService.class.getName(), (Object)CoreService.class.getName()));
        serviceDirectory.put(AppPermission.Type.APP_WRITE, (Set<String>)ImmutableSet.of((Object)CoreService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CONFIG_READ, (Set<String>)ImmutableSet.of((Object)ComponentConfigService.class.getName(), (Object)NetworkConfigService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CONFIG_WRITE, (Set<String>)ImmutableSet.of((Object)ComponentConfigService.class.getName(), (Object)NetworkConfigService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CONFIG_EVENT, (Set<String>)ImmutableSet.of((Object)NetworkConfigService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CLUSTER_READ, (Set<String>)ImmutableSet.of((Object)ClusterService.class.getName(), (Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName(), (Object)ClusterMetadataService.class.getName(), (Object)MastershipTermService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CLUSTER_WRITE, (Set<String>)ImmutableSet.of((Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName(), (Object)ClusterCommunicationService.class.getName(), (Object)MessagingService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CLUSTER_EVENT, (Set<String>)ImmutableSet.of((Object)ClusterService.class.getName(), (Object)LeadershipService.class.getName(), (Object)MastershipService.class.getName()));
        serviceDirectory.put(AppPermission.Type.DEVICE_READ, (Set<String>)ImmutableSet.of((Object)DeviceService.class.getName(), (Object)DeviceClockService.class.getName()));
        serviceDirectory.put(AppPermission.Type.DEVICE_EVENT, (Set<String>)ImmutableSet.of((Object)DeviceService.class.getName()));
        serviceDirectory.put(AppPermission.Type.DRIVER_READ, (Set<String>)ImmutableSet.of((Object)DriverService.class.getName()));
        serviceDirectory.put(AppPermission.Type.DRIVER_WRITE, (Set<String>)ImmutableSet.of((Object)DriverService.class.getName()));
        serviceDirectory.put(AppPermission.Type.FLOWRULE_READ, (Set<String>)ImmutableSet.of((Object)FlowRuleService.class.getName()));
        serviceDirectory.put(AppPermission.Type.FLOWRULE_WRITE, (Set<String>)ImmutableSet.of((Object)FlowRuleService.class.getName(), (Object)FlowObjectiveService.class.getName()));
        serviceDirectory.put(AppPermission.Type.FLOWRULE_EVENT, (Set<String>)ImmutableSet.of((Object)FlowRuleService.class.getName()));
        serviceDirectory.put(AppPermission.Type.GROUP_READ, (Set<String>)ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(AppPermission.Type.GROUP_WRITE, (Set<String>)ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(AppPermission.Type.GROUP_EVENT, (Set<String>)ImmutableSet.of((Object)GroupService.class.getName()));
        serviceDirectory.put(AppPermission.Type.HOST_READ, (Set<String>)ImmutableSet.of((Object)HostService.class.getName()));
        serviceDirectory.put(AppPermission.Type.HOST_WRITE, (Set<String>)ImmutableSet.of((Object)HostService.class.getName()));
        serviceDirectory.put(AppPermission.Type.HOST_EVENT, (Set<String>)ImmutableSet.of((Object)HostService.class.getName()));
        serviceDirectory.put(AppPermission.Type.INTENT_READ, (Set<String>)ImmutableSet.of((Object)IntentService.class.getName(), (Object)IntentPartitionService.class.getName(), (Object)IntentClockService.class.getName(), (Object)IntentExtensionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.INTENT_WRITE, (Set<String>)ImmutableSet.of((Object)IntentService.class.getName(), (Object)IntentExtensionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.INTENT_EVENT, (Set<String>)ImmutableSet.of((Object)IntentService.class.getName(), (Object)IntentPartitionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PACKET_READ, (Set<String>)ImmutableSet.of((Object)PacketService.class.getName(), (Object)ProxyArpService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PACKET_WRITE, (Set<String>)ImmutableSet.of((Object)PacketService.class.getName(), (Object)ProxyArpService.class.getName(), (Object)EdgePortService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PACKET_EVENT, (Set<String>)ImmutableSet.of((Object)PacketService.class.getName()));
        serviceDirectory.put(AppPermission.Type.STATISTIC_READ, (Set<String>)ImmutableSet.of((Object)StatisticService.class.getName(), (Object)FlowStatisticService.class.getName()));
        serviceDirectory.put(AppPermission.Type.TOPOLOGY_READ, (Set<String>)ImmutableSet.of((Object)TopologyService.class.getName(), (Object)PathService.class.getName(), (Object)EdgePortService.class.getName()));
        serviceDirectory.put(AppPermission.Type.TOPOLOGY_EVENT, (Set<String>)ImmutableSet.of((Object)TopologyService.class.getName()));
        serviceDirectory.put(AppPermission.Type.STORAGE_WRITE, (Set<String>)ImmutableSet.of((Object)StorageService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CODEC_READ, (Set<String>)ImmutableSet.of((Object)CodecService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CODEC_WRITE, (Set<String>)ImmutableSet.of((Object)CodecService.class.getName()));
        serviceDirectory.put(AppPermission.Type.EVENT_READ, (Set<String>)ImmutableSet.of((Object)EventDeliveryService.class.getName()));
        serviceDirectory.put(AppPermission.Type.EVENT_WRITE, (Set<String>)ImmutableSet.of((Object)EventDeliveryService.class.getName()));
        serviceDirectory.put(AppPermission.Type.RESOURCE_READ, (Set<String>)ImmutableSet.of((Object)ResourceService.class.getName()));
        serviceDirectory.put(AppPermission.Type.RESOURCE_WRITE, (Set<String>)ImmutableSet.of((Object)ResourceService.class.getName()));
        serviceDirectory.put(AppPermission.Type.RESOURCE_EVENT, (Set<String>)ImmutableSet.of((Object)ResourceService.class.getName()));
        serviceDirectory.put(AppPermission.Type.REGION_READ, (Set<String>)ImmutableSet.of((Object)RegionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PERSISTENCE_WRITE, (Set<String>)ImmutableSet.of((Object)PersistenceService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PARTITION_READ, (Set<String>)ImmutableSet.of((Object)PartitionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.PARTITION_EVENT, (Set<String>)ImmutableSet.of((Object)PartitionService.class.getName()));
        serviceDirectory.put(AppPermission.Type.CLOCK_WRITE, (Set<String>)ImmutableSet.of((Object)LogicalClockService.class.getName()));
        serviceDirectory.put(AppPermission.Type.MUTEX_WRITE, (Set<String>)ImmutableSet.of((Object)MutexExecutionService.class.getName()));
        return serviceDirectory;
    }

    public static Permission getOnosPermission(java.security.Permission permission) {
        if (permission instanceof AppPermission) {
            return new Permission(AppPermission.class.getName(), permission.getName(), "");
        }
        if (permission instanceof FilePermission) {
            return new Permission(FilePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof SerializablePermission) {
            return new Permission(SerializablePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof NetPermission) {
            return new Permission(NetPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof RuntimePermission) {
            return new Permission(RuntimePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof SocketPermission) {
            return new Permission(SocketPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof SQLPermission) {
            return new Permission(SQLPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof PropertyPermission) {
            return new Permission(PropertyPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof LoggingPermission) {
            return new Permission(LoggingPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof SSLPermission) {
            return new Permission(SSLPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof AuthPermission) {
            return new Permission(AuthPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof PrivateCredentialPermission) {
            return new Permission(PrivateCredentialPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof DelegationPermission) {
            return new Permission(DelegationPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof ServicePermission) {
            return new Permission(ServicePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof AudioPermission) {
            return new Permission(AudioPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof AdaptPermission) {
            return new Permission(AdaptPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof BundlePermission) {
            return new Permission(BundlePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof CapabilityPermission) {
            return new Permission(CapabilityPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof PackagePermission) {
            return new Permission(PackagePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof org.osgi.framework.ServicePermission) {
            return new Permission(org.osgi.framework.ServicePermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof AdminPermission) {
            return new Permission(AdminPermission.class.getName(), permission.getName(), permission.getActions());
        }
        if (permission instanceof ConfigurationPermission) {
            return new Permission(ConfigurationPermission.class.getName(), permission.getName(), permission.getActions());
        }
        return null;
    }

    private static java.security.Permission getPermission(Permission permission) {
        String classname = permission.getClassName();
        String name = permission.getName();
        String actions = permission.getActions();
        if (classname == null || name == null) {
            return null;
        }
        classname = classname.trim();
        name = name.trim();
        actions = actions.trim();
        if (AppPermission.class.getName().equals(classname)) {
            return new AppPermission(name);
        }
        if (FilePermission.class.getName().equals(classname)) {
            return new FilePermission(name, actions);
        }
        if (SerializablePermission.class.getName().equals(classname)) {
            return new SerializablePermission(name, actions);
        }
        if (NetPermission.class.getName().equals(classname)) {
            return new NetPermission(name, actions);
        }
        if (RuntimePermission.class.getName().equals(classname)) {
            return new RuntimePermission(name, actions);
        }
        if (SocketPermission.class.getName().equals(classname)) {
            return new SocketPermission(name, actions);
        }
        if (SQLPermission.class.getName().equals(classname)) {
            return new SQLPermission(name, actions);
        }
        if (PropertyPermission.class.getName().equals(classname)) {
            return new PropertyPermission(name, actions);
        }
        if (LoggingPermission.class.getName().equals(classname)) {
            return new LoggingPermission(name, actions);
        }
        if (SSLPermission.class.getName().equals(classname)) {
            return new SSLPermission(name, actions);
        }
        if (AuthPermission.class.getName().equals(classname)) {
            return new AuthPermission(name, actions);
        }
        if (PrivateCredentialPermission.class.getName().equals(classname)) {
            return new PrivateCredentialPermission(name, actions);
        }
        if (DelegationPermission.class.getName().equals(classname)) {
            return new DelegationPermission(name, actions);
        }
        if (ServicePermission.class.getName().equals(classname)) {
            return new ServicePermission(name, actions);
        }
        if (AudioPermission.class.getName().equals(classname)) {
            return new AudioPermission(name, actions);
        }
        if (AdaptPermission.class.getName().equals(classname)) {
            return new AdaptPermission(name, actions);
        }
        if (BundlePermission.class.getName().equals(classname)) {
            return new BundlePermission(name, actions);
        }
        if (CapabilityPermission.class.getName().equals(classname)) {
            return new CapabilityPermission(name, actions);
        }
        if (PackagePermission.class.getName().equals(classname)) {
            return new PackagePermission(name, actions);
        }
        if (org.osgi.framework.ServicePermission.class.getName().equals(classname)) {
            return new org.osgi.framework.ServicePermission(name, actions);
        }
        if (AdminPermission.class.getName().equals(classname)) {
            return new AdminPermission(name, actions);
        }
        if (ConfigurationPermission.class.getName().equals(classname)) {
            return new ConfigurationPermission(name, actions);
        }
        if (ReflectPermission.class.getName().equals(classname)) {
            return new ReflectPermission(name, actions);
        }
        return null;
    }

    private static List<java.security.Permission> optimizePermissions(List<java.security.Permission> perms) {
        Permissions permissions = DefaultPolicyBuilder.listToPermissions(perms);
        return DefaultPolicyBuilder.permissionsToList(permissions);
    }

    private static List<java.security.Permission> permissionsToList(Permissions perms) {
        ArrayList<java.security.Permission> permissions = new ArrayList<java.security.Permission>();
        Enumeration<java.security.Permission> e = perms.elements();
        while (e.hasMoreElements()) {
            permissions.add(e.nextElement());
        }
        return permissions;
    }

    private static Permissions listToPermissions(List<java.security.Permission> perms) {
        Permissions permissions = new Permissions();
        for (java.security.Permission perm : perms) {
            permissions.add(perm);
        }
        return permissions;
    }
}

