/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security.impl;

import com.google.common.collect.Lists;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.app.ApplicationState;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.security.AppPermission;
import org.onosproject.security.Permission;
import org.onosproject.security.SecurityAdminService;
import org.onosproject.security.impl.DefaultPolicyBuilder;
import org.onosproject.security.store.SecurityModeEvent;
import org.onosproject.security.store.SecurityModeListener;
import org.onosproject.security.store.SecurityModeStore;
import org.onosproject.security.store.SecurityModeStoreDelegate;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServicePermission;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SecurityModeManager
implements SecurityAdminService {
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SecurityModeStore store;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationAdminService appAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogReaderService logReaderService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final ListenerRegistry<SecurityModeEvent, SecurityModeListener> listenerRegistry = new ListenerRegistry();
    private final SecurityModeStoreDelegate delegate = new InternalStoreDelegate();
    private SecurityLogListener securityLogListener = new SecurityLogListener();
    private PermissionAdmin permissionAdmin = this.getPermissionAdmin();

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(SecurityModeEvent.class, this.listenerRegistry);
        this.logReaderService.addLogListener((LogListener)this.securityLogListener);
        if (System.getSecurityManager() == null) {
            this.log.warn("J2EE security manager is disabled.");
            this.deactivate();
            return;
        }
        if (this.permissionAdmin == null) {
            this.log.warn("Permission Admin not found.");
            this.deactivate();
            return;
        }
        this.store.setDelegate(this.delegate);
        this.log.info("Security-Mode Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(SecurityModeEvent.class);
        this.logReaderService.removeLogListener((LogListener)this.securityLogListener);
        this.store.unsetDelegate(this.delegate);
        this.log.info("Stopped");
    }

    public boolean isSecured(ApplicationId appId) {
        if (this.store.getState(appId) == null) {
            this.store.registerApplication(appId);
        }
        return this.store.isSecured(appId);
    }

    public void review(ApplicationId appId) {
        if (this.store.getState(appId) == null) {
            this.store.registerApplication(appId);
        }
        this.store.reviewPolicy(appId);
    }

    public void acceptPolicy(ApplicationId appId) {
        if (this.store.getState(appId) == null) {
            this.store.registerApplication(appId);
        }
        this.store.acceptPolicy(appId, DefaultPolicyBuilder.convertToOnosPermissions(this.getMaximumPermissions(appId)));
    }

    public void register(ApplicationId appId) {
        this.store.registerApplication(appId);
    }

    public Map<Integer, List<java.security.Permission>> getPrintableSpecifiedPermissions(ApplicationId appId) {
        return this.getPrintablePermissionMap(this.getMaximumPermissions(appId));
    }

    public Map<Integer, List<java.security.Permission>> getPrintableGrantedPermissions(ApplicationId appId) {
        return this.getPrintablePermissionMap(DefaultPolicyBuilder.convertToJavaPermissions(this.store.getGrantedPermissions(appId)));
    }

    public Map<Integer, List<java.security.Permission>> getPrintableRequestedPermissions(ApplicationId appId) {
        return this.getPrintablePermissionMap(DefaultPolicyBuilder.convertToJavaPermissions(this.store.getRequestedPermissions(appId)));
    }

    private Map<Integer, List<java.security.Permission>> getPrintablePermissionMap(List<java.security.Permission> perms) {
        ConcurrentHashMap<Integer, List<java.security.Permission>> sortedMap = new ConcurrentHashMap<Integer, List<java.security.Permission>>();
        sortedMap.put(0, new ArrayList());
        sortedMap.put(1, new ArrayList());
        sortedMap.put(2, new ArrayList());
        sortedMap.put(3, new ArrayList());
        sortedMap.put(4, new ArrayList());
        for (java.security.Permission perm : perms) {
            if (perm instanceof ServicePermission) {
                if (DefaultPolicyBuilder.getNBServiceList().contains(perm.getName())) {
                    if (perm.getName().contains("Admin")) {
                        sortedMap.get(1).add(perm);
                        continue;
                    }
                    sortedMap.get(2).add(perm);
                    continue;
                }
                sortedMap.get(3).add(perm);
                continue;
            }
            if (perm instanceof AppPermission) {
                sortedMap.get(0).add(perm);
                continue;
            }
            sortedMap.get(4).add(perm);
        }
        return sortedMap;
    }

    private void setLocalPermissions(ApplicationId applicationId) {
        for (String location : this.store.getBundleLocations(applicationId)) {
            this.permissionAdmin.setPermissions(location, this.permissionsToInfo(this.store.getGrantedPermissions(applicationId)));
        }
    }

    private PermissionInfo[] permissionsToInfo(Set<Permission> permissions) {
        ArrayList result = Lists.newArrayList();
        for (Permission perm : permissions) {
            result.add(new PermissionInfo(perm.getClassName(), perm.getName(), perm.getActions()));
        }
        PermissionInfo[] permissionInfos = new PermissionInfo[result.size()];
        return result.toArray(permissionInfos);
    }

    private List<java.security.Permission> getMaximumPermissions(ApplicationId appId) {
        List<java.security.Permission> appPerms;
        Application app = this.appAdminService.getApplication(appId);
        if (app == null) {
            this.print("Unknown application.", new Object[0]);
            return null;
        }
        switch (app.role()) {
            case ADMIN: {
                appPerms = DefaultPolicyBuilder.getAdminApplicationPermissions(app.permissions());
                break;
            }
            case USER: {
                appPerms = DefaultPolicyBuilder.getUserApplicationPermissions(app.permissions());
                break;
            }
            default: {
                appPerms = DefaultPolicyBuilder.getDefaultPerms();
            }
        }
        return appPerms;
    }

    private void print(String format, Object ... args) {
        System.out.println(String.format("SM-ONOS: " + format, args));
        this.log.warn(String.format(format, args));
    }

    private PermissionAdmin getPermissionAdmin() {
        BundleContext context = this.getBundleContext();
        return (PermissionAdmin)context.getService(context.getServiceReference(PermissionAdmin.class.getName()));
    }

    private BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }

    protected void bindStore(SecurityModeStore securityModeStore) {
        this.store = securityModeStore;
    }

    protected void unbindStore(SecurityModeStore securityModeStore) {
        if (this.store == securityModeStore) {
            this.store = null;
        }
    }

    protected void bindAppAdminService(ApplicationAdminService applicationAdminService) {
        this.appAdminService = applicationAdminService;
    }

    protected void unbindAppAdminService(ApplicationAdminService applicationAdminService) {
        if (this.appAdminService == applicationAdminService) {
            this.appAdminService = null;
        }
    }

    protected void bindLogReaderService(LogReaderService logReaderService) {
        this.logReaderService = logReaderService;
    }

    protected void unbindLogReaderService(LogReaderService logReaderService) {
        if (this.logReaderService == logReaderService) {
            this.logReaderService = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }

    private class InternalStoreDelegate
    implements SecurityModeStoreDelegate {
        private InternalStoreDelegate() {
        }

        public void notify(SecurityModeEvent event) {
            if (event.type() == SecurityModeEvent.Type.POLICY_ACCEPTED) {
                SecurityModeManager.this.setLocalPermissions((ApplicationId)event.subject());
                SecurityModeManager.this.log.info("{} POLICY ACCEPTED and ENFORCED", (Object)((ApplicationId)event.subject()).name());
            } else if (event.type() == SecurityModeEvent.Type.POLICY_VIOLATED) {
                SecurityModeManager.this.log.info("{} POLICY VIOLATED", (Object)((ApplicationId)event.subject()).name());
            } else if (event.type() == SecurityModeEvent.Type.POLICY_REVIEWED) {
                SecurityModeManager.this.log.info("{} POLICY REVIEWED", (Object)((ApplicationId)event.subject()).name());
            }
            SecurityModeManager.this.eventDispatcher.post((Event)event);
        }
    }

    private class SecurityLogListener
    implements LogListener {
        private SecurityLogListener() {
        }

        public void logged(LogEntry entry) {
            if (entry.getException() != null && entry.getException() instanceof AccessControlException) {
                String location = entry.getBundle().getLocation();
                java.security.Permission javaPerm = ((AccessControlException)entry.getException()).getPermission();
                Permission permission = DefaultPolicyBuilder.getOnosPermission(javaPerm);
                if (permission == null) {
                    SecurityModeManager.this.log.warn("Unsupported permission requested.");
                    return;
                }
                SecurityModeManager.this.store.getApplicationIds(location).stream().filter(appId -> SecurityModeManager.this.store.isSecured((ApplicationId)appId) && SecurityModeManager.this.appAdminService.getState(appId) == ApplicationState.ACTIVE).forEach(appId -> {
                    SecurityModeManager.this.store.requestPermission((ApplicationId)appId, permission);
                    SecurityModeManager.this.print("[POLICY VIOLATION] APP: %s / Bundle: %s / Permission: %s ", new Object[]{appId.name(), location, permission.toString()});
                });
            }
        }
    }
}

