/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.security.store;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.onlab.util.KryoNamespace;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.Event;
import org.onosproject.security.Permission;
import org.onosproject.security.store.SecurityInfo;
import org.onosproject.security.store.SecurityModeEvent;
import org.onosproject.security.store.SecurityModeState;
import org.onosproject.security.store.SecurityModeStore;
import org.onosproject.security.store.SecurityModeStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedSecurityModeStore
extends AbstractStore<SecurityModeEvent, SecurityModeStoreDelegate>
implements SecurityModeStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ConsistentMap<ApplicationId, SecurityInfo> states;
    private EventuallyConsistentMap<ApplicationId, Set<Permission>> violations;
    private ConcurrentHashMap<String, Set<ApplicationId>> localBundleAppDirectory;
    private ConcurrentHashMap<ApplicationId, Set<String>> localAppBundleDirectory;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationAdminService applicationAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FeaturesService featuresService;
    private static final Serializer STATE_SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{SecurityModeState.class}).register(new Class[]{SecurityInfo.class}).register(new Class[]{Permission.class}).build());
    private static final KryoNamespace.Builder VIOLATION_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Permission.class});

    @Activate
    public void activate() {
        this.states = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("smonos-sdata")).withSerializer(STATE_SERIALIZER)).build();
        this.states.addListener((MapEventListener)new SecurityStateListener());
        this.violations = this.storageService.eventuallyConsistentMapBuilder().withName("smonos-rperms").withSerializer(VIOLATION_SERIALIZER).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.localBundleAppDirectory = new ConcurrentHashMap();
        this.localAppBundleDirectory = new ConcurrentHashMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.violations.destroy();
        this.log.info("Stopped");
    }

    @Override
    public Set<String> getBundleLocations(ApplicationId appId) {
        HashSet locations = this.localAppBundleDirectory.get(appId);
        return locations != null ? locations : Sets.newHashSet();
    }

    @Override
    public Set<ApplicationId> getApplicationIds(String location) {
        HashSet appIds = this.localBundleAppDirectory.get(location);
        return appIds != null ? appIds : Sets.newHashSet();
    }

    @Override
    public Set<Permission> getRequestedPermissions(ApplicationId appId) {
        Set permissions = (Set)this.violations.get((Object)appId);
        return permissions != null ? permissions : ImmutableSet.of();
    }

    @Override
    public Set<Permission> getGrantedPermissions(ApplicationId appId) {
        return this.states.asJavaMap().getOrDefault(appId, new SecurityInfo((Set<Permission>)ImmutableSet.of(), null)).getPermissions();
    }

    @Override
    public void requestPermission(ApplicationId appId, Permission permission) {
        this.states.computeIf((Object)appId, securityInfo -> securityInfo == null || securityInfo.getState() != SecurityModeState.POLICY_VIOLATED, (id, securityInfo) -> new SecurityInfo(securityInfo.getPermissions(), SecurityModeState.POLICY_VIOLATED));
        this.violations.compute((Object)appId, (k, v) -> v == null ? Sets.newHashSet((Object[])new Permission[]{permission}) : this.addAndGet((Set<Permission>)v, permission));
    }

    private Set<Permission> addAndGet(Set<Permission> oldSet, Permission newPerm) {
        oldSet.add(newPerm);
        return oldSet;
    }

    @Override
    public boolean isSecured(ApplicationId appId) {
        SecurityInfo info = (SecurityInfo)this.states.get((Object)appId).value();
        return info == null ? false : info.getState().equals((Object)SecurityModeState.SECURED);
    }

    @Override
    public void reviewPolicy(ApplicationId appId) {
        Application app = this.applicationAdminService.getApplication(appId);
        if (app == null) {
            this.log.warn("Unknown Application");
            return;
        }
        this.states.computeIfPresent((Object)appId, (applicationId, securityInfo) -> {
            if (securityInfo.getState().equals((Object)SecurityModeState.INSTALLED)) {
                return new SecurityInfo((Set<Permission>)ImmutableSet.of(), SecurityModeState.REVIEWED);
            }
            return securityInfo;
        });
    }

    @Override
    public void acceptPolicy(ApplicationId appId, Set<Permission> permissionSet) {
        Application app = this.applicationAdminService.getApplication(appId);
        if (app == null) {
            this.log.warn("Unknown Application");
            return;
        }
        this.states.computeIf((Object)appId, Objects::nonNull, (id, securityInfo) -> {
            switch (securityInfo.getState()) {
                case POLICY_VIOLATED: {
                    System.out.println("This application has violated the security policy. Please uninstall.");
                    return securityInfo;
                }
                case SECURED: {
                    System.out.println("The policy has been accepted already. To review policy, review [app.name]");
                    return securityInfo;
                }
                case INSTALLED: {
                    System.out.println("Please review the security policy prior to accept them");
                    this.log.warn("Application has not been reviewed");
                    return securityInfo;
                }
                case REVIEWED: {
                    return new SecurityInfo(permissionSet, SecurityModeState.SECURED);
                }
            }
            return securityInfo;
        });
    }

    private void removeAppFromDirectories(ApplicationId appId) {
        for (String location : this.localAppBundleDirectory.get(appId)) {
            this.localBundleAppDirectory.get(location).remove(appId);
        }
        this.violations.remove((Object)appId);
        this.states.remove((Object)appId);
        this.localAppBundleDirectory.remove(appId);
    }

    @Override
    public boolean registerApplication(ApplicationId appId) {
        Application app = this.applicationAdminService.getApplication(appId);
        if (app == null) {
            this.log.warn("Unknown application.");
            return false;
        }
        this.localAppBundleDirectory.put(appId, this.getBundleLocations(app));
        for (String location : this.localAppBundleDirectory.get(appId)) {
            if (!this.localBundleAppDirectory.containsKey(location)) {
                this.localBundleAppDirectory.put(location, new HashSet());
            }
            if (this.localBundleAppDirectory.get(location).contains(appId)) continue;
            this.localBundleAppDirectory.get(location).add(appId);
        }
        this.states.put((Object)appId, (Object)new SecurityInfo(Sets.newHashSet(), SecurityModeState.INSTALLED));
        return true;
    }

    @Override
    public void unregisterApplication(ApplicationId appId) {
        if (this.localAppBundleDirectory.containsKey(appId)) {
            for (String location : this.localAppBundleDirectory.get(appId)) {
                if (this.localBundleAppDirectory.get(location).size() == 1) {
                    this.localBundleAppDirectory.remove(location);
                    continue;
                }
                this.localBundleAppDirectory.get(location).remove(appId);
            }
            this.localAppBundleDirectory.remove(appId);
        }
    }

    @Override
    public SecurityModeState getState(ApplicationId appId) {
        return this.states.asJavaMap().getOrDefault(appId, new SecurityInfo(null, null)).getState();
    }

    private Set<String> getBundleLocations(Application app) {
        HashSet<String> locations = new HashSet<String>();
        for (String name : app.features()) {
            try {
                Feature feature = this.featuresService.getFeature(name);
                locations.addAll(feature.getBundles().stream().map(BundleInfo::getLocation).collect(Collectors.toList()));
            }
            catch (Exception e) {
                return locations;
            }
        }
        return locations;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    protected void bindApplicationAdminService(ApplicationAdminService applicationAdminService) {
        this.applicationAdminService = applicationAdminService;
    }

    protected void unbindApplicationAdminService(ApplicationAdminService applicationAdminService) {
        if (this.applicationAdminService == applicationAdminService) {
            this.applicationAdminService = null;
        }
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (this.featuresService == featuresService) {
            this.featuresService = null;
        }
    }

    private final class SecurityStateListener
    implements MapEventListener<ApplicationId, SecurityInfo> {
        private SecurityStateListener() {
        }

        public void event(MapEvent<ApplicationId, SecurityInfo> event) {
            if (DistributedSecurityModeStore.this.delegate == null) {
                return;
            }
            ApplicationId appId = (ApplicationId)event.key();
            SecurityInfo info = (SecurityInfo)event.value().value();
            if (event.type() == MapEvent.Type.INSERT || event.type() == MapEvent.Type.UPDATE) {
                switch (info.getState()) {
                    case POLICY_VIOLATED: {
                        DistributedSecurityModeStore.this.notifyDelegate((Event)new SecurityModeEvent(SecurityModeEvent.Type.POLICY_VIOLATED, appId));
                        break;
                    }
                    case SECURED: {
                        DistributedSecurityModeStore.this.notifyDelegate((Event)new SecurityModeEvent(SecurityModeEvent.Type.POLICY_ACCEPTED, appId));
                        break;
                    }
                }
            } else if (event.type() == MapEvent.Type.REMOVE) {
                DistributedSecurityModeStore.this.removeAppFromDirectories(appId);
            }
        }
    }
}

