/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.snmp.ctl;

import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpSessionFactory;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.DefaultAlarm;
import org.onosproject.snmp.SnmpDevice;
import org.onosproject.snmp.ctl.DefaultSnmpController;
import org.onosproject.snmp.ctl.DefaultSnmpDevice;
import org.onosproject.snmp.ctl.ISnmpSessionAdapter;

public class DefaultSnmpControllerTest {
    ISnmpSessionFactory mockSnmpSessionFactory = new MockISnmpSessionFactory();
    DefaultSnmpController snmpController = new DefaultSnmpController();
    DefaultSnmpDevice device = new DefaultSnmpDevice("1.1.1.1", 1, "test", "test");
    ISnmpSession snmpSession = new ISnmpSessionAdapter();
    DefaultAlarm alarm = new DefaultAlarm.Builder(this.device.deviceId(), "SNMP alarm retrieval failed", Alarm.SeverityLevel.CRITICAL, System.currentTimeMillis()).build();

    @Before
    public void setUp() {
        this.snmpController.sessionFactory = this.mockSnmpSessionFactory;
    }

    @Test
    public void testActivate() {
        this.snmpController.activate(null);
        Assert.assertNotNull((String)"Incorrect sessionFactory", (Object)this.snmpController.sessionFactory);
    }

    @Test
    public void testDeactivate() {
        this.snmpController.deactivate();
        Assert.assertEquals((String)"Device map should be clear", (long)0L, (long)this.snmpController.getDevices().size());
        Assert.assertEquals((String)"Session map should be clear", (long)0L, (long)this.snmpController.sessionMap.size());
    }

    @Test
    public void addDevice() {
        this.snmpController.addDevice(this.device.deviceId(), (SnmpDevice)this.device);
        Assert.assertEquals((String)"Controller should contain device", (Object)this.device, (Object)this.snmpController.getDevice(this.device.deviceId()));
    }

    @Test
    public void getNotExistingSession() throws Exception {
        this.addDevice();
        Assert.assertEquals((String)"Session should be created", (Object)this.snmpSession, (Object)this.snmpController.getSession(this.device.deviceId()));
        Assert.assertEquals((String)"Map should contain session", (long)1L, (long)this.snmpController.snmpDeviceMap.size());
        Assert.assertEquals((String)"Session should be fetched from map", (Object)this.snmpSession, (Object)this.snmpController.getSession(this.device.deviceId()));
    }

    @Test
    public void removeDevice() {
        this.addDevice();
        this.snmpController.removeDevice(this.device.deviceId());
        Assert.assertNull((String)"Device shoudl not be present", (Object)this.snmpController.getDevice(this.device.deviceId()));
    }

    @Test
    public void walkFailedAlarm() {
        Assert.assertEquals((String)"Alarms should be equals", (Object)this.alarm, (Object)this.snmpController.buildWalkFailedAlarm(this.device.deviceId()));
    }

    public class MockISnmpSessionFactory
    implements ISnmpSessionFactory {
        public ISnmpSession createSession(ISnmpConfiguration configuration, String ipAddress) throws IOException {
            new ISnmpSessionAdapter();
            return DefaultSnmpControllerTest.this.snmpSession;
        }

        public ISnmpSession createSession(String ipAddress, String community) throws IOException {
            return DefaultSnmpControllerTest.this.snmpSession;
        }

        public ISnmpSession createSession(String ipAddress, String community, String factoryName, ISnmpConfigurationFactory.AccessType accessType) throws IOException {
            return DefaultSnmpControllerTest.this.snmpSession;
        }
    }
}

