/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.alarm.impl;

import com.btisystems.mibbler.mibs.bti7000.bti7000_13_2_0.btisystems.btiproducts.bti7000.objects.conditions.ActAlarmTable;
import com.btisystems.mibbler.mibs.bti7000.interfaces.btisystems.btiproducts.bti7000.objects.conditions.actalarmtable.IActAlarmEntry;
import com.btisystems.pronx.ems.core.model.NetworkDevice;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.snmp.alarm.impl.Bti7000SnmpAlarmProvider;
import org.snmp4j.smi.OID;

public class Bti7000SnmpAlarmProviderTest {
    private Bti7000SnmpAlarmProvider alarmProvider;
    private ISnmpSession mockSession;
    private ActAlarmTable alarmsTable;

    @Before
    public void setUp() {
        this.mockSession = (ISnmpSession)EasyMock.createMock(ISnmpSession.class);
        this.alarmProvider = new Bti7000SnmpAlarmProvider();
    }

    @Test
    public void shouldWalkDevice() throws UnknownHostException, IOException {
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.isA(NetworkDevice.class), (List)EasyMock.eq(Arrays.asList((OID)Bti7000SnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(ActAlarmTable.class))))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Assert.assertNotNull((Object)this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1")));
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }

    @Test
    public void shouldFindAlarms() throws UnknownHostException, IOException {
        this.alarmsTable = new ActAlarmTable();
        this.alarmsTable.createEntry("14.1.3.6.1.4.1.18070.2.2.2.2.20.0.1.13.1.3.6.1.4.1.18070.2.2.1.4.14.1.7.49.46.55.46.50.46.53");
        IActAlarmEntry entry = (IActAlarmEntry)this.alarmsTable.getEntries().values().iterator().next();
        entry.setActAlarmDescription("XFP Missing.");
        entry.setActAlarmDateAndTime("07:df:0c:01:03:0d:30:00");
        entry.setActAlarmSeverity(1);
        Capture networkDeviceCapture = new Capture();
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.capture((Capture)networkDeviceCapture), (List)EasyMock.eq(Arrays.asList((OID)Bti7000SnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(ActAlarmTable.class))))).andAnswer(() -> {
            ((NetworkDevice)networkDeviceCapture.getValue()).getRootObject().setObject((Object)this.alarmsTable);
            return null;
        });
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Collection alarms = this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1"));
        Assert.assertEquals((long)1L, (long)alarms.size());
        Assert.assertEquals((Object)"XFP Missing.", (Object)((Alarm)alarms.iterator().next()).description());
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }

    @Test
    public void shouldHandleException() throws UnknownHostException, IOException {
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.isA(NetworkDevice.class), (List)EasyMock.eq(Arrays.asList((OID)Bti7000SnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(ActAlarmTable.class))))).andThrow((Throwable)new IOException());
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Assert.assertNotNull((Object)this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1")));
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }
}

