/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.alarm.impl;

import com.btisystems.mibbler.mibs.netsnmp.interfaces.mib_2.interfaces.iftable.IIfEntry;
import com.btisystems.mibbler.mibs.netsnmp.netsnmp.mib_2.interfaces.IfTable;
import com.btisystems.pronx.ems.core.model.NetworkDevice;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.IVariableBindingHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.snmp.alarm.impl.NetSnmpAlarmProvider;
import org.snmp4j.smi.OID;

public class NetSnmpSnmpAlarmProviderTest {
    private NetSnmpAlarmProvider alarmProvider;
    private ISnmpSession mockSession;
    private IfTable interfaceTable;

    @Before
    public void setUp() {
        this.mockSession = (ISnmpSession)EasyMock.createMock(ISnmpSession.class);
        this.alarmProvider = new NetSnmpAlarmProvider();
    }

    @Test
    public void shouldWalkDevice() throws UnknownHostException, IOException {
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.isA(NetworkDevice.class), (List)EasyMock.eq(Arrays.asList((OID)NetSnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(IfTable.class))))).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Assert.assertNotNull((Object)this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1")));
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }

    @Test
    public void shouldFindAlarms() throws UnknownHostException, IOException {
        this.interfaceTable = new IfTable();
        this.interfaceTable.createEntry("1");
        IIfEntry entry = this.interfaceTable.getEntry("1");
        entry.setIfDescr("eth1");
        entry.setIfAdminStatus(1);
        entry.setIfOperStatus(2);
        Capture networkDeviceCapture = new Capture();
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.capture((Capture)networkDeviceCapture), (List)EasyMock.eq(Arrays.asList((OID)NetSnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(IfTable.class))))).andAnswer(() -> {
            ((NetworkDevice)networkDeviceCapture.getValue()).getRootObject().setObject((Object)this.interfaceTable);
            return null;
        });
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Collection alarms = this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1"));
        Assert.assertEquals((long)1L, (long)alarms.size());
        Assert.assertEquals((Object)"Link Down.", (Object)((Alarm)alarms.iterator().next()).description());
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }

    @Test
    public void shouldHandleException() throws UnknownHostException, IOException {
        EasyMock.expect((Object)this.mockSession.getAddress()).andReturn((Object)InetAddress.getLoopbackAddress());
        EasyMock.expect((Object)this.mockSession.walkDevice((IVariableBindingHandler)EasyMock.isA(NetworkDevice.class), (List)EasyMock.eq(Arrays.asList((OID)NetSnmpAlarmProvider.CLASS_REGISTRY.getClassToOidMap().get(IfTable.class))))).andThrow((Throwable)new IOException());
        EasyMock.replay((Object[])new Object[]{this.mockSession});
        Assert.assertNotNull((Object)this.alarmProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1")));
        EasyMock.verify((Object[])new Object[]{this.mockSession});
    }
}

