/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.alarm.impl;

import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpSessionFactory;
import java.io.IOException;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEvent;
import org.onosproject.net.DeviceId;
import org.onosproject.provider.snmp.alarm.impl.SnmpAlarmProviderService;
import org.onosproject.provider.snmp.alarm.impl.SnmpDeviceAlarmProvider;

public class SnmpDeviceAlarmProviderTest {
    private SnmpAlarmProviderService alarmProvider;
    private ISnmpSessionFactory mockSessionFactory;
    private ISnmpSession mockSession;
    private SnmpDeviceAlarmProvider mockProvider;
    private AlarmEvent alarmEvent;

    @Before
    public void setUp() {
        this.mockSessionFactory = (ISnmpSessionFactory)EasyMock.createMock(ISnmpSessionFactory.class);
        this.mockSession = (ISnmpSession)EasyMock.createMock(ISnmpSession.class);
        this.mockProvider = (SnmpDeviceAlarmProvider)EasyMock.createMock(SnmpDeviceAlarmProvider.class);
        this.alarmProvider = new SnmpAlarmProviderService(){

            protected ISnmpSessionFactory getSessionFactory() {
                return SnmpDeviceAlarmProviderTest.this.mockSessionFactory;
            }
        };
        this.alarmProvider.addAlarmListener(event -> {
            this.alarmEvent = event;
        });
    }

    @Test
    public void shouldPopulateAlarmsForNetSnmp() throws IOException {
        this.alarmProvider.providers.put("1.2.3.4", this.mockProvider);
        EasyMock.expect((Object)this.mockSessionFactory.createSession((ISnmpConfiguration)EasyMock.isA(ISnmpConfiguration.class), (String)EasyMock.eq((Object)"1.1.1.1"))).andReturn((Object)this.mockSession);
        EasyMock.expect((Object)this.mockSession.identifyDevice()).andReturn((Object)"1.2.3.4");
        EasyMock.expect((Object)this.mockProvider.getAlarms(this.mockSession, DeviceId.deviceId((String)"snmp:1.1.1.1:161"))).andReturn(new HashSet());
        this.mockSession.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.mockSessionFactory, this.mockSession, this.mockProvider});
        this.alarmProvider.triggerProbe(DeviceId.deviceId((String)"snmp:1.1.1.1:161"));
        EasyMock.verify((Object[])new Object[]{this.mockSessionFactory, this.mockSession, this.mockProvider});
        Assert.assertNotNull((Object)this.alarmEvent);
    }
}

