/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.device.impl;

import com.google.common.base.Preconditions;
import org.onosproject.provider.snmp.device.impl.DeviceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpDevice {
    private final Logger log = LoggerFactory.getLogger(SnmpDevice.class);
    private static final int DEFAULT_SNMP_PORT = 161;
    private final String snmpHost;
    private int snmpPort = 161;
    private final String community;
    private boolean reachable = false;
    private DeviceState deviceState = DeviceState.INVALID;

    protected SnmpDevice(String snmpHost, int snmpPort, String community) {
        this.snmpHost = (String)Preconditions.checkNotNull((Object)snmpHost, (Object)"SNMP Device IP cannot be null");
        this.snmpPort = (Integer)Preconditions.checkNotNull((Object)snmpPort, (Object)"SNMP Device snmp port cannot be null");
        this.community = community;
    }

    public void init() {
        this.reachable = true;
    }

    public String deviceInfo() {
        return "host: " + this.snmpHost + ". port: " + this.snmpPort;
    }

    public void disconnect() {
        this.log.info("disconnect");
        this.reachable = false;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public String getSnmpHost() {
        return this.snmpHost;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public String getCommunity() {
        return this.community;
    }

    public DeviceState getDeviceState() {
        return this.deviceState;
    }

    public void setDeviceState(DeviceState deviceState) {
        this.deviceState = deviceState;
    }

    public boolean isActive() {
        return this.deviceState == DeviceState.ACTIVE;
    }
}

