/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.device.impl;

import com.btisystems.pronx.ems.core.snmp.DefaultSnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfiguration;
import com.btisystems.pronx.ems.core.snmp.ISnmpConfigurationFactory;
import com.btisystems.pronx.ems.core.snmp.ISnmpSession;
import com.btisystems.pronx.ems.core.snmp.ISnmpSessionFactory;
import com.btisystems.pronx.ems.core.snmp.SnmpSessionFactory;
import com.btisystems.pronx.ems.core.snmp.V2cSnmpConfiguration;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.PortDiscovery;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.snmp.device.impl.Bti7000DeviceDescriptionProvider;
import org.onosproject.provider.snmp.device.impl.DeviceState;
import org.onosproject.provider.snmp.device.impl.LumentumDeviceDescriptionProvider;
import org.onosproject.provider.snmp.device.impl.NetSnmpDeviceDescriptionProvider;
import org.onosproject.provider.snmp.device.impl.SnmpDevice;
import org.onosproject.provider.snmp.device.impl.SnmpDeviceDescriptionProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SnmpDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private final Logger log = LoggerFactory.getLogger(SnmpDeviceProvider.class);
    private static final String UNKNOWN = "unknown";
    protected Map<DeviceId, SnmpDevice> snmpDeviceMap = new ConcurrentHashMap<DeviceId, SnmpDevice>();
    private DeviceProviderService providerService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private final ExecutorService deviceBuilder = Executors.newFixedThreadPool(1, Tools.groupedThreads((String)"onos/snmp", (String)"device-creator", (Logger)this.log));
    private static final int EVENTINTERVAL = 5;
    private static final String SCHEME = "snmp";
    @Property(name="devConfigs", value={""}, label="Instance-specific configurations")
    private String devConfigs = null;
    @Property(name="devPasswords", value={""}, label="Instance-specific password")
    private String devPasswords = null;
    Map<String, SnmpDeviceDescriptionProvider> providers = new HashMap<String, SnmpDeviceDescriptionProvider>();
    private final ISnmpSessionFactory sessionFactory = new SnmpSessionFactory((ISnmpConfigurationFactory)new DefaultSnmpConfigurationFactory((ISnmpConfiguration)new V2cSnmpConfiguration()));

    public SnmpDeviceProvider() {
        super(new ProviderId(SCHEME, "org.onosproject.provider.device"));
        this.providers.put("1.3.6.1.4.1.18070.2.2", new Bti7000DeviceDescriptionProvider());
        this.providers.put("1.3.6.1.4.1.20408", new NetSnmpDeviceDescriptionProvider());
        this.providers.put("1.3.6.1.4.562.73.6", new LumentumDeviceDescriptionProvider());
    }

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("activating for snmp devices ...");
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.modified(context);
        this.log.info("activated ok");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.log.info("deactivating for snmp devices ...");
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        try {
            this.snmpDeviceMap.entrySet().stream().forEach(deviceEntry -> this.deviceBuilder.execute(new DeviceCreator((SnmpDevice)deviceEntry.getValue(), false)));
            this.deviceBuilder.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.error("Device builder did not terminate");
        }
        this.deviceBuilder.shutdownNow();
        this.snmpDeviceMap.clear();
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.log.info("modified ...");
        if (context == null) {
            this.log.info("No configuration file");
            return;
        }
        Dictionary properties = context.getProperties();
        this.log.info("properties={}", (Object)context.getProperties());
        String deviceCfgValue = Tools.get((Dictionary)properties, (String)"devConfigs");
        this.log.info("Settings: devConfigs={}", (Object)deviceCfgValue);
        if (!Strings.isNullOrEmpty((String)deviceCfgValue)) {
            this.addOrRemoveDevicesConfig(deviceCfgValue);
        }
        this.log.info("... modified");
    }

    private void addOrRemoveDevicesConfig(String deviceConfig) {
        for (String deviceEntry : deviceConfig.split(",")) {
            SnmpDevice device = this.processDeviceEntry(deviceEntry);
            if (device == null) continue;
            this.log.info("Device Detail:host={}, port={}, state={}", new Object[]{device.getSnmpHost(), device.getSnmpPort(), device.getDeviceState().name()});
            if (device.isActive()) {
                this.deviceBuilder.execute(new DeviceCreator(device, true));
                continue;
            }
            this.deviceBuilder.execute(new DeviceCreator(device, false));
        }
    }

    private SnmpDevice processDeviceEntry(String deviceEntry) {
        if (deviceEntry == null) {
            this.log.info("No content for Device Entry, so cannot proceed further.");
            return null;
        }
        this.log.info("Trying to convert {} to a SNMP Device Object", (Object)deviceEntry);
        SnmpDevice device = null;
        try {
            Integer hostPort;
            String userInfo = deviceEntry.substring(0, deviceEntry.lastIndexOf(64));
            String hostInfo = deviceEntry.substring(deviceEntry.lastIndexOf(64) + 1);
            String[] infoSplit = userInfo.split(":");
            String username = infoSplit[0];
            String password = infoSplit[1];
            infoSplit = hostInfo.split(":");
            String hostIp = infoSplit[0];
            try {
                hostPort = Integer.parseInt(infoSplit[1]);
            }
            catch (NumberFormatException nfe) {
                this.log.error("Bad Configuration Data: Failed to parse host port number string: " + infoSplit[1]);
                throw nfe;
            }
            String deviceState = infoSplit[2];
            if (Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password) || Strings.isNullOrEmpty((String)hostIp) || hostPort == 0) {
                this.log.warn("Bad Configuration Data: both user and device information parts of Configuration " + deviceEntry + " should be non-nullable");
            } else {
                device = new SnmpDevice(hostIp, hostPort, password);
                if (!Strings.isNullOrEmpty((String)deviceState)) {
                    if (deviceState.toUpperCase().equals(DeviceState.ACTIVE.name())) {
                        device.setDeviceState(DeviceState.ACTIVE);
                    } else if (deviceState.toUpperCase().equals(DeviceState.INACTIVE.name())) {
                        device.setDeviceState(DeviceState.INACTIVE);
                    } else {
                        this.log.warn("Device State Information can not be empty, so marking the state as INVALID");
                        device.setDeviceState(DeviceState.INVALID);
                    }
                } else {
                    this.log.warn("The device entry do not specify state information, so marking the state as INVALID");
                    device.setDeviceState(DeviceState.INVALID);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            this.log.error("Error while reading config infromation from the config file: The user, host and device state infomation should be in the order 'userInfo@hostInfo:deviceState'" + deviceEntry, (Throwable)aie);
        }
        catch (Exception e) {
            this.log.error("Error while parsing config information for the device entry: " + deviceEntry, (Throwable)e);
        }
        return device;
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        SnmpDevice snmpDevice = this.snmpDeviceMap.get(deviceId);
        if (snmpDevice == null) {
            this.log.warn("BAD REQUEST: the requested device id: " + deviceId.toString() + "  is not associated to any SNMP Device");
            return false;
        }
        return snmpDevice.isReachable();
    }

    protected ISnmpSessionFactory getSessionFactory(ISnmpConfigurationFactory configurationFactory) {
        return new SnmpSessionFactory(configurationFactory);
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private class DeviceCreator
    implements Runnable {
        private SnmpDevice device;
        private boolean createFlag;

        public DeviceCreator(SnmpDevice device, boolean createFlag) {
            this.device = device;
            this.createFlag = createFlag;
        }

        @Override
        public void run() {
            if (this.createFlag) {
                SnmpDeviceProvider.this.log.info("Trying to create Device Info on ONOS core");
                this.advertiseDevices();
            } else {
                SnmpDeviceProvider.this.log.info("Trying to remove Device Info on ONOS core");
                this.removeDevices();
            }
        }

        private void removeDevices() {
            if (this.device == null) {
                SnmpDeviceProvider.this.log.warn("The Request SNMP Device is null, cannot proceed further");
                return;
            }
            try {
                DeviceId did = this.getDeviceId();
                if (!SnmpDeviceProvider.this.snmpDeviceMap.containsKey(did)) {
                    SnmpDeviceProvider.this.log.error("BAD Request: 'Currently device is not discovered, so cannot remove/disconnect the device: " + this.device.deviceInfo() + "'");
                    return;
                }
                SnmpDeviceProvider.this.providerService.deviceDisconnected(did);
                this.device.disconnect();
                SnmpDeviceProvider.this.snmpDeviceMap.remove(did);
                Tools.delay((int)5);
            }
            catch (URISyntaxException uriSyntaxExcpetion) {
                SnmpDeviceProvider.this.log.error("Syntax Error while creating URI for the device: " + this.device.deviceInfo() + " couldn't remove the device from the store", (Throwable)uriSyntaxExcpetion);
            }
        }

        private void advertiseDevices() {
            try {
                if (this.device == null) {
                    SnmpDeviceProvider.this.log.warn("The Request SNMP Device is null, cannot proceed further");
                    return;
                }
                this.device.init();
                DeviceId did = this.getDeviceId();
                ChassisId cid = new ChassisId();
                DefaultAnnotations annotations = DefaultAnnotations.builder().set("protocol", SnmpDeviceProvider.SCHEME.toUpperCase()).build();
                DefaultDeviceDescription desc = new DefaultDeviceDescription(did.uri(), Device.Type.OTHER, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, cid, new SparseAnnotations[]{annotations});
                desc = this.populateDescriptionFromDevice(did, (DeviceDescription)desc);
                SnmpDeviceProvider.this.log.info("Persisting Device " + did.uri().toString());
                SnmpDeviceProvider.this.snmpDeviceMap.put(did, this.device);
                SnmpDeviceProvider.this.providerService.deviceConnected(did, (DeviceDescription)desc);
                SnmpDeviceProvider.this.log.info("Done with Device Info Creation on ONOS core. Device Info: " + this.device.deviceInfo() + " " + did.uri().toString());
                Device d = SnmpDeviceProvider.this.deviceService.getDevice(did);
                if (d.is(PortDiscovery.class)) {
                    PortDiscovery portConfig = (PortDiscovery)d.as(PortDiscovery.class);
                    if (portConfig != null) {
                        SnmpDeviceProvider.this.providerService.updatePorts(did, portConfig.getPorts());
                    }
                } else {
                    SnmpDeviceProvider.this.log.warn("No port discovery behaviour for device {}", (Object)did);
                }
                Tools.delay((int)5);
            }
            catch (URISyntaxException e) {
                SnmpDeviceProvider.this.log.error("Syntax Error while creating URI for the device: " + this.device.deviceInfo() + " couldn't persist the device onto the store", (Throwable)e);
            }
            catch (Exception e) {
                SnmpDeviceProvider.this.log.error("Error while initializing session for the device: " + (this.device != null ? this.device.deviceInfo() : null), (Throwable)e);
            }
        }

        @Deprecated
        private DeviceDescription populateDescriptionFromDevice(DeviceId did, DeviceDescription desc) {
            String[] deviceComponents = did.toString().split(":");
            if (deviceComponents.length > 1) {
                String ipAddress = deviceComponents[1];
                String port = deviceComponents[2];
                V2cSnmpConfiguration config = new V2cSnmpConfiguration();
                config.setPort(Integer.parseInt(port));
                try (ISnmpSession session = SnmpDeviceProvider.this.sessionFactory.createSession((ISnmpConfiguration)config, ipAddress);){
                    String deviceOid = session.identifyDevice();
                    if (SnmpDeviceProvider.this.providers.containsKey(deviceOid)) {
                        desc = SnmpDeviceProvider.this.providers.get(deviceOid).populateDescription(session, desc);
                    }
                }
                catch (IOException | RuntimeException ex) {
                    SnmpDeviceProvider.this.log.error("Failed to walk device.", (Object)ex.getMessage());
                    SnmpDeviceProvider.this.log.debug("Detailed problem was ", (Throwable)ex);
                }
            }
            return desc;
        }

        private DeviceId getDeviceId() throws URISyntaxException {
            String additionalSsp = this.device.getSnmpHost() + ":" + this.device.getSnmpPort();
            return DeviceId.deviceId((URI)new URI(SnmpDeviceProvider.SCHEME, additionalSsp, null));
        }
    }
}

