/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.provider.snmp.device.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.ChassisId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.config.basics.ConfigException;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceDescriptionDiscovery;
import org.onosproject.net.device.DeviceProvider;
import org.onosproject.net.device.DeviceProviderRegistry;
import org.onosproject.net.device.DeviceProviderService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.provider.AbstractProvider;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.provider.snmp.device.impl.SnmpProviderConfig;
import org.onosproject.snmp.SnmpController;
import org.onosproject.snmp.SnmpDevice;
import org.onosproject.snmp.ctl.DefaultSnmpDevice;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class SnmpDeviceProvider
extends AbstractProvider
implements DeviceProvider {
    private final Logger log = LoggerFactory.getLogger(SnmpDeviceProvider.class);
    private static final String UNKNOWN = "unknown";
    private static final String APP_NAME = "org.onosproject.snmp";
    private static final String SCHEME = "snmp";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SnmpController controller;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceProviderRegistry providerRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceStore deviceStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netCfgService;
    protected DeviceProviderService providerService;
    protected ApplicationId appId;
    private final ExecutorService deviceBuilderExecutor = Executors.newFixedThreadPool(5, Tools.groupedThreads((String)"onos/snmp", (String)"device-creator", (Logger)this.log));
    protected final NetworkConfigListener cfgLister = new InternalNetworkConfigListener();
    protected final ConfigFactory factory = new ConfigFactory<ApplicationId, SnmpProviderConfig>(SubjectFactories.APP_SUBJECT_FACTORY, SnmpProviderConfig.class, "devices", true){

        public SnmpProviderConfig createConfig() {
            return new SnmpProviderConfig();
        }
    };

    public SnmpDeviceProvider() {
        super(new ProviderId(SCHEME, "org.onosproject.provider.device"));
    }

    @Activate
    public void activate(ComponentContext context) {
        this.providerService = (DeviceProviderService)this.providerRegistry.register((Provider)this);
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.netCfgService.registerConfigFactory(this.factory);
        this.netCfgService.addListener((EventListener)this.cfgLister);
        this.modified(context);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        try {
            this.controller.getDevices().stream().forEach(device -> this.deviceBuilderExecutor.execute(new DeviceFactory((SnmpDevice)device, false)));
            this.deviceBuilderExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.log.error("Device builder did not terminate");
        }
        this.deviceBuilderExecutor.shutdownNow();
        this.netCfgService.unregisterConfigFactory(this.factory);
        this.netCfgService.removeListener((EventListener)this.cfgLister);
        this.providerRegistry.unregister((Provider)this);
        this.providerService = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.log.info("Modified");
    }

    private void addOrRemoveDevicesConfig() {
        SnmpProviderConfig cfg = (SnmpProviderConfig)this.netCfgService.getConfig((Object)this.appId, SnmpProviderConfig.class);
        if (cfg != null) {
            try {
                cfg.getDevicesInfo().stream().forEach(info -> {
                    DefaultSnmpDevice device = new DefaultSnmpDevice(info.ip().toString(), info.port(), info.username(), info.password());
                    this.buildDevice((SnmpDevice)device);
                });
            }
            catch (ConfigException e) {
                this.log.error("Cannot read config error " + (Object)((Object)e));
            }
        }
    }

    private void buildDevice(SnmpDevice device) {
        if (device != null) {
            this.log.debug("Device Detail:host={}, port={}, state={}", new Object[]{device.getSnmpHost(), device.getSnmpPort(), device.isReachable()});
            if (device.isReachable()) {
                this.deviceBuilderExecutor.execute(new DeviceFactory(device, true));
            } else {
                this.deviceBuilderExecutor.execute(new DeviceFactory(device, false));
            }
        }
    }

    public void triggerProbe(DeviceId deviceId) {
    }

    public void roleChanged(DeviceId deviceId, MastershipRole newRole) {
    }

    public boolean isReachable(DeviceId deviceId) {
        SnmpDevice snmpDevice = this.controller.getDevice(deviceId);
        if (snmpDevice == null) {
            this.log.warn("BAD REQUEST: the requested device id: " + deviceId.toString() + "  is not associated to any SNMP Device");
            return false;
        }
        return snmpDevice.isReachable();
    }

    public void changePortState(DeviceId deviceId, PortNumber portNumber, boolean enable) {
    }

    protected void bindController(SnmpController snmpController) {
        this.controller = snmpController;
    }

    protected void unbindController(SnmpController snmpController) {
        if (this.controller == snmpController) {
            this.controller = null;
        }
    }

    protected void bindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        this.providerRegistry = deviceProviderRegistry;
    }

    protected void unbindProviderRegistry(DeviceProviderRegistry deviceProviderRegistry) {
        if (this.providerRegistry == deviceProviderRegistry) {
            this.providerRegistry = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindDeviceStore(DeviceStore deviceStore) {
        this.deviceStore = deviceStore;
    }

    protected void unbindDeviceStore(DeviceStore deviceStore) {
        if (this.deviceStore == deviceStore) {
            this.deviceStore = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.netCfgService = networkConfigRegistry;
    }

    protected void unbindNetCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netCfgService == networkConfigRegistry) {
            this.netCfgService = null;
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            SnmpDeviceProvider.this.addOrRemoveDevicesConfig();
        }

        public boolean isRelevant(NetworkConfigEvent event) {
            return event.configClass().equals(SnmpProviderConfig.class) && (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED || event.type() == NetworkConfigEvent.Type.CONFIG_UPDATED);
        }
    }

    private class DeviceFactory
    implements Runnable {
        private SnmpDevice device;
        private boolean createFlag;

        public DeviceFactory(SnmpDevice device, boolean createFlag) {
            this.device = device;
            this.createFlag = createFlag;
        }

        @Override
        public void run() {
            if (this.createFlag) {
                SnmpDeviceProvider.this.log.debug("Trying to create Device Info on ONOS core");
                this.advertiseDevices();
            } else {
                SnmpDeviceProvider.this.log.debug("Trying to remove Device Info on ONOS core");
                this.removeDevices();
            }
        }

        private void removeDevices() {
            if (this.device == null) {
                SnmpDeviceProvider.this.log.warn("The Request SNMP Device is null, cannot proceed further");
                return;
            }
            DeviceId did = this.device.deviceId();
            if (SnmpDeviceProvider.this.controller.getDevice(did) == null) {
                SnmpDeviceProvider.this.log.error("BAD Request: 'Currently device is not discovered, so cannot remove/disconnect the device: " + this.device.deviceInfo() + "'");
                return;
            }
            SnmpDeviceProvider.this.providerService.deviceDisconnected(did);
            this.device.disconnect();
            SnmpDeviceProvider.this.controller.removeDevice(did);
        }

        private void advertiseDevices() {
            try {
                if (this.device == null) {
                    SnmpDeviceProvider.this.log.warn("The Request SNMP Device is null, cannot proceed further");
                    return;
                }
                DeviceId did = this.device.deviceId();
                ChassisId cid = new ChassisId();
                DefaultAnnotations annotations = DefaultAnnotations.builder().set("protocol", SnmpDeviceProvider.SCHEME.toUpperCase()).build();
                DefaultDeviceDescription desc = new DefaultDeviceDescription(did.uri(), Device.Type.OTHER, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, SnmpDeviceProvider.UNKNOWN, cid, new SparseAnnotations[]{annotations});
                SnmpDeviceProvider.this.log.debug("Persisting Device " + did.uri().toString());
                SnmpDeviceProvider.this.controller.addDevice(did, this.device);
                SnmpDeviceProvider.this.providerService.deviceConnected(did, (DeviceDescription)desc);
                SnmpDeviceProvider.this.log.info("Added device to ONOS core. Device Info: " + this.device.deviceInfo() + " " + did.uri().toString());
                Device d = SnmpDeviceProvider.this.deviceService.getDevice(did);
                if (d.is(DeviceDescriptionDiscovery.class)) {
                    DeviceDescriptionDiscovery descriptionDiscovery = (DeviceDescriptionDiscovery)d.as(DeviceDescriptionDiscovery.class);
                    DeviceDescription description = descriptionDiscovery.discoverDeviceDetails();
                    SnmpDeviceProvider.this.deviceStore.createOrUpdateDevice(new ProviderId(SnmpDeviceProvider.SCHEME, "org.onosproject.provider.device"), did, description);
                    SnmpDeviceProvider.this.providerService.updatePorts(did, descriptionDiscovery.discoverPortDetails());
                } else {
                    SnmpDeviceProvider.this.log.warn("No populate description and ports behaviour for device {}", (Object)did);
                }
            }
            catch (Exception e) {
                SnmpDeviceProvider.this.log.error("Error while initializing session for the device: " + (this.device != null ? this.device.deviceInfo() : null), (Throwable)e);
            }
        }
    }
}

