/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yangutils.datamodel;

import java.io.Serializable;
import java.util.Set;
import org.onosproject.yangutils.datamodel.DefaultLocationInfo;
import org.onosproject.yangutils.datamodel.YangModule;
import org.onosproject.yangutils.datamodel.YangNode;
import org.onosproject.yangutils.datamodel.exceptions.DataModelException;
import org.onosproject.yangutils.datamodel.utils.DataModelUtils;
import org.onosproject.yangutils.datamodel.utils.Parsable;
import org.onosproject.yangutils.datamodel.utils.YangConstructType;

public class YangBelongsTo
extends DefaultLocationInfo
implements Parsable,
Serializable {
    private static final long serialVersionUID = 806201639L;
    private String belongsToModuleName;
    private YangNode moduleNode;
    private String prefix;

    public String getBelongsToModuleName() {
        return this.belongsToModuleName;
    }

    public void setBelongsToModuleName(String belongsToModuleName) {
        this.belongsToModuleName = belongsToModuleName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public YangNode getModuleNode() {
        return this.moduleNode;
    }

    public void setModuleNode(YangNode moduleNode) {
        this.moduleNode = moduleNode;
    }

    @Override
    public YangConstructType getYangConstructType() {
        return YangConstructType.BELONGS_TO_DATA;
    }

    @Override
    public void validateDataOnEntry() throws DataModelException {
    }

    @Override
    public void validateDataOnExit() throws DataModelException {
    }

    public void linkWithModule(Set<YangNode> yangNodeSet) throws DataModelException {
        String belongsToModuleName = this.getBelongsToModuleName();
        YangNode moduleNode = DataModelUtils.findReferredNode(yangNodeSet, belongsToModuleName);
        if (moduleNode != null && moduleNode instanceof YangModule) {
            this.setModuleNode(moduleNode);
            return;
        }
        DataModelException exception = new DataModelException("YANG file error : Module " + belongsToModuleName + "to which sub-module belongs to is not found. " + " in " + this.getLineNumber() + " at " + this.getCharPosition() + " in " + this.getFileName());
        exception.setLine(this.getLineNumber());
        exception.setCharPosition(this.getCharPosition());
        throw exception;
    }
}

